/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank.render;

import crazypants.enderio.ModObject;
import crazypants.enderio.machine.capbank.BlockCapBank;
import crazypants.enderio.machine.capbank.CapBankType;
import crazypants.enderio.machine.capbank.render.FillGaugeBakery;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.enderio.render.ICacheKey;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.property.EnumMergingBlockRenderMode;
import crazypants.enderio.render.util.ItemQuadCollector;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class CapBankItemRenderMapper
implements IRenderMapper.IItemRenderMapper.IItemStateMapper,
IRenderMapper.IItemRenderMapper.IDynamicOverlayMapper {
    @Override
    @SideOnly(value=Side.CLIENT)
    public List<Pair<IBlockState, ItemStack>> mapItemRender(Block block, ItemStack stack, ItemQuadCollector itemQuadCollector) {
        ArrayList<Pair<IBlockState, ItemStack>> states = new ArrayList<Pair<IBlockState, ItemStack>>();
        IBlockState defaultState = block.func_176223_P();
        states.add(Pair.of((Object)defaultState.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.sides)).func_177226_a(CapBankType.KIND, (Comparable)((Object)CapBankType.NONE)), (Object)null));
        CapBankType bankType = CapBankType.getTypeFromMeta(stack.func_77952_i());
        defaultState = defaultState.func_177226_a(CapBankType.KIND, (Comparable)((Object)bankType));
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            states.add((Pair<IBlockState, ItemStack>)Pair.of((Object)defaultState.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.get(facing, EnumFacing.UP))), (Object)null));
            states.add((Pair<IBlockState, ItemStack>)Pair.of((Object)defaultState.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.get(facing, EnumFacing.DOWN))), (Object)null));
            states.add((Pair<IBlockState, ItemStack>)Pair.of((Object)defaultState.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.get(facing, facing.func_176735_f()))), (Object)null));
            states.add((Pair<IBlockState, ItemStack>)Pair.of((Object)defaultState.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.get(facing, facing.func_176735_f(), EnumFacing.UP))), (Object)null));
            states.add((Pair<IBlockState, ItemStack>)Pair.of((Object)defaultState.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.get(facing, facing.func_176735_f(), EnumFacing.DOWN))), (Object)null));
        }
        return states;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemQuadCollector mapItemDynamicOverlayRender(Block block, ItemStack stack) {
        int maxEnergy;
        IEnergyStorage energyItem = PowerHandlerUtil.getCapability((ICapabilityProvider)stack, null);
        if (energyItem != null && (maxEnergy = energyItem.getMaxEnergyStored()) > 0) {
            int energy = energyItem.getEnergyStored();
            FillGaugeBakery gauge = new FillGaugeBakery(((BlockCapBank)ModObject.blockCapBank.getBlock()).getGaugeIcon(), (double)energy / (double)maxEnergy);
            if (gauge.canRender()) {
                ItemQuadCollector result = new ItemQuadCollector();
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
                gauge.bake(quads);
                result.addQuads(null, quads);
                return result;
            }
        }
        return null;
    }

    @Override
    @Nonnull
    public ICacheKey getCacheKey(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ICacheKey cacheKey) {
        return cacheKey;
    }
}

