/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import crazypants.enderio.machine.farm.FarmNotification;
import crazypants.enderio.machine.farm.FarmStationContainer;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.IFarmerJoe;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.util.Prep;
import crazypants.util.Things;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class FlowerPicker
implements IFarmerJoe {
    protected Things flowers = new Things(new String[0]);

    public FlowerPicker(Things flowers) {
        this.add(flowers);
    }

    public FlowerPicker add(Things newFlowers) {
        this.flowers.add(newFlowers);
        FarmStationContainer.slotItemsProduce.addAll(newFlowers.getItemStacks());
        return this;
    }

    @Override
    public boolean prepareBlock(TileFarmStation farm, BlockPos bc, Block block, IBlockState meta) {
        return false;
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockPos bc, Block block, IBlockState meta) {
        return this.flowers.contains(block) || block instanceof IShearable;
    }

    @Override
    public boolean canPlant(ItemStack stack) {
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockPos bc, Block block, IBlockState meta) {
        World worldObj = farm.func_145831_w();
        List drops = null;
        if (block instanceof IShearable) {
            if (!farm.hasShears()) {
                farm.setNotification(FarmNotification.NO_SHEARS);
                return null;
            }
            ItemStack shears = farm.getTool(TileFarmStation.ToolType.SHEARS);
            if (!((IShearable)block).isShearable(shears, (IBlockAccess)worldObj, bc)) {
                return null;
            }
            drops = ((IShearable)block).onSheared(shears, (IBlockAccess)worldObj, bc, farm.getMaxLootingValue());
            farm.damageShears(block, bc);
        } else {
            if (!farm.hasHoe()) {
                farm.setNotification(FarmNotification.NO_HOE);
                return null;
            }
            drops = block.getDrops((IBlockAccess)worldObj, bc, meta, farm.getMaxLootingValue());
            farm.damageHoe(1, bc);
        }
        farm.actionPerformed(false);
        ArrayList<EntityItem> result = new ArrayList<EntityItem>();
        if (drops != null) {
            for (ItemStack stack : drops) {
                if (!Prep.isValid(stack)) continue;
                result.add(new EntityItem(worldObj, (double)bc.func_177958_n() + 0.5, (double)bc.func_177956_o() + 0.5, (double)bc.func_177952_p() + 0.5, stack.func_77946_l()));
            }
        }
        worldObj.func_175698_g(bc);
        return new HarvestResult(result, bc);
    }
}

