/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel.client;

import crazypants.enderio.Log;
import crazypants.enderio.machine.invpanel.client.InventoryDatabaseClient;
import java.util.HashMap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class ClientDatabaseManager {
    public static final ClientDatabaseManager INSTANCE = new ClientDatabaseManager();
    private final HashMap<Integer, InventoryDatabaseClient> dbRegistry = new HashMap();

    private ClientDatabaseManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public InventoryDatabaseClient getOrCreateDatabase(int generation) {
        InventoryDatabaseClient db = this.dbRegistry.get(generation);
        if (db == null) {
            db = new InventoryDatabaseClient(generation);
            this.dbRegistry.put(generation, db);
        }
        return db;
    }

    public void destroyDatabase(int generation) {
        this.dbRegistry.remove(generation);
    }

    @SubscribeEvent
    public void on(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        Log.info("Clearing Inventory Panel Client Database");
        this.dbRegistry.clear();
    }
}

