/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel.client;

import crazypants.enderio.machine.invpanel.ItemEntryBase;
import java.util.Locale;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;

public class ItemEntry
extends ItemEntryBase {
    String name;
    String modId;
    String lowerCaseLocName;
    private int count;
    private ItemStack stack;

    public ItemEntry(int dbID, int hash, int itemID, int meta, NBTTagCompound nbt) {
        super(dbID, hash, itemID, meta, nbt);
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
        this.stack = null;
    }

    public ItemStack makeItemStack() {
        if (this.stack == null) {
            this.stack = new ItemStack(this.getItem(), this.getCount(), this.meta);
            this.stack.func_77982_d(this.nbt);
        }
        return this.stack;
    }

    public String getUnlocName() {
        if (this.name == null) {
            this.findUnlocName();
        }
        return this.name;
    }

    public String getLowercaseUnlocName(Locale locale) {
        if (this.lowerCaseLocName == null) {
            this.lowerCaseLocName = I18n.func_74838_a((String)this.getUnlocName()).toLowerCase(locale);
        }
        return this.lowerCaseLocName;
    }

    private void findUnlocName() {
        ItemStack stack = this.makeItemStack();
        try {
            this.name = stack.func_82833_r();
            if (this.name == null || this.name.isEmpty()) {
                this.name = stack.func_77973_b().func_77658_a();
                if (this.name == null || this.name.isEmpty()) {
                    this.name = stack.func_77973_b().getClass().getName();
                }
            }
        }
        catch (Throwable ex) {
            this.name = "Exception: " + ex.getMessage();
        }
    }

    public String getModId() {
        if (this.modId == null) {
            this.findModId();
        }
        return this.modId;
    }

    private void findModId() {
        ResourceLocation resourceName;
        Item item = this.getItem();
        if (item != null && (resourceName = item.delegate.name()) != null) {
            this.modId = resourceName.func_110624_b();
        }
        if (this.modId == null) {
            this.modId = "Unknown";
        }
    }

    @Override
    public String toString() {
        return "ItemEntry [name=" + this.name + ", modId=" + this.modId + ", lowerCaseLocName=" + this.lowerCaseLocName + ", count=" + this.count + ", super=" + super.toString() + "]";
    }
}

