/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.monitor;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.button.CheckBox;
import com.enderio.core.client.gui.button.InvisibleButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.gui.widget.TextFieldEnder;
import com.enderio.core.client.render.ColorUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.capbank.BlockItemCapBank;
import crazypants.enderio.machine.gui.GuiPoweredMachineBase;
import crazypants.enderio.machine.monitor.BlockPowerMonitor;
import crazypants.enderio.machine.monitor.ContainerPowerMonitor;
import crazypants.enderio.machine.monitor.PacketPowerMonitorConfig;
import crazypants.enderio.machine.monitor.StatCollector;
import crazypants.enderio.machine.monitor.TilePowerMonitor;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.PowerDisplayUtil;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiPowerMonitor
extends GuiPoweredMachineBase<TilePowerMonitor> {
    protected Tab tab = Tab.GRAPH;
    protected int timebase = 2;
    protected int timebaseOffset = 0;
    protected InvisibleButton plus = new InvisibleButton((IGuiScreen)this, 1, 154, 28);
    protected InvisibleButton minus;
    private CheckBox engineControlEnabled;
    private TextFieldEnder engineControlStart;
    private TextFieldEnder engineControlStop;
    private boolean engineControlEnabled_value;
    private String engineControlStart_value = null;
    private String engineControlStop_value;
    private GuiToolTip tooltipConduitStorage;
    private GuiToolTip tooltipCapacitorBankStorage;
    private GuiToolTip tooltipMachineBuffers;
    private GuiToolTip tooltipAverageOutput;
    private GuiToolTip tooltipAverageInput;
    private long lastTick = 0L;
    private static final int TEXT_MARGIN_TOP = 7;
    private static final int TEXT_MARGIN_LEFT = 7;
    private static final int TEXT_WIDTH = 162;
    private static final int LINE_Y_OFFSET = 18;
    private static final int TEXT_X_OFFSET = 18;
    private static final int TEXT_Y_OFFSET = 4;
    private static final int CONTROL_LF_PX = 16;

    public GuiPowerMonitor(@Nonnull InventoryPlayer par1InventoryPlayer, @Nonnull TilePowerMonitor te) {
        super(te, (Container)new ContainerPowerMonitor(par1InventoryPlayer, te), "pmon", "pmon2");
        this.plus.setToolTip(new String[]{"+"});
        this.minus = new InvisibleButton((IGuiScreen)this, 2, 154, 52);
        this.minus.setToolTip(new String[]{"-"});
        for (Tab drawTab : Tab.values()) {
            drawTab.button = new InvisibleButton((IGuiScreen)this, 3, 0, 0);
        }
        if (!te.isAdvanced()) {
            this.tab = Tab.STAT;
        }
        this.engineControlEnabled = new CheckBox((IGuiScreen)this, 4, 0, 0);
        this.engineControlEnabled.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.enabled")});
        this.engineControlEnabled.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.disabled")});
        this.engineControlStart = new TextFieldEnder(this.getFontRenderer(), 0, 0, 28, 14);
        this.engineControlStart.func_146205_d(true);
        this.engineControlStart.func_146203_f(3);
        this.textFields.add(this.engineControlStart);
        this.engineControlStop = new TextFieldEnder(this.getFontRenderer(), 0, 0, 28, 14);
        this.engineControlStop.func_146205_d(true);
        this.engineControlStop.func_146203_f(3);
        this.textFields.add(this.engineControlStop);
        this.tooltipConduitStorage = new GuiToolTip(new Rectangle(0, 0, 0, 0), new String[]{EnderIO.lang.localize("gui.powerMonitor.monHeading1")});
        this.addToolTip(this.tooltipConduitStorage);
        this.tooltipCapacitorBankStorage = new GuiToolTip(new Rectangle(0, 0, 0, 0), new String[]{EnderIO.lang.localize("gui.powerMonitor.monHeading2")});
        this.addToolTip(this.tooltipCapacitorBankStorage);
        this.tooltipMachineBuffers = new GuiToolTip(new Rectangle(0, 0, 0, 0), new String[]{EnderIO.lang.localize("gui.powerMonitor.monHeading3")});
        this.addToolTip(this.tooltipMachineBuffers);
        this.tooltipAverageOutput = new GuiToolTip(new Rectangle(0, 0, 0, 0), new String[]{EnderIO.lang.localize("gui.powerMonitor.monHeading4")});
        this.addToolTip(this.tooltipAverageOutput);
        this.tooltipAverageInput = new GuiToolTip(new Rectangle(0, 0, 0, 0), new String[]{EnderIO.lang.localize("gui.powerMonitor.monHeading5")});
        this.addToolTip(this.tooltipAverageInput);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.redstoneButton.field_146125_m = false;
        this.configB.field_146125_m = false;
        this.plus.onGuiInit();
        this.minus.onGuiInit();
        for (Tab drawTab : Tab.values()) {
            drawTab.button.onGuiInit();
        }
        this.engineControlEnabled.onGuiInit();
    }

    protected void updateVisibility() {
        switch (this.tab) {
            case GRAPH: {
                if (!((TilePowerMonitor)this.getTileEntity()).isAdvanced()) {
                    this.tab = Tab.STAT;
                    this.updateVisibility();
                    return;
                }
                this.plus.field_146124_l = this.timebase < 6;
                this.minus.field_146124_l = this.timebase > 0;
                this.engineControlEnabled.field_146125_m = false;
                this.engineControlStart.func_146189_e(false);
                this.engineControlStop.func_146189_e(false);
                this.tooltipConduitStorage.setIsVisible(false);
                this.tooltipCapacitorBankStorage.setIsVisible(false);
                this.tooltipMachineBuffers.setIsVisible(false);
                this.tooltipAverageOutput.setIsVisible(false);
                this.tooltipAverageInput.setIsVisible(false);
                break;
            }
            case STAT: {
                this.minus.field_146124_l = false;
                this.plus.field_146124_l = false;
                this.engineControlEnabled.field_146125_m = false;
                this.engineControlStart.func_146189_e(false);
                this.engineControlStop.func_146189_e(false);
                this.tooltipConduitStorage.setIsVisible(true);
                this.tooltipCapacitorBankStorage.setIsVisible(true);
                this.tooltipMachineBuffers.setIsVisible(true);
                this.tooltipAverageOutput.setIsVisible(true);
                this.tooltipAverageInput.setIsVisible(true);
                break;
            }
            case CONTROL: {
                this.minus.field_146124_l = false;
                this.plus.field_146124_l = false;
                this.engineControlEnabled.field_146125_m = true;
                this.engineControlStart.func_146189_e(true);
                this.engineControlStop.func_146189_e(true);
                this.tooltipConduitStorage.setIsVisible(false);
                this.tooltipCapacitorBankStorage.setIsVisible(false);
                this.tooltipMachineBuffers.setIsVisible(false);
                this.tooltipAverageOutput.setIsVisible(false);
                this.tooltipAverageInput.setIsVisible(false);
                if (this.engineControlStart_value == null) {
                    this.engineControlEnabled_value = ((TilePowerMonitor)this.getTileEntity()).isEngineControlEnabled();
                    this.engineControlEnabled.setSelected(this.engineControlEnabled_value);
                    this.engineControlStart_value = PowerDisplayUtil.formatInteger(((TilePowerMonitor)this.getTileEntity()).getStartLevel() * 100.0f);
                    this.engineControlStart.func_146180_a(this.engineControlStart_value);
                    this.engineControlStop_value = PowerDisplayUtil.formatInteger(((TilePowerMonitor)this.getTileEntity()).getStopLevel() * 100.0f);
                    this.engineControlStop.func_146180_a(this.engineControlStop_value);
                }
                if (this.engineControlEnabled_value != this.engineControlEnabled.isSelected() || !this.engineControlStart_value.equals(this.engineControlStart.func_146179_b()) || !this.engineControlStop_value.equals(this.engineControlStop.func_146179_b())) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketPowerMonitorConfig((TilePowerMonitor)this.getTileEntity(), this.engineControlEnabled.isSelected(), (float)this.getInt((GuiTextField)this.engineControlStart) / 100.0f, (float)this.getInt((GuiTextField)this.engineControlStop) / 100.0f));
                    ((TilePowerMonitor)this.getTileEntity()).setEngineControlEnabled(this.engineControlEnabled.isSelected());
                    ((TilePowerMonitor)this.getTileEntity()).setStartLevel((float)this.getInt((GuiTextField)this.engineControlStart) / 100.0f);
                    ((TilePowerMonitor)this.getTileEntity()).setStopLevel((float)this.getInt((GuiTextField)this.engineControlStop) / 100.0f);
                }
                if (this.engineControlEnabled_value == ((TilePowerMonitor)this.getTileEntity()).isEngineControlEnabled() && this.engineControlStart_value.equals(PowerDisplayUtil.formatInteger(((TilePowerMonitor)this.getTileEntity()).getStartLevel() * 100.0f)) && this.engineControlStop_value.equals(PowerDisplayUtil.formatInteger(((TilePowerMonitor)this.getTileEntity()).getStopLevel() * 100.0f))) break;
                this.engineControlEnabled_value = ((TilePowerMonitor)this.getTileEntity()).isEngineControlEnabled();
                this.engineControlEnabled.setSelected(this.engineControlEnabled_value);
                this.engineControlStart_value = PowerDisplayUtil.formatInteger(((TilePowerMonitor)this.getTileEntity()).getStartLevel() * 100.0f);
                this.engineControlStart.func_146180_a(this.engineControlStart_value);
                this.engineControlStop_value = PowerDisplayUtil.formatInteger(((TilePowerMonitor)this.getTileEntity()).getStopLevel() * 100.0f);
                this.engineControlStop.func_146180_a(this.engineControlStop_value);
            }
        }
        for (Tab drawTab : Tab.values()) {
            drawTab.button.field_146124_l = drawTab != this.tab;
        }
    }

    protected void func_146284_a(GuiButton btn) {
        if (btn == this.plus) {
            if (this.timebase >= 6) {
                return;
            }
            ++this.timebase;
            this.timebaseOffset -= 16;
        } else if (btn == this.minus) {
            if (this.timebase <= 0) {
                return;
            }
            --this.timebase;
            this.timebaseOffset += 16;
        } else {
            for (Tab drawTab : Tab.values()) {
                if (btn != drawTab.button) continue;
                this.tab = drawTab;
                return;
            }
        }
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    @Override
    protected int getPowerX() {
        return 8;
    }

    @Override
    protected int getPowerY() {
        return 10;
    }

    @Override
    protected int getPowerWidth() {
        return 4;
    }

    @Override
    protected int getPowerHeight() {
        return 66;
    }

    private void drawTimebase(int x, int y) {
        int u = 200;
        int v = this.timebase * 16 + this.timebaseOffset;
        int w = 18;
        int h = 16;
        if (v < 0) {
            v = 0;
        } else if (v > 96) {
            v = 96;
        }
        this.func_73729_b(x, y, u, v, w, h);
        if (this.lastTick != EnderIO.proxy.getTickCount()) {
            this.lastTick = EnderIO.proxy.getTickCount();
            if (this.timebaseOffset < 0) {
                this.timebaseOffset += 1 - this.timebaseOffset / 8;
            } else if (this.timebaseOffset > 0) {
                this.timebaseOffset -= 1 + this.timebaseOffset / 8;
            }
        }
    }

    private void drawGraph(int x, int y) {
        StatCollector stat = ((TilePowerMonitor)this.getTileEntity()).getStatCollector(this.timebase);
        int[][] values = stat.getValues();
        for (int i = 0; i < 100; ++i) {
            int min = values[0][i];
            int max = values[1][i];
            this.func_73729_b(x + i, y + 63 - max, 220, 63 - max, 1, max - min + 1);
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.updateVisibility();
        switch (this.tab) {
            case GRAPH: {
                this.bindGuiTexture(0);
                this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
                this.drawTimebase(sx + 149, sy + 35);
                this.drawGraph(sx + 48, sy + 11);
                break;
            }
            case STAT: {
                this.bindGuiTexture(1);
                this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
                this.drawStats(sx, sy);
                this.bindGuiTexture(1);
                break;
            }
            case CONTROL: {
                this.bindGuiTexture(1);
                this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
                this.drawControls(sx, sy);
                this.bindGuiTexture(1);
            }
        }
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.startTabs();
        for (Tab drawTab : Tab.values()) {
            if (drawTab == Tab.GRAPH && !((TilePowerMonitor)this.getTileEntity()).isAdvanced()) continue;
            this.renderStdTab(sx, sy, drawTab.tabNo - (((TilePowerMonitor)this.getTileEntity()).isAdvanced() ? 0 : 1), drawTab.itemStack, (GuiButton)drawTab.button, drawTab == this.tab);
        }
    }

    @Override
    protected boolean renderPowerBar() {
        return this.tab == Tab.GRAPH;
    }

    private void drawControls(int sx, int sy) {
        FontRenderer fontRenderer = this.getFontRenderer();
        int textColor = ColorUtil.getRGB((Color)(this.engineControlEnabled.isSelected() ? Color.black : Color.darkGray));
        int x0 = sx + 7;
        int y0 = sy + 7;
        String engineTxt1 = EnderIO.lang.localize("gui.powerMonitor.engineSection1").trim();
        String engineTxt2 = EnderIO.lang.localize("gui.powerMonitor.engineSection2").trim();
        String engineTxt3 = EnderIO.lang.localize("gui.powerMonitor.engineSection3").trim();
        String engineTxt4 = EnderIO.lang.localize("gui.powerMonitor.engineSection4").trim();
        String engineTxt5 = EnderIO.lang.localize("gui.powerMonitor.engineSection5").trim();
        ArrayList<Object> elems = new ArrayList<Object>();
        elems.add(this.engineControlEnabled);
        elems.addAll(Arrays.asList(engineTxt1.split("(\\s+)")));
        elems.addAll(Arrays.asList(engineTxt2.split("(\\s+)")));
        elems.add(this.engineControlStart);
        elems.addAll(Arrays.asList(engineTxt3.split("(\\s+)")));
        elems.addAll(Arrays.asList(engineTxt4.split("(\\s+)")));
        elems.addAll(Arrays.asList(engineTxt5.split("(\\s+)")));
        elems.add(this.engineControlStop);
        elems.addAll(Arrays.asList(engineTxt3.split("(\\s+)")));
        int x = 0;
        int y = 0;
        for (Object e : elems) {
            int elemWidth = 0;
            if (e instanceof String) {
                elemWidth = fontRenderer.func_78256_a((String)e);
            } else if (e instanceof CheckBox) {
                elemWidth = ((CheckBox)e).field_146120_f;
            } else if (e instanceof TextFieldEnder) {
                elemWidth = ((TextFieldEnder)e).field_146218_h;
            }
            if (x + elemWidth > 162) {
                x = 0;
                y += 16;
                if (" ".equals(e)) continue;
            }
            if (e instanceof String) {
                fontRenderer.func_78276_b((String)e, x0 + x, y0 + y + 4, textColor);
            } else if (e instanceof CheckBox) {
                ((CheckBox)e).field_146128_h = x0 + x;
                ((CheckBox)e).field_146129_i = y0 + y;
            } else if (e instanceof TextFieldEnder) {
                ((TextFieldEnder)e).field_146209_f = x0 + x;
                ((TextFieldEnder)e).field_146210_g = y0 + y;
            }
            x += elemWidth + fontRenderer.func_78256_a(" ");
        }
    }

    private void drawStats(int sx, int sy) {
        FontRenderer fontRenderer = this.getFontRenderer();
        int valuesCol = ColorUtil.getRGB((Color)Color.black);
        int errorCol = ColorUtil.getRGB((Color)Color.red);
        int x = sx + 7;
        int y = sy + 7;
        TilePowerMonitor.StatData statData = ((TilePowerMonitor)this.getTileEntity()).getStatData();
        if (statData == null || statData.maxPowerInConduits == 0) {
            fontRenderer.func_78279_b(EnderIO.lang.localize("gui.powerMonitor.noNetworkError"), x, y, 162, errorCol);
            return;
        }
        RenderHelper.func_74520_c();
        this.field_146296_j.func_175042_a(new ItemStack(ModObject.itemPowerConduit.getItem(), 1, 2), x, y);
        this.tooltipConduitStorage.setBounds(new Rectangle(7, 7, 162, 16));
        ItemStack capBankStack = new ItemStack(ModObject.blockCapBank.getBlock(), 1, 3);
        if (statData.maxPowerInCapBanks > 0L) {
            BlockItemCapBank.setStoredEnergyForItem(capBankStack, (int)((double)((BlockItemCapBank)capBankStack.func_77973_b()).getMaxEnergyStored(capBankStack) * ((double)statData.powerInCapBanks / (double)statData.maxPowerInCapBanks)));
        }
        this.field_146296_j.func_175042_a(capBankStack, x, y + 18);
        this.tooltipCapacitorBankStorage.setBounds(new Rectangle(7, 25, 162, 16));
        this.field_146296_j.func_175042_a(new ItemStack(ModObject.blockAlloySmelter.getBlock()), x, y + 54);
        this.tooltipMachineBuffers.setBounds(new Rectangle(7, 61, 162, 16));
        RenderHelper.func_74518_a();
        this.bindGuiTexture(1);
        this.func_73729_b(x, y + 36, 180, 31, 16, 16);
        this.tooltipAverageOutput.setBounds(new Rectangle(7, 43, 81, 16));
        this.func_73729_b(x + 81, y + 36, 196, 31, 16, 16);
        this.tooltipAverageInput.setBounds(new Rectangle(88, 43, 81, 16));
        StringBuilder sb = new StringBuilder();
        sb.append(PowerDisplayUtil.formatPower(statData.powerInConduits));
        sb.append(" ");
        sb.append(PowerDisplayUtil.ofStr());
        sb.append(" ");
        sb.append(PowerDisplayUtil.formatPower(statData.maxPowerInConduits));
        sb.append(" ");
        sb.append(PowerDisplayUtil.abrevation());
        fontRenderer.func_175065_a(sb.toString(), (float)(x + 18), (float)(y + 4), valuesCol, false);
        sb = new StringBuilder();
        sb.append(PowerDisplayUtil.formatPower(statData.powerInCapBanks));
        sb.append(" ");
        sb.append(PowerDisplayUtil.ofStr());
        sb.append(" ");
        sb.append(PowerDisplayUtil.formatPower(statData.maxPowerInCapBanks));
        sb.append(" ");
        sb.append(PowerDisplayUtil.abrevation());
        fontRenderer.func_175065_a(sb.toString(), (float)(x + 18), (float)(y + 4 + 18), valuesCol, false);
        sb = new StringBuilder();
        sb.append(PowerDisplayUtil.formatPower(statData.powerInMachines));
        sb.append(" ");
        sb.append(PowerDisplayUtil.ofStr());
        sb.append(" ");
        sb.append(PowerDisplayUtil.formatPower(statData.maxPowerInMachines));
        sb.append(" ");
        sb.append(PowerDisplayUtil.abrevation());
        fontRenderer.func_175065_a(sb.toString(), (float)(x + 18), (float)(y + 4 + 54), valuesCol, false);
        sb = new StringBuilder();
        sb.append(PowerDisplayUtil.formatPowerFloat(statData.aveRfSent));
        sb.append(" ");
        sb.append(PowerDisplayUtil.abrevation());
        sb.append(PowerDisplayUtil.perTickStr());
        fontRenderer.func_175065_a(sb.toString(), (float)(x + 18), (float)(y + 4 + 36), valuesCol, false);
        sb = new StringBuilder();
        sb.append(PowerDisplayUtil.formatPowerFloat(statData.aveRfReceived));
        sb.append(" ");
        sb.append(PowerDisplayUtil.abrevation());
        sb.append(PowerDisplayUtil.perTickStr());
        fontRenderer.func_175065_a(sb.toString(), (float)(x + 18 + 81), (float)(y + 4 + 36), valuesCol, false);
    }

    private int getInt(GuiTextField tf) {
        try {
            int val = Integer.parseInt(tf.func_146179_b());
            if (val >= 0 && val <= 100) {
                return val;
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static enum Tab {
        GRAPH(0, new ItemStack((Block)BlockPowerMonitor.advancedInstance)),
        STAT(1, new ItemStack(ModObject.blockPowerMonitor.getBlock())),
        CONTROL(2, new ItemStack(Items.field_151137_ax));

        int tabNo;
        @Nonnull
        ItemStack itemStack;
        InvisibleButton button;

        private Tab(int tabNo, ItemStack itemStack) {
            this.tabNo = tabNo;
            this.itemStack = itemStack;
        }
    }
}

