/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk;

import crazypants.enderio.network.PacketHandler;
import crazypants.util.ClientUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketObeliskFx
implements IMessage,
IMessageHandler<PacketObeliskFx, IMessage> {
    private static Random rand = new Random();
    private double posX;
    private double posY;
    private double posZ;
    private List<EnumParticleTypes> particles;

    public PacketObeliskFx() {
    }

    public static void create(Entity position, EnumParticleTypes ... particles) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketObeliskFx(position, particles), new NetworkRegistry.TargetPoint(position.field_70170_p.field_73011_w.getDimension(), position.field_70165_t, position.field_70163_u, position.field_70161_v, 64.0));
    }

    public PacketObeliskFx(Entity position, EnumParticleTypes ... particles) {
        this.posX = position.field_70165_t;
        this.posY = position.field_70163_u + (double)position.field_70131_O * 0.8;
        this.posZ = position.field_70161_v;
        this.particles = Arrays.asList(particles);
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeFloat((float)this.posX);
        buffer.writeFloat((float)this.posY);
        buffer.writeFloat((float)this.posZ);
        int size = this.particles.size();
        buffer.writeByte(size);
        for (EnumParticleTypes particle : this.particles) {
            buffer.writeByte(particle.ordinal());
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.posX = buffer.readFloat();
        this.posY = buffer.readFloat();
        this.posZ = buffer.readFloat();
        int size = buffer.readByte();
        this.particles = new ArrayList<EnumParticleTypes>(size);
        for (int i = 0; i < size; ++i) {
            this.particles.add(EnumParticleTypes.values()[buffer.readByte()]);
        }
    }

    public IMessage onMessage(PacketObeliskFx message, MessageContext ctx) {
        for (EnumParticleTypes particle : message.particles) {
            ClientUtil.spawnParcticles(message.posX, message.posY, message.posZ, 5, particle);
        }
        return null;
    }
}

