/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.render;

import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.obelisk.attractor.TileAttractor;
import crazypants.enderio.machine.obelisk.aversion.AversionObeliskRenderer;
import crazypants.enderio.machine.obelisk.aversion.TileAversionObelisk;
import crazypants.enderio.machine.obelisk.inhibitor.TileInhibitorObelisk;
import crazypants.enderio.machine.obelisk.relocator.RelocatorObeliskRenderer;
import crazypants.enderio.machine.obelisk.relocator.TileRelocatorObelisk;
import crazypants.enderio.machine.obelisk.render.ObeliskSpecialRenderer;
import crazypants.enderio.machine.obelisk.weather.TileWeatherObelisk;
import crazypants.enderio.machine.obelisk.weather.WeatherObeliskSpecialRenderer;
import crazypants.enderio.machine.obelisk.xp.TileExperienceObelisk;
import crazypants.enderio.material.Material;
import crazypants.enderio.render.registry.TextureRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ObeliskRenderManager {
    public static final ObeliskRenderManager INSTANCE = new ObeliskRenderManager();
    public static ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation("enderio:obelisk");
    private TextureRegistry.TextureSupplier[] textures = new TextureRegistry.TextureSupplier[]{TextureRegistry.registerTexture("blocks/obeliskBottom"), TextureRegistry.registerTexture("blocks/blockSoulMachineTop"), TextureRegistry.registerTexture("blocks/blockAttractorSide"), TextureRegistry.registerTexture("blocks/blockAttractorSide"), TextureRegistry.registerTexture("blocks/blockAttractorSide"), TextureRegistry.registerTexture("blocks/blockAttractorSide")};
    private TextureRegistry.TextureSupplier[] activeTextures = new TextureRegistry.TextureSupplier[]{TextureRegistry.registerTexture("blocks/obeliskBottom"), TextureRegistry.registerTexture("blocks/blockSoulMachineTop"), TextureRegistry.registerTexture("blocks/blockAttractorSideOn"), TextureRegistry.registerTexture("blocks/blockAttractorSideOn"), TextureRegistry.registerTexture("blocks/blockAttractorSideOn"), TextureRegistry.registerTexture("blocks/blockAttractorSideOn")};

    private ObeliskRenderManager() {
    }

    public void registerRenderers() {
        ObeliskSpecialRenderer eor;
        Block block = ModObject.blockExperienceObelisk.getBlock();
        if (block != null) {
            eor = new ObeliskSpecialRenderer(new ItemStack(ModObject.itemXpTransfer.getItem()), block);
            this.registerRenderer(block, (Class)TileExperienceObelisk.class, (TileEntitySpecialRenderer)eor);
        }
        if ((block = ModObject.blockAttractor.getBlock()) != null) {
            eor = new ObeliskSpecialRenderer(new ItemStack(ModObject.itemMaterial.getItem(), 1, Material.ATTRACTOR_CRYSTAL.ordinal()), block);
            this.registerRenderer(block, (Class)TileAttractor.class, (TileEntitySpecialRenderer)eor);
        }
        if ((block = ModObject.blockSpawnGuard.getBlock()) != null) {
            eor = new AversionObeliskRenderer();
            this.registerRenderer(block, (Class)TileAversionObelisk.class, (TileEntitySpecialRenderer)eor);
        }
        if ((block = ModObject.blockSpawnRelocator.getBlock()) != null) {
            eor = new RelocatorObeliskRenderer();
            this.registerRenderer(block, (Class)TileRelocatorObelisk.class, (TileEntitySpecialRenderer)eor);
        }
        if ((block = ModObject.blockWeatherObelisk.getBlock()) != null) {
            eor = new WeatherObeliskSpecialRenderer(new ItemStack(Items.field_151152_bP));
            this.registerRenderer(block, (Class)TileWeatherObelisk.class, (TileEntitySpecialRenderer)eor);
        }
        if ((block = ModObject.blockInhibitorObelisk.getBlock()) != null) {
            eor = new ObeliskSpecialRenderer(new ItemStack(Items.field_151079_bi), block);
            this.registerRenderer(block, (Class)TileInhibitorObelisk.class, (TileEntitySpecialRenderer)eor);
        }
    }

    private <T extends AbstractMachineEntity> void registerRenderer(Block block, Class<T> tileClass, TileEntitySpecialRenderer<? super T> specialRenderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(tileClass, specialRenderer);
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)block), (int)0, tileClass);
    }

    public TextureRegistry.TextureSupplier[] getTextures() {
        return this.textures;
    }

    public TextureRegistry.TextureSupplier[] getActiveTextures() {
        return this.activeTextures;
    }
}

