/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter.blocks;

import com.enderio.core.common.BlockEnder;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.painter.blocks.BlockItemPaintedBlock;
import crazypants.enderio.machine.painter.blocks.TileEntityPaintedBlock;
import crazypants.enderio.machine.painter.recipe.BasicPainterTemplate;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.paint.render.PaintHelper;
import crazypants.enderio.paint.render.PaintRegistry;
import crazypants.enderio.paint.render.UVLock;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.ICacheKey;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.ISmartRenderAwareBlock;
import crazypants.enderio.render.dummy.BlockMachineBase;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.render.property.EnumRenderPart;
import crazypants.enderio.render.property.IOMode;
import crazypants.enderio.render.registry.SmartModelAttacher;
import crazypants.enderio.render.util.QuadCollector;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockWall;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPaintedFenceGate
extends BlockFenceGate
implements ITileEntityProvider,
IPaintable.ITexturePaintableBlock,
ISmartRenderAwareBlock,
IRenderMapper.IBlockRenderMapper.IRenderLayerAware,
IRenderMapper.IItemRenderMapper.IItemModelMapper {
    private final String name;

    public static BlockPaintedFenceGate create() {
        BlockPaintedFenceGate result = new BlockPaintedFenceGate(BlockPlanks.EnumType.OAK, ModObject.blockPaintedFenceGate.getUnlocalisedName());
        result.func_149711_c(2.0f).func_149752_b(5.0f);
        result.init();
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.getUnlocalisedName(), new BasicPainterTemplate<BlockPaintedFenceGate>(result, Blocks.field_180390_bo, Blocks.field_180387_bt, Blocks.field_180391_bp, Blocks.field_180392_bq, Blocks.field_180386_br, Blocks.field_180385_bs));
        return result;
    }

    protected BlockPaintedFenceGate(BlockPlanks.EnumType material, String name) {
        super(material);
        this.func_149647_a(null);
        this.name = name;
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149672_a(SoundType.field_185848_a);
    }

    private void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new BlockItemPaintedBlock((Block)this, this.name));
        SmartModelAttacher.registerNoProps((Block)this);
        PaintRegistry.registerModel("fence_gate_closed", new ResourceLocation("minecraft", "block/oak_fence_gate_closed"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("fence_gate_open", new ResourceLocation("minecraft", "block/oak_fence_gate_open"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("wall_gate_closed", new ResourceLocation("minecraft", "block/oak_wall_gate_closed"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("wall_gate_open", new ResourceLocation("minecraft", "block/oak_wall_gate_open"), PaintRegistry.PaintMode.ALL_TEXTURES);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing.Axis enumfacing$axis = ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176740_k();
        if (enumfacing$axis == EnumFacing.Axis.Z && (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() instanceof BlockWall || worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() instanceof BlockWall) || enumfacing$axis == EnumFacing.Axis.X && (worldIn.func_180495_p(pos.func_177978_c()).func_177230_c() instanceof BlockWall || worldIn.func_180495_p(pos.func_177968_d()).func_177230_c() instanceof BlockWall)) {
            state = state.func_177226_a((IProperty)field_176467_M, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityPaintedBlock();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        this.setPaintSource(state, (IBlockAccess)world, pos, PainterUtil2.getSourceBlock(stack));
        if (!world.field_72995_K) {
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        super.removedByPlayer(state, worldIn, pos, player, true);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List drops = super.getDrops(world, pos, state, fortune);
        for (ItemStack drop : drops) {
            PainterUtil2.setSourceBlock(drop, this.getPaintSource(state, world, pos));
        }
        return drops;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack pickBlock = super.getPickBlock(state, target, world, pos, player);
        PainterUtil2.setSourceBlock(pickBlock, this.getPaintSource(null, (IBlockAccess)world, pos));
        return pickBlock;
    }

    @Override
    public void setPaintSource(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable IBlockState paintSource) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            ((IPaintable.IPaintableTileEntity)te).setPaintSource(paintSource);
        }
    }

    @Override
    public void setPaintSource(Block block, ItemStack stack, @Nullable IBlockState paintSource) {
        PainterUtil2.setSourceBlock(stack, paintSource);
    }

    @Override
    public IBlockState getPaintSource(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            return ((IPaintable.IPaintableTileEntity)te).getPaintSource();
        }
        return null;
    }

    @Override
    public IBlockState getPaintSource(Block block, ItemStack stack) {
        return PainterUtil2.getSourceBlock(stack);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state != null && world != null && pos != null) {
            BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, this);
            blockStateWrapper.addCacheKey(this.getPaintSource(state, world, pos)).addCacheKey(state.func_177229_b((IProperty)field_185512_D)).addCacheKey(state.func_177229_b((IProperty)field_176466_a)).addCacheKey(state.func_177229_b((IProperty)field_176467_M));
            blockStateWrapper.bakeModel();
            return blockStateWrapper;
        }
        return state;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    private IBakedModel mapRender(IBlockState state, @Nullable IBlockState paint) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        Boolean open = (Boolean)state.func_177229_b((IProperty)field_176466_a);
        Boolean wall = (Boolean)state.func_177229_b((IProperty)field_176467_M);
        String model = wall.booleanValue() ? (open.booleanValue() ? "wall_gate_open" : "wall_gate_closed") : (open != false ? "fence_gate_open" : "fence_gate_closed");
        switch (facing) {
            case EAST: {
                return PaintRegistry.getModel(IBakedModel.class, model, paint, new UVLock((IModelState)ModelRotation.X0_Y270));
            }
            case NORTH: {
                return PaintRegistry.getModel(IBakedModel.class, model, paint, new UVLock((IModelState)ModelRotation.X0_Y180));
            }
            case SOUTH: {
                return PaintRegistry.getModel(IBakedModel.class, model, paint, new UVLock(null));
            }
            case WEST: {
                return PaintRegistry.getModel(IBakedModel.class, model, paint, new UVLock((IModelState)ModelRotation.X0_Y90));
            }
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ICacheKey getCacheKey(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ICacheKey cacheKey) {
        return cacheKey.addCacheKey(this.getPaintSource(block, stack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBakedModel> mapItemRender(Block block, ItemStack stack) {
        IBlockState paintSource = this.getPaintSource(block, stack);
        IBlockState stdOverlay = BlockMachineBase.block.func_176223_P().func_177226_a(EnumRenderPart.SUB, (Comparable)((Object)EnumRenderPart.PAINT_OVERLAY));
        IBakedModel model1 = PaintRegistry.getModel(IBakedModel.class, "fence_gate_closed", paintSource, new UVLock(null));
        IBakedModel model2 = PaintRegistry.getModel(IBakedModel.class, "fence_gate_closed", stdOverlay, PaintRegistry.OVERLAY_TRANSFORMATION2);
        ArrayList<IBakedModel> list = new ArrayList<IBakedModel>();
        list.add(model1);
        list.add(model2);
        return list;
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return true;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 20;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 5;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (tab != null) {
            super.func_149666_a(itemIn, tab, list);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBlockState> mapBlockRender(IBlockStateWrapper state, IBlockAccess world, BlockPos pos, BlockRenderLayer blockLayer, QuadCollector quadCollector) {
        IBlockState paintSource = this.getPaintSource(state, world, pos);
        if (PainterUtil2.canRenderInLayer(paintSource, blockLayer)) {
            quadCollector.addFriendlybakedModel(blockLayer, this.mapRender(state, paintSource), paintSource, MathHelper.func_180186_a((Vec3i)pos));
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumMap<EnumFacing, IOMode.EnumIOMode> mapOverlayLayer(IBlockStateWrapper state, IBlockAccess world, BlockPos pos, boolean isPainted) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }
}

