/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.reservoir;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.fluid.FluidWrapper;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.fluid.SmartTank;
import crazypants.enderio.fluid.SmartTankFluidHandler;
import crazypants.enderio.fluid.SmartTankFluidReservoirHandler;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

@Storable
public class TileReservoir
extends TileEntityEio
implements ITankAccess.IExtendedTankAccess {
    @Store
    SmartTank tank = new SmartTank(FluidRegistry.WATER, 1000);
    public boolean canRefill = false;
    @Store
    boolean autoEject = false;
    private boolean tankDirty = false;
    private static int IO_MB_TICK = 100;
    private SmartTankFluidHandler smartTankFluidHandler;

    public TileReservoir() {
        this.tank.setTileEntity((TileEntity)this);
    }

    private boolean hasEnoughLiquid() {
        HashSet<TileReservoir> seen = new HashSet<TileReservoir>();
        seen.add(this);
        int got = this.tank.getFluidAmount();
        for (EnumFacing neighbor : EnumFacing.field_82609_l) {
            BlockPos pos1 = this.func_174877_v().func_177972_a(neighbor);
            TileEntity tileEntity = this.field_145850_b.func_175625_s(pos1);
            if (!(tileEntity instanceof TileReservoir) || ((TileReservoir)tileEntity).tank == null || seen.contains(tileEntity)) continue;
            seen.add((TileReservoir)tileEntity);
            if ((got += ((TileReservoir)tileEntity).tank.getFluidAmount()) >= 2000) {
                return true;
            }
            for (EnumFacing neighbor2 : EnumFacing.field_82609_l) {
                BlockPos pos2 = pos1.func_177972_a(neighbor2);
                TileEntity tileEntity2 = this.field_145850_b.func_175625_s(pos2);
                if (!(tileEntity2 instanceof TileReservoir) || ((TileReservoir)tileEntity2).tank == null || seen.contains(tileEntity2)) continue;
                seen.add((TileReservoir)tileEntity2);
                if ((got += ((TileReservoir)tileEntity2).tank.getFluidAmount()) < 2000) continue;
                return true;
            }
        }
        return false;
    }

    protected void doPush() {
        if (this.tank.getFluidAmount() > 0) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (dir == null || this.tank.getFluidAmount() <= 0 || FluidWrapper.transfer((FluidTank)this.tank, (IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (int)IO_MB_TICK) <= 0) continue;
                this.setTanksDirty();
            }
        }
    }

    protected void doLeak() {
        BlockPos down = this.func_174877_v().func_177977_b();
        int max = Math.min(this.tank.getFluidAmount() / 3, IO_MB_TICK);
        if (max <= 0) {
            max = 2;
        }
        this.doLeak(down, max);
        for (EnumFacing dir : EnumFacing.Plane.HORIZONTAL) {
            BlockPos pos1 = down.func_177972_a(dir);
            this.doLeak(pos1, max / 2);
        }
    }

    protected void doLeak(BlockPos pos1, int maxAmount) {
        FluidStack canDrain;
        TileEntity tileEntity = this.field_145850_b.func_175625_s(pos1);
        if (tileEntity instanceof TileReservoir && !((TileReservoir)tileEntity).tank.isFull() && (canDrain = this.tank.drainInternal(maxAmount, false)) != null && canDrain.amount > 0) {
            int fill = ((TileReservoir)tileEntity).tank.fill(canDrain, true);
            this.tank.drainInternal(fill, true);
            ((TileReservoir)tileEntity).setTanksDirty();
            this.setTanksDirty();
        }
    }

    protected void doEqualize() {
        for (EnumFacing dir : EnumFacing.Plane.HORIZONTAL) {
            FluidStack canDrain;
            BlockPos pos1 = this.func_174877_v().func_177972_a(dir);
            TileEntity tileEntity = this.field_145850_b.func_175625_s(pos1);
            if (!(tileEntity instanceof TileReservoir)) continue;
            TileReservoir other = (TileReservoir)tileEntity;
            int toMove = (this.tank.getFluidAmount() - other.tank.getFluidAmount()) / 2;
            if (toMove <= 0 || (canDrain = this.tank.drainInternal(Math.min(toMove, IO_MB_TICK / 4), false)) == null || canDrain.amount <= 0) continue;
            int fill = ((TileReservoir)tileEntity).tank.fill(canDrain, true);
            this.tank.drainInternal(fill, true);
            ((TileReservoir)tileEntity).setTanksDirty();
            this.setTanksDirty();
        }
    }

    @Override
    public void doUpdate() {
        if (this.field_145850_b.field_72995_K) {
            super.doUpdate();
            return;
        }
        if (this.tank == null) {
            return;
        }
        if (this.shouldDoWorkThisTick(10)) {
            if (this.tankDirty || !this.tank.isFull() || !this.canRefill) {
                this.canRefill = this.hasEnoughLiquid();
            }
        } else if (this.canRefill && !this.tank.isFull() && this.shouldDoWorkThisTick(10, -1)) {
            this.tank.addFluidAmount(500);
            this.setTanksDirty();
        }
        if (this.shouldDoWorkThisTick(15, 1) && !this.tank.isEmpty()) {
            this.doLeak();
            if (!this.tank.isEmpty()) {
                this.doEqualize();
            }
        }
        if (this.autoEject && this.canRefill) {
            this.doPush();
        }
        if (this.tankDirty && this.shouldDoWorkThisTick(2)) {
            this.updateBlock();
            this.tankDirty = false;
        }
    }

    public void setAutoEject(boolean autoEject) {
        this.autoEject = autoEject;
    }

    public boolean isAutoEject() {
        return this.autoEject;
    }

    float getFilledRatio() {
        return this.tank.getFilledRatio();
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        if (forFluidType != null && forFluidType.getFluid() == FluidRegistry.WATER) {
            return this.tank;
        }
        return null;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.tank};
    }

    public void setTanksDirty() {
        if (!this.tankDirty) {
            this.tankDirty = true;
            this.func_70296_d();
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1 && !this.tank.isEmpty();
    }

    @Nonnull
    public List<ITankAccess.ITankData> getTankDisplayData() {
        return Collections.singletonList(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.OUTPUT;
            }

            @Nullable
            public FluidStack getContent() {
                return TileReservoir.this.tank.getFluid();
            }

            public int getCapacity() {
                return TileReservoir.this.tank.getCapacity();
            }
        });
    }

    protected SmartTankFluidHandler getSmartTankFluidHandler() {
        if (this.smartTankFluidHandler == null) {
            this.smartTankFluidHandler = new SmartTankFluidReservoirHandler(this, new IFluidHandler[]{this.tank});
        }
        return this.smartTankFluidHandler;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getSmartTankFluidHandler().has(facingIn);
        }
        return super.hasCapability(capability, facingIn);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getSmartTankFluidHandler().get(facingIn);
        }
        return (T)super.getCapability(capability, facingIn);
    }
}

