/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.solar;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.ModObject;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.integration.waila.IWailaNBTProvider;
import crazypants.enderio.item.PacketConduitProbe;
import crazypants.enderio.machine.solar.SolarPanelNetwork;
import crazypants.enderio.machine.solar.SolarType;
import crazypants.enderio.power.IInternalPoweredTile;
import crazypants.enderio.power.IPowerInterface;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.enderio.power.forge.InternalPoweredTileWrapper;
import info.loenwind.autosave.annotations.Storable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;

@Storable
public class TileEntitySolarPanel
extends TileEntityEio
implements IInternalPoweredTile,
IWailaNBTProvider,
PacketConduitProbe.IHasConduitProbeData {
    private boolean forceNetworkSearch = true;
    protected SolarPanelNetwork network = new SolarPanelNetwork();

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return from == EnumFacing.DOWN;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.network.getEnergyAvailablePerTick();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing facing) {
        return this.network.getEnergyMaxPerTick();
    }

    @Override
    public void setEnergyStored(int stored) {
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facingIn) {
        if (capability == CapabilityEnergy.ENERGY) {
            return facingIn == EnumFacing.DOWN;
        }
        return super.hasCapability(capability, facingIn);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facingIn) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)(facingIn != EnumFacing.DOWN ? null : new InternalPoweredTileWrapper(this, facingIn));
        }
        return (T)super.getCapability(capability, facingIn);
    }

    @Override
    public void doUpdate() {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.field_72995_K) {
                super.doUpdate();
            }
            return;
        }
        if (!this.network.isValid()) {
            this.network = new SolarPanelNetwork(this);
        }
        this.network.onUpdate(this, this.forceNetworkSearch);
        this.forceNetworkSearch = false;
        if (this.network.isValid()) {
            this.transmitEnergy();
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.network.destroyNetwork();
    }

    int getEnergyPerTick() {
        return TileEntitySolarPanel.getEnergyPerTick(this.field_145850_b, this.field_174879_c);
    }

    static int getEnergyPerTick(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177230_c() == ModObject.blockSolarPanel.getBlock()) {
            return ((SolarType)((Object)blockState.func_177229_b(SolarType.KIND))).getRfperTick();
        }
        return -1;
    }

    float calculateLightRatio() {
        return TileEntitySolarPanel.calculateLightRatio(this.field_145850_b);
    }

    boolean canSeeSun() {
        return TileEntitySolarPanel.canSeeSun(this.field_145850_b, this.field_174879_c);
    }

    static boolean canSeeSun(World world, BlockPos pos) {
        return world.func_175710_j(pos.func_177984_a());
    }

    public static float calculateLightRatio(World world) {
        int lightValue = EnumSkyBlock.SKY.field_77198_c - world.func_175657_ab();
        float sunAngle = world.func_72929_e(1.0f);
        sunAngle = sunAngle < (float)Math.PI ? (sunAngle += (0.0f - sunAngle) * 0.2f) : (sunAngle += ((float)Math.PI * 2 - sunAngle) * 0.2f);
        lightValue = Math.round((float)lightValue * MathHelper.func_76134_b((float)sunAngle));
        lightValue = MathHelper.func_76125_a((int)lightValue, (int)0, (int)15);
        return (float)lightValue / 15.0f;
    }

    private void transmitEnergy() {
        int canTransmit;
        IPowerInterface receptor = PowerHandlerUtil.getPowerInterface((ICapabilityProvider)this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(EnumFacing.DOWN)), EnumFacing.UP);
        if (receptor != null && (canTransmit = this.network.getEnergyAvailableThisTick()) > 0) {
            this.network.extractEnergy(receptor.receiveEnergy(canTransmit, false));
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag) {
        super.readCustomNBT(tag);
        this.forceNetworkSearch = true;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound tag) {
        super.writeCustomNBT(tag);
        if (this.network.isValid()) {
            tag.func_74768_a("rfCap", this.network.getEnergyMaxPerTick());
        }
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    public void setNetwork(SolarPanelNetwork network) {
        this.network = network;
    }

    @Override
    public void getData(NBTTagCompound tag) {
        if (this.network.isValid()) {
            this.func_189515_b(tag);
        }
    }

    @Override
    public BlockCoord getLocation() {
        return new BlockCoord(this.field_174879_c);
    }

    @Override
    public String[] getConduitProbeData() {
        return this.network.getConduitProbeData();
    }
}

