/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.power.forge;

import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.power.IInternalPowerReceiver;
import crazypants.enderio.power.IInternalPoweredTile;
import crazypants.enderio.power.IPowerApiAdapter;
import crazypants.enderio.power.IPowerInterface;
import crazypants.enderio.power.ItemPowerCapabilityBackend;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.enderio.power.forge.InternalPoweredItemWrapper;
import crazypants.enderio.power.forge.InternalPoweredTileWrapper;
import crazypants.enderio.power.forge.InternalRecieverTileWrapper;
import crazypants.enderio.power.forge.PowerInterfaceForge;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ForgeAdapter
implements IPowerApiAdapter {
    @CapabilityInject(value=IEnergyStorage.class)
    public static final Capability<IEnergyStorage> ENERGY_HANDLER = null;
    private static final ResourceLocation KEY = new ResourceLocation(EnderIO.DOMAIN, "EioCapProviderPower");

    public static void capRegistered(Capability<?> cap) {
        PowerHandlerUtil.addAdapter(new ForgeAdapter());
        MinecraftForge.EVENT_BUS.register(ForgeAdapter.class);
        ItemPowerCapabilityBackend.register(new InternalPoweredItemWrapper.PoweredItemCapabilityProvider());
        Log.info("Forge Energy integration loaded");
    }

    @Override
    public IPowerInterface getPowerInterface(@Nullable ICapabilityProvider provider, EnumFacing side) {
        IEnergyStorage cap = this.getCapability(provider, side);
        if (cap != null) {
            return new PowerInterfaceForge(provider, cap);
        }
        return null;
    }

    @Override
    public IEnergyStorage getCapability(@Nullable ICapabilityProvider provider, EnumFacing side) {
        if (provider != null && provider.hasCapability(ENERGY_HANDLER, side)) {
            return (IEnergyStorage)provider.getCapability(ENERGY_HANDLER, side);
        }
        return null;
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent.TileEntity evt) {
        if (evt.getCapabilities().containsKey(KEY)) {
            return;
        }
        TileEntity te = evt.getTileEntity();
        if (te instanceof IInternalPowerReceiver) {
            evt.addCapability(KEY, (ICapabilityProvider)new InternalRecieverTileWrapper.RecieverTileCapabilityProvider((IInternalPowerReceiver)te));
        } else if (te instanceof IInternalPoweredTile) {
            evt.addCapability(KEY, (ICapabilityProvider)new InternalPoweredTileWrapper.PoweredTileCapabilityProvider((IInternalPoweredTile)te));
        }
    }
}

