/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render.rendermapper;

import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.property.EnumMergingBlockRenderMode;
import crazypants.enderio.render.util.QuadCollector;
import crazypants.util.FacadeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ConnectedBlockRenderMapper
implements IRenderMapper.IBlockRenderMapper {
    protected boolean skip_top = false;
    protected boolean skip_bottom = false;
    protected boolean skip_side = false;
    protected boolean skip_top_side = false;
    protected boolean skip_bottom_side = false;
    private final boolean[][][] neighborKinds = new boolean[3][3][3];

    @SideOnly(value=Side.CLIENT)
    protected abstract List<IBlockState> renderBody(IBlockStateWrapper var1, IBlockAccess var2, BlockPos var3, BlockRenderLayer var4, QuadCollector var5);

    protected abstract boolean isSameKind(IBlockState var1, IBlockState var2);

    @SideOnly(value=Side.CLIENT)
    protected abstract IBlockState getMergedBlockstate(IBlockState var1);

    @SideOnly(value=Side.CLIENT)
    protected abstract IBlockState getBorderedBlockstate(IBlockState var1);

    public ConnectedBlockRenderMapper(IBlockState state, IBlockAccess world, BlockPos pos) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    BlockPos npos = pos.func_177982_a(dx, dy, dz);
                    this.setNeighbor(pos, npos, this.isSameKind(state, world, pos, npos));
                }
            }
        }
    }

    protected boolean isSameKind(IBlockState state, IBlockAccess world, BlockPos pos, BlockPos other) {
        IBlockState otherState = world.func_180495_p(other).func_185899_b(world, other);
        if (this.isSameKind(state, otherState)) {
            return true;
        }
        if (FacadeUtil.instance.isFacaded(otherState) && other != null) {
            try {
                IBlockState facade = FacadeUtil.instance.getFacade(otherState, world, other, null);
                if (facade != null) {
                    return this.isSameKind(state, facade);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    protected boolean getNeighbor(BlockPos pos, BlockPos npos) {
        int x = this.cmp(pos.func_177958_n(), npos.func_177958_n());
        int y = this.cmp(pos.func_177956_o(), npos.func_177956_o());
        int z = this.cmp(pos.func_177952_p(), npos.func_177952_p());
        return this.neighborKinds[x][y][z];
    }

    protected int cmp(int a, int b) {
        return a < b ? 0 : (a > b ? 2 : 1);
    }

    protected void setNeighbor(BlockPos pos, BlockPos npos, boolean value) {
        int x = this.cmp(pos.func_177958_n(), npos.func_177958_n());
        int y = this.cmp(pos.func_177956_o(), npos.func_177956_o());
        int z = this.cmp(pos.func_177952_p(), npos.func_177952_p());
        this.neighborKinds[x][y][z] = value;
    }

    public int hashCode() {
        int deepHashCode = 0;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                for (int z = 0; z < 3; ++z) {
                    deepHashCode = (deepHashCode | (this.neighborKinds[x][y][z] ? 1 : 0)) << 1;
                }
            }
        }
        return deepHashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectedBlockRenderMapper other = (ConnectedBlockRenderMapper)obj;
        return Arrays.deepEquals((Object[])this.neighborKinds, (Object[])other.neighborKinds);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBlockState> mapBlockRender(IBlockStateWrapper state, IBlockAccess world, BlockPos pos, BlockRenderLayer blockLayer, QuadCollector quadCollector) {
        List<IBlockState> states = this.renderBody(state, world, pos, blockLayer, quadCollector);
        if (states == null) {
            states = new ArrayList<IBlockState>();
        }
        IBlockState stateMerged = this.getMergedBlockstate(state.getState());
        IBlockState stateBordered = this.getBorderedBlockstate(state.getState());
        boolean block_up = this.getNeighbor(pos, pos.func_177972_a(EnumFacing.UP));
        boolean block_down = this.getNeighbor(pos, pos.func_177972_a(EnumFacing.DOWN));
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            boolean block_facing = this.getNeighbor(pos, pos.func_177972_a(facing));
            boolean block_right = this.getNeighbor(pos, pos.func_177972_a(facing.func_176735_f()));
            boolean block_up_facing = this.getNeighbor(pos, pos.func_177984_a().func_177972_a(facing));
            boolean block_up_right = this.getNeighbor(pos, pos.func_177984_a().func_177972_a(facing.func_176735_f()));
            boolean block_right_facing = this.getNeighbor(pos, pos.func_177972_a(facing).func_177972_a(facing.func_176735_f()));
            boolean block_down_facing = this.getNeighbor(pos, pos.func_177977_b().func_177972_a(facing));
            boolean block_down_right = this.getNeighbor(pos, pos.func_177977_b().func_177972_a(facing.func_176735_f()));
            boolean block_up_right_facing = this.getNeighbor(pos, pos.func_177984_a().func_177972_a(facing.func_176735_f()).func_177972_a(facing));
            boolean block_down_right_facing = this.getNeighbor(pos, pos.func_177977_b().func_177972_a(facing.func_176735_f()).func_177972_a(facing));
            boolean upper_edge = this.hasEdge(block_up, block_facing);
            boolean lower_edge = this.hasEdge(block_down, block_facing);
            boolean right_edge = this.hasEdge(block_right, block_facing);
            this.add(states, this.skip_top, upper_edge, stateBordered, stateMerged, (IProperty)EnumMergingBlockRenderMode.RENDER, (Object)((Object)EnumMergingBlockRenderMode.get(facing, EnumFacing.UP)));
            this.add(states, this.skip_bottom, lower_edge, stateBordered, stateMerged, (IProperty)EnumMergingBlockRenderMode.RENDER, (Object)((Object)EnumMergingBlockRenderMode.get(facing, EnumFacing.DOWN)));
            this.add(states, this.skip_side, right_edge, stateBordered, stateMerged, (IProperty)EnumMergingBlockRenderMode.RENDER, (Object)((Object)EnumMergingBlockRenderMode.get(facing, facing.func_176735_f())));
            boolean upper_edge_around_right_corner = this.hasEdge(block_up, block_right);
            boolean lower_edge_around_right_corner = this.hasEdge(block_down, block_right);
            boolean right_edge_above = this.hasEdge(block_up, block_up_right, block_up_facing);
            boolean right_edge_below = this.hasEdge(block_down, block_down_right, block_down_facing);
            boolean top_facing_edge_right = this.hasEdge(block_right, block_up_right, block_right_facing);
            boolean bottom_facing_edge_right = this.hasEdge(block_right, block_down_right, block_right_facing);
            boolean facing_top_edge_right = this.hasEdge(block_facing, block_right_facing, block_up_facing);
            boolean facing_bottom_edge_right = this.hasEdge(block_facing, block_right_facing, block_down_facing);
            boolean checker_top_a = this.hasEdge(block_up_facing, block_facing, block_up_right_facing) && this.hasEdge(block_right_facing, block_facing, block_up_right_facing);
            boolean checker_top_b = this.hasEdge(block_up_right, block_right, block_up_right_facing) && this.hasEdge(block_right_facing, block_right, block_up_right_facing);
            boolean checker_top_c = this.hasEdge(block_up_facing, block_up, block_up_right_facing) && this.hasEdge(block_up_right, block_up, block_up_right_facing);
            boolean checker_bottom_a = this.hasEdge(block_down_facing, block_facing, block_down_right_facing) && this.hasEdge(block_right_facing, block_facing, block_down_right_facing);
            boolean checker_bottom_b = this.hasEdge(block_down_right, block_right, block_down_right_facing) && this.hasEdge(block_right_facing, block_right, block_down_right_facing);
            boolean checker_bottom_c = this.hasEdge(block_down_facing, block_down, block_down_right_facing) && this.hasEdge(block_down_right, block_down, block_down_right_facing);
            boolean upper_right_corner = upper_edge || right_edge || upper_edge_around_right_corner || right_edge_above || top_facing_edge_right || facing_top_edge_right || checker_top_a || checker_top_b || checker_top_c;
            boolean lower_right_corner = lower_edge || right_edge || lower_edge_around_right_corner || right_edge_below || bottom_facing_edge_right || facing_bottom_edge_right || checker_bottom_a || checker_bottom_b || checker_bottom_c;
            this.add(states, this.skip_top_side, upper_right_corner, stateBordered, stateMerged, (IProperty)EnumMergingBlockRenderMode.RENDER, (Object)((Object)EnumMergingBlockRenderMode.get(facing, facing.func_176735_f(), EnumFacing.UP)));
            this.add(states, this.skip_bottom_side, lower_right_corner, stateBordered, stateMerged, (IProperty)EnumMergingBlockRenderMode.RENDER, (Object)((Object)EnumMergingBlockRenderMode.get(facing, facing.func_176735_f(), EnumFacing.DOWN)));
        }
        return states;
    }

    protected boolean hasEdge(boolean base, boolean dir1, boolean dir2) {
        return base && !dir1 && !dir2;
    }

    protected boolean hasEdge(boolean dir1, boolean dir2) {
        return !dir1 && !dir2;
    }

    protected <T extends Comparable<T>, V extends T> void add(List<IBlockState> states, boolean skip, boolean border, IBlockState stateBordered, IBlockState stateMerged, IProperty<T> property, V value) {
        IBlockState state;
        IBlockState iBlockState = state = border ? stateBordered : stateMerged;
        if (!skip && state != null) {
            states.add(state.func_177226_a(property, value));
        }
    }
}

