/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.ClientUtil;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.CompoundCapabilityProvider;
import com.enderio.core.common.transform.EnderCoreMethods;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.Log;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.teleport.ITelePad;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.config.Config;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.item.PowerBarOverlayRenderHelper;
import crazypants.enderio.machine.MachineSound;
import crazypants.enderio.power.AbstractPoweredItem;
import crazypants.enderio.power.ItemPowerCapabilityBackend;
import crazypants.enderio.power.PowerDisplayUtil;
import crazypants.enderio.teleport.TeleportUtil;
import crazypants.enderio.teleport.telepad.TelepadTarget;
import crazypants.enderio.teleport.telepad.TileTelePad;
import crazypants.util.NbtValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.particle.Particle;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRodOfReturn
extends AbstractPoweredItem
implements IAdvancedTooltipProvider,
EnderCoreMethods.IOverlayRenderAware {
    private static final int RF_MAX_INPUT = (int)Math.ceil((double)Config.rodOfReturnPowerStorage / (double)Config.rodOfReturnMinTicksToRecharge);
    private static final String KEY_LAST_USED_TICK = "lastUsedAt";
    @SideOnly(value=Side.CLIENT)
    private MachineSound activeSound;
    private final Fluid fluidType;

    public static ItemRodOfReturn create() {
        ItemRodOfReturn result = new ItemRodOfReturn();
        result.init();
        return result;
    }

    protected ItemRodOfReturn() {
        super(Config.rodOfReturnPowerStorage, RF_MAX_INPUT, 0);
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        this.func_77655_b(ModObject.itemRodOfReturn.getUnlocalisedName());
        this.setRegistryName(ModObject.itemRodOfReturn.getUnlocalisedName());
        this.func_77625_d(1);
        this.func_77627_a(true);
        Fluid fluid = null;
        if (Config.rodOfReturnFluidType != null && (fluid = FluidRegistry.getFluid((String)Config.rodOfReturnFluidType)) == null) {
            Log.warn("ItemRodOfReturn: Could not find fluid '" + Config.rodOfReturnFluidType + "' using default fluid " + Fluids.fluidEnderDistillation);
        }
        if (fluid == null) {
            fluid = Fluids.fluidEnderDistillation;
        }
        this.fluidType = fluid;
    }

    protected void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (world.field_72995_K || !player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ITelePad) {
            ITelePad tp = (ITelePad)te;
            pos = tp.getMaster().getLocation().getBlockPos();
            this.setTarget(stack, pos, world.field_73011_w.getDimension());
            player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("itemRodOfReturn.chat.sync.telepad") + " [" + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p() + "]"));
            player.func_184597_cx();
            return EnumActionResult.SUCCESS;
        }
        if (Config.rodOfReturnCanTargetAnywhere) {
            this.setTarget(stack, pos, world.field_73011_w.getDimension());
            player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("itemRodOfReturn.chat.sync") + " [" + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p() + "]"));
            player.func_184597_cx();
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        long lastUsed = this.getLastUsedTick(stack);
        if ((lastUsed < 0L || world.func_82737_E() - lastUsed > 20L) && this.getEnergyStored(stack) > 0) {
            player.func_184598_c(hand);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (player.field_70170_p.field_72995_K) {
            this.onUsingClient(stack, player, count);
        }
        int used = (Config.rodOfReturnTicksToActivate - count) * 1000;
        int newVal = this.getEnergyStored(stack) - used;
        if (newVal < 0) {
            if (player.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("itemRodOfReturn.chat.notEnoughPower", new Object[]{TextFormatting.RED.toString()})));
            }
            player.func_184597_cx();
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase player, int timeLeft) {
        if (!(player instanceof EntityPlayer) || !((EntityPlayer)player).field_71075_bZ.field_75098_d) {
            this.updateStackNBT(stack, world, timeLeft);
        }
        if (world.field_72995_K) {
            this.stopPlayingSound();
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        boolean hasPower = true;
        boolean hasFluid = true;
        if (!(entityLiving instanceof EntityPlayer) || !((EntityPlayer)entityLiving).field_71075_bZ.field_75098_d) {
            hasPower = this.updateStackNBT(stack, worldIn, 0);
            boolean bl = hasFluid = hasPower ? this.useFluid(stack) : true;
        }
        if (hasPower && hasFluid) {
            TelepadTarget target = TelepadTarget.readFromNBT(stack);
            if (target == null) {
                if (worldIn.field_72995_K) {
                    this.stopPlayingSound();
                    entityLiving.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("itemRodOfReturn.chat.targetNotSet", new Object[]{TextFormatting.RED.toString()})));
                }
                return stack;
            }
            TeleportUtil.doTeleport((Entity)entityLiving, target.getLocation(), target.getDimension(), false, TravelSource.TELEPAD);
        } else if (worldIn.field_72995_K) {
            if (!hasPower) {
                entityLiving.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("itemRodOfReturn.chat.notEnoughPower", new Object[]{TextFormatting.RED.toString()})));
            } else {
                entityLiving.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("itemRodOfReturn.chat.notEnoughFluid", new Object[]{TextFormatting.RED.toString()})));
            }
        }
        if (worldIn.field_72995_K) {
            this.stopPlayingSound();
        }
        return stack;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldS, ItemStack newS, boolean slotChanged) {
        return slotChanged || oldS == null || newS == null || oldS.func_77973_b() != newS.func_77973_b();
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return this.shouldCauseReequipAnimation(oldStack, newStack, false);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        this.setEnergyStored(itemStack, 0);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return Config.rodOfReturnTicksToActivate;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List<String> list, boolean par4) {
        super.func_77624_a(itemStack, par2EntityPlayer, list, par4);
        String str = PowerDisplayUtil.formatPower(NbtValue.FLUIDAMOUNT.getInt(itemStack, 0)) + "/" + PowerDisplayUtil.formatPower(Config.rodOfReturnFluidStorage) + " MB";
        list.add(str);
        str = PowerDisplayUtil.formatPower(this.getEnergyStored(itemStack)) + "/" + PowerDisplayUtil.formatPower(Config.rodOfReturnPowerStorage) + " " + PowerDisplayUtil.abrevation();
        list.add(str);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        ItemStack is = new ItemStack((Item)this);
        par3List.add(is);
        is = new ItemStack((Item)this);
        this.setFull(is);
        par3List.add(is);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public void renderItemOverlayIntoGUI(ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance.render(stack, xPosition, yPosition, true);
        PowerBarOverlayRenderHelper.instance_fluid.render(stack, xPosition, yPosition, 1, true);
    }

    @SideOnly(value=Side.CLIENT)
    private void onUsingClient(ItemStack stack, EntityLivingBase player, int timeLeft) {
        if (timeLeft > Config.rodOfReturnTicksToActivate - 2) {
            return;
        }
        float progress = 1.0f - (float)timeLeft / (float)Config.rodOfReturnTicksToActivate;
        float spinSpeed = progress * 2.0f;
        if (this.activeSound != null) {
            this.activeSound.setPitch(MathHelper.func_76131_a((float)(0.5f + spinSpeed / 1.5f), (float)0.5f, (float)2.0f));
        }
        if (this.activeSound == null) {
            BlockPos p = player.func_180425_c();
            this.activeSound = new MachineSound(TileTelePad.ACTIVE_RES, p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), 0.3f, 1.0f);
            this.playSound();
        }
        double dist = 2.0 - (double)progress * 1.5;
        Random rand = player.field_70170_p.field_73012_v;
        for (int i = 0; i < 6; ++i) {
            double xo = this.randomOffset(rand, dist);
            double yo = this.randomOffset(rand, dist);
            double zo = this.randomOffset(rand, dist);
            double x = player.field_70165_t + xo;
            double y = player.field_70163_u + yo + (double)(player.field_70131_O / 2.0f);
            double z = player.field_70161_v + zo;
            Vector3d velocity = new Vector3d(xo, yo, zo);
            velocity.normalize();
            Particle fx = Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.PORTAL.func_179348_c(), x, y, z, 0.0, 0.0, 0.0, new int[]{0});
            if (fx == null) continue;
            ClientUtil.setParticleVelocity((Particle)fx, (double)velocity.x, (double)velocity.y, (double)velocity.z);
            fx.func_187114_a(timeLeft + 2);
        }
    }

    private double randomOffset(Random rand, double magnitude) {
        return (rand.nextDouble() - 0.5) * magnitude;
    }

    @SideOnly(value=Side.CLIENT)
    private void playSound() {
        FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.activeSound);
    }

    @SideOnly(value=Side.CLIENT)
    private void stopPlayingSound() {
        if (this.activeSound != null) {
            this.activeSound.endPlaying();
            this.activeSound = null;
        }
    }

    private boolean updateStackNBT(ItemStack stack, World world, int timeLeft) {
        this.setLastUsedTick(stack, world.func_82737_E());
        if (timeLeft > Config.rodOfReturnTicksToActivate - 10) {
            return false;
        }
        return this.useEnergy(stack, timeLeft);
    }

    private long getLastUsedTick(ItemStack stack) {
        if (stack == null || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b(KEY_LAST_USED_TICK)) {
            return -1L;
        }
        return stack.func_77978_p().func_74763_f(KEY_LAST_USED_TICK);
    }

    private void setLastUsedTick(ItemStack stack, long tick) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74772_a(KEY_LAST_USED_TICK, tick);
    }

    private boolean useEnergy(ItemStack stack, int timeLeft) {
        int used = (Config.rodOfReturnTicksToActivate - timeLeft) * Config.rodOfReturnRfPerTick;
        int newVal = this.getEnergyStored(stack) - used;
        if (newVal < 0) {
            this.setEnergyStored(stack, 0);
            return false;
        }
        this.setEnergyStored(stack, newVal);
        return true;
    }

    @Override
    public void setFull(ItemStack container) {
        super.setFull(container);
        NbtValue.FLUIDAMOUNT.setInt(container, Config.rodOfReturnFluidStorage);
    }

    private void setTarget(ItemStack container, BlockPos pos, int dimension) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        new TelepadTarget(pos, dimension).writeToNBT(container.func_77978_p());
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        SpecialTooltipHandler.addCommonTooltipFromResources(list, (String)this.func_77658_a());
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        SpecialTooltipHandler.addBasicTooltipFromResources(list, (String)this.func_77658_a());
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        ArrayList entries = new ArrayList();
        SpecialTooltipHandler.addDetailedTooltipFromResources(entries, (String)this.func_77658_a());
        String fluidString = this.fluidType.getLocalizedName(new FluidStack(this.fluidType, 1000));
        for (int i = 0; i < entries.size(); ++i) {
            String str = (String)entries.get(i);
            list.add(String.format(str, fluidString));
        }
    }

    private boolean useFluid(ItemStack container) {
        int amount = NbtValue.FLUIDAMOUNT.getInt(container, 0);
        if (Config.rodOfReturnFluidUsePerTeleport > amount) {
            NbtValue.FLUIDAMOUNT.setInt(container, 0);
            return false;
        }
        NbtValue.FLUIDAMOUNT.setInt(container, amount - Config.rodOfReturnFluidUsePerTeleport);
        return true;
    }

    public FluidStack getFluid(ItemStack container) {
        int amount = NbtValue.FLUIDAMOUNT.getInt(container, 0);
        if (amount > 0) {
            return new FluidStack(this.fluidType, amount);
        }
        return null;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (container == null || container.func_77973_b() != this || resource == null || resource.amount <= 0 || resource.getFluid() == null || resource.getFluid() != this.fluidType) {
            return 0;
        }
        int capacity = Config.rodOfReturnFluidStorage;
        int amount = NbtValue.FLUIDAMOUNT.getInt(container, 0);
        int free = capacity - amount;
        int toFill = Math.min(resource.amount, free);
        if (toFill > 0 && doFill) {
            NbtValue.FLUIDAMOUNT.setInt(container, amount + toFill);
        }
        return toFill;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new CompoundCapabilityProvider(new ICapabilityProvider[]{new FluidCapabilityProvider(stack), new ItemPowerCapabilityBackend(stack)});
    }

    private class FluidCapabilityProvider
    implements IFluidHandler,
    ICapabilityProvider {
        protected final ItemStack container;

        private FluidCapabilityProvider(ItemStack container) {
            this.container = container;
        }

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this : null);
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new IFluidTankProperties(){

                @Nullable
                public FluidStack getContents() {
                    return ItemRodOfReturn.this.getFluid(FluidCapabilityProvider.this.container);
                }

                public int getCapacity() {
                    return Config.rodOfReturnFluidStorage;
                }

                public boolean canFill() {
                    return true;
                }

                public boolean canDrain() {
                    return false;
                }

                public boolean canFillFluidType(FluidStack fluidStack) {
                    return fluidStack != null && fluidStack.getFluid() == ItemRodOfReturn.this.fluidType;
                }

                public boolean canDrainFluidType(FluidStack fluidStack) {
                    return false;
                }
            }};
        }

        public int fill(FluidStack resource, boolean doFill) {
            return ItemRodOfReturn.this.fill(this.container, resource, doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }
}

