/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import com.enderio.core.common.util.BlockCoord;
import info.loenwind.autosave.Registry;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.IHandler;
import info.loenwind.autosave.handlers.java.HandleArrayList;
import java.lang.reflect.Field;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;

public class TelepadTarget
implements IHandler<TelepadTarget> {
    private BlockPos location;
    private int dimension;
    private String name;
    private ItemStack icon;

    public TelepadTarget() {
        this(new BlockPos(0, -1, 0), Integer.MIN_VALUE);
    }

    public TelepadTarget(BlockPos location, int dimension) {
        this(location, dimension, null, null);
    }

    public TelepadTarget(BlockPos location, int dimension, String name, ItemStack icon) {
        this.location = location;
        this.dimension = dimension;
        this.name = name;
        this.icon = icon;
    }

    public TelepadTarget(TelepadTarget newTarget) {
        this(newTarget.location, newTarget.dimension, newTarget.name, newTarget.icon);
    }

    public BlockPos getLocation() {
        return this.location;
    }

    public int getDimension() {
        return this.dimension;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public void setIcon(ItemStack icon) {
        this.icon = icon;
    }

    public int getX() {
        return this.location.func_177958_n();
    }

    public TelepadTarget setX(int x) {
        this.location = new BlockPos(x, this.getY(), this.getZ());
        return this;
    }

    public int getY() {
        return this.location.func_177956_o();
    }

    public TelepadTarget setY(int y) {
        this.location = new BlockPos(this.getX(), y, this.getZ());
        return this;
    }

    public int getZ() {
        return this.location.func_177952_p();
    }

    public TelepadTarget setZ(int z) {
        this.location = new BlockPos(this.getX(), this.getY(), z);
        return this;
    }

    public TelepadTarget setLocation(BlockPos pos) {
        if (pos == null) {
            pos = new BlockPos(0, -1, 0);
        }
        this.location = pos;
        return this;
    }

    public TelepadTarget setDimension(int dimension) {
        this.dimension = dimension;
        return this;
    }

    public String getChatString() {
        String res = "";
        if (this.name != null) {
            res = res + this.name + " ";
        }
        res = res + BlockCoord.chatString((BlockPos)this.location) + " ";
        res = res + TelepadTarget.getDimenionName(this.dimension);
        return res;
    }

    public String getDimenionName() {
        return TelepadTarget.getDimenionName(this.dimension);
    }

    public static String getDimenionName(int dim) {
        if (!DimensionManager.isDimensionRegistered((int)dim)) {
            return Integer.toString(dim);
        }
        DimensionType type = DimensionManager.getProviderType((int)dim);
        if (type == null) {
            return Integer.toString(dim);
        }
        String name = type.func_186065_b();
        int[] dims = DimensionManager.getDimensions((DimensionType)type);
        if (dims != null && dims.length > 1) {
            name = name + " " + dim;
        }
        return name;
    }

    public boolean isValid() {
        return this.location.func_177956_o() >= 0;
    }

    public String toString() {
        String res = "";
        if (this.name != null) {
            res = res + " " + this.name + " ";
        }
        res = res + this.location + " " + this.dimension;
        return res;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dimension;
        result = 31 * result + (this.icon == null ? 0 : this.icon.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TelepadTarget other = (TelepadTarget)obj;
        if (this.dimension != other.dimension) {
            return false;
        }
        if (this.icon == null ? other.icon != null : !this.icon.equals(other.icon)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals((Object)other.location)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public void writeToNBT(ItemStack printout) {
        if (printout == null) {
            return;
        }
        if (!printout.func_77942_o()) {
            printout.func_77982_d(new NBTTagCompound());
        }
        this.writeToNBT(printout.func_77978_p());
        if (this.getName() != null) {
            printout.func_151001_c(this.getName());
        } else {
            printout.func_135074_t();
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        if (this.location != null) {
            tag.func_74772_a("targetPos", this.location.func_177986_g());
        }
        tag.func_74768_a("targetDim", this.dimension);
        if (this.name != null) {
            tag.func_74778_a("targetName", this.name);
        }
        if (this.icon != null) {
            NBTTagCompound iconRoot = new NBTTagCompound();
            this.icon.func_77955_b(iconRoot);
            tag.func_74782_a("targetIcon", (NBTBase)iconRoot);
        }
    }

    public static TelepadTarget readFromNBT(ItemStack stack) {
        if (stack == null || !stack.func_77942_o()) {
            return null;
        }
        return TelepadTarget.readFromNBT(stack.func_77978_p());
    }

    public static TelepadTarget readFromNBT(NBTTagCompound tag) {
        BlockPos pos = TelepadTarget.getTargetPos(tag);
        if (pos == null) {
            return null;
        }
        return new TelepadTarget(pos, TelepadTarget.getTargetDimension(tag), TelepadTarget.getName(tag), TelepadTarget.getIcon(tag));
    }

    @Override
    public boolean canHandle(Class<?> clazz) {
        return TelepadTarget.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean store(@Nonnull Registry registry, @Nonnull Set<Store.StoreFor> phase, @Nonnull NBTTagCompound nbt, @Nonnull String name, @Nonnull TelepadTarget object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        NBTTagCompound root = new NBTTagCompound();
        object.writeToNBT(root);
        nbt.func_74782_a(name, (NBTBase)root);
        return true;
    }

    @Override
    public TelepadTarget read(@Nonnull Registry registry, @Nonnull Set<Store.StoreFor> phase, @Nonnull NBTTagCompound nbt, @Nullable Field field, @Nonnull String name, @Nullable TelepadTarget object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        if (nbt.func_74764_b(name)) {
            NBTTagCompound root = nbt.func_74775_l(name);
            return TelepadTarget.readFromNBT(root);
        }
        return new TelepadTarget();
    }

    private static ItemStack getIcon(NBTTagCompound tag) {
        if (tag == null || !tag.func_74764_b("targetIcon")) {
            return null;
        }
        return ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("targetIcon"));
    }

    private static String getName(NBTTagCompound tag) {
        if (tag == null || !tag.func_74764_b("targetName")) {
            return null;
        }
        return tag.func_74779_i("targetName");
    }

    private static BlockPos getTargetPos(NBTTagCompound tag) {
        if (tag == null || !tag.func_74764_b("targetPos")) {
            return null;
        }
        return BlockPos.func_177969_a((long)tag.func_74763_f("targetPos"));
    }

    private static int getTargetDimension(NBTTagCompound tag) {
        if (tag == null || !tag.func_74764_b("targetDim")) {
            return 0;
        }
        return tag.func_74762_e("targetDim");
    }

    static {
        Registry.GLOBAL_REGISTRY.register(new TelepadTarget());
    }

    public static class TelepadTargetArrayListHandler
    extends HandleArrayList<TelepadTarget> {
        public TelepadTargetArrayListHandler() {
            super(new TelepadTarget());
        }
    }
}

