/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.xp;

import net.minecraft.entity.player.EntityPlayer;

public class XpUtil {
    public static final int XP_PER_BOTTLE = 8;
    public static final int RATIO = 20;
    public static final int LIQUID_PER_XP_BOTTLE = 160;
    private static final Integer[] xpmap = new Integer[256];

    public static int liquidToExperience(int liquid) {
        return liquid / 20;
    }

    public static int experienceToLiquid(int xp) {
        return xp * 20;
    }

    public static int getLiquidForLevel(int level) {
        return XpUtil.experienceToLiquid(XpUtil.getExperienceForLevel(level));
    }

    public static int getExperienceForLevel(int level) {
        if (level >= 0 && level < xpmap.length) {
            return xpmap[level];
        }
        if (level >= 21863) {
            return Integer.MAX_VALUE;
        }
        return XpUtil.getExperienceForLevelImpl(level);
    }

    private static int getExperienceForLevelImpl(int level) {
        int res = 0;
        for (int i = 0; i < level; ++i) {
            if ((res += XpUtil.getXpBarCapacity(i)) >= 0) continue;
            return Integer.MAX_VALUE;
        }
        return res;
    }

    public static int getXpBarCapacity(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    public static int getLevelForExperience(int experience) {
        int i;
        for (i = 0; i < xpmap.length; ++i) {
            if (xpmap[i] <= experience) continue;
            return i - 1;
        }
        i = xpmap.length;
        while (XpUtil.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }

    public static int getPlayerXP(EntityPlayer player) {
        return (int)((float)XpUtil.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void addPlayerXP(EntityPlayer player, int amount) {
        int experience;
        player.field_71067_cb = experience = Math.max(0, XpUtil.getPlayerXP(player) + amount);
        player.field_71068_ca = XpUtil.getLevelForExperience(experience);
        int expForLevel = XpUtil.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    static {
        for (int i = 0; i < xpmap.length; ++i) {
            XpUtil.xpmap[i] = XpUtil.getExperienceForLevelImpl(i);
        }
    }
}

