/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.forge.event;

import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.util.Comparator;
import java.util.Map;
import journeymap.client.Constants;
import journeymap.client.forge.event.EventHandlerManager;
import journeymap.client.log.ChatLog;
import journeymap.client.model.Waypoint;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.dialog.OptionsManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.common.properties.Category;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.lwjgl.input.Keyboard;

public class KeyEventHandler
implements EventHandlerManager.EventHandler {
    public static String CATEGORY_ALL;
    public static String CATEGORY_FULLMAP;
    public static KeyBinding KB_FULLSCREEN;
    public static KeyBinding KB_MAP_ZOOMIN;
    public static KeyBinding KB_MAP_ZOOMOUT;
    public static KeyBinding KB_MAP_TOGGLE_TYPE;
    public static KeyBinding KB_MINIMAP_PRESET;
    public static KeyBinding KB_MINIMAP_TOGGLE;
    public static KeyBinding KB_CREATE_WAYPOINT;
    public static KeyBinding KB_WAYPOINT_MANAGER;
    public static KeyBinding KB_FULLMAP_OPTIONS_MANAGER;
    public static KeyBinding KB_FULLMAP_ACTIONS_MANAGER;
    public static KeyBinding KB_FULLMAP_PAN_NORTH;
    public static KeyBinding KB_FULLMAP_PAN_SOUTH;
    public static KeyBinding KB_FULLMAP_PAN_EAST;
    public static KeyBinding KB_FULLMAP_PAN_WEST;
    private static final Table<Integer, KeyBinding, Runnable> minimapKeymappings;
    private static final Table<Integer, KeyBinding, Runnable> gameKeymappings;
    private static final Table<Integer, KeyBinding, Runnable> guiKeymappings;
    private Minecraft mc = FMLClientHandler.instance().getClient();

    public static Table<Integer, KeyBinding, Runnable> createKeyMappingTable() {
        return TreeBasedTable.create(Comparator.naturalOrder(), Comparator.comparingInt(keyBinding -> keyBinding.getKeyModifier().ordinal()));
    }

    public KeyEventHandler() {
        CATEGORY_ALL = Constants.getString("jm.common.hotkeys_keybinding_category");
        CATEGORY_FULLMAP = Constants.getString("jm.common.hotkeys_keybinding_fullscreen_category");
        KB_MAP_ZOOMIN = this.register("key.journeymap.zoom_in", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 13, CATEGORY_ALL);
        KB_MAP_ZOOMOUT = this.register("key.journeymap.zoom_out", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 12, CATEGORY_ALL);
        KB_MAP_TOGGLE_TYPE = this.register("key.journeymap.minimap_type", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 26, CATEGORY_ALL);
        KB_MINIMAP_PRESET = this.register("key.journeymap.minimap_preset", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 43, CATEGORY_ALL);
        KB_CREATE_WAYPOINT = this.register("key.journeymap.create_waypoint", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 48, CATEGORY_ALL);
        KB_FULLSCREEN = this.register("key.journeymap.map_toggle_alt", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 36, CATEGORY_ALL);
        KB_MINIMAP_TOGGLE = this.register("key.journeymap.minimap_toggle_alt", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, 36, CATEGORY_ALL);
        KB_WAYPOINT_MANAGER = this.register("key.journeymap.fullscreen_waypoints", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, 48, CATEGORY_ALL);
        KB_FULLMAP_PAN_NORTH = this.register("key.journeymap.fullscreen.north", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 200, CATEGORY_FULLMAP);
        KB_FULLMAP_PAN_SOUTH = this.register("key.journeymap.fullscreen.south", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 208, CATEGORY_FULLMAP);
        KB_FULLMAP_PAN_EAST = this.register("key.journeymap.fullscreen.east", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 205, CATEGORY_FULLMAP);
        KB_FULLMAP_PAN_WEST = this.register("key.journeymap.fullscreen.west", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 203, CATEGORY_FULLMAP);
        KB_FULLMAP_OPTIONS_MANAGER = this.register("key.journeymap.fullscreen_options", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 24, CATEGORY_FULLMAP);
        KB_FULLMAP_ACTIONS_MANAGER = this.register("key.journeymap.fullscreen_actions", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 30, CATEGORY_FULLMAP);
        this.setKeymap(minimapKeymappings, KB_MINIMAP_TOGGLE, UIManager.INSTANCE::toggleMinimap);
        this.setKeymap(minimapKeymappings, KB_MAP_ZOOMIN, () -> MiniMap.state().zoomIn());
        this.setKeymap(minimapKeymappings, KB_MAP_ZOOMOUT, () -> MiniMap.state().zoomOut());
        this.setKeymap(minimapKeymappings, KB_MAP_TOGGLE_TYPE, () -> MiniMap.state().toggleMapType());
        this.setKeymap(minimapKeymappings, KB_MINIMAP_PRESET, UIManager.INSTANCE::switchMiniMapPreset);
        this.setKeymap(gameKeymappings, KB_WAYPOINT_MANAGER, () -> UIManager.INSTANCE.openWaypointManager(null, null));
        this.setKeymap(gameKeymappings, KB_CREATE_WAYPOINT, () -> UIManager.INSTANCE.openWaypointEditor(Waypoint.of((EntityPlayer)this.mc.field_71439_g), true, null));
        this.setKeymap(gameKeymappings, KB_FULLSCREEN, UIManager.INSTANCE::openFullscreenMap);
        this.setKeymap(guiKeymappings, KB_FULLSCREEN, UIManager.INSTANCE::closeAll);
        this.setKeymap(guiKeymappings, KB_MAP_ZOOMIN, () -> this.getFullscreen().zoomIn());
        this.setKeymap(guiKeymappings, KB_MAP_ZOOMOUT, () -> this.getFullscreen().zoomOut());
        this.setKeymap(guiKeymappings, KB_MAP_TOGGLE_TYPE, () -> this.getFullscreen().toggleMapType());
        this.setKeymap(guiKeymappings, KB_CREATE_WAYPOINT, () -> this.getFullscreen().createWaypointAtMouse());
        this.setKeymap(guiKeymappings, KB_WAYPOINT_MANAGER, () -> UIManager.INSTANCE.openWaypointManager(null, this.getFullscreen()));
        this.setKeymap(guiKeymappings, KB_FULLMAP_OPTIONS_MANAGER, () -> UIManager.INSTANCE.openOptionsManager(this.getFullscreen(), new Category[0]));
        this.setKeymap(guiKeymappings, KB_FULLMAP_ACTIONS_MANAGER, UIManager.INSTANCE::openMapActions);
        this.setKeymap(guiKeymappings, KB_FULLMAP_PAN_NORTH, () -> this.getFullscreen().moveCanvas(0, -16));
        this.setKeymap(guiKeymappings, KB_FULLMAP_PAN_WEST, () -> this.getFullscreen().moveCanvas(-16, 0));
        this.setKeymap(guiKeymappings, KB_FULLMAP_PAN_SOUTH, () -> this.getFullscreen().moveCanvas(0, 16));
        this.setKeymap(guiKeymappings, KB_FULLMAP_PAN_EAST, () -> this.getFullscreen().moveCanvas(16, 0));
    }

    private KeyBinding register(String description, IKeyConflictContext keyConflictContext, KeyModifier keyModifier, int keyCode, String category) {
        KeyBinding kb = new KeyBinding(description, keyConflictContext, keyModifier, keyCode, category);
        try {
            ClientRegistry.registerKeyBinding((KeyBinding)kb);
        }
        catch (Throwable t) {
            ChatLog.announceError("Unexpected error when registering keybinding : " + kb);
        }
        return kb;
    }

    private void setKeymap(Table<Integer, KeyBinding, Runnable> table, KeyBinding keybinding, Runnable action) {
        table.put((Object)keybinding.func_151463_i(), (Object)keybinding, (Object)action);
    }

    private Fullscreen getFullscreen() {
        return UIManager.INSTANCE.openFullscreenMap();
    }

    @SubscribeEvent
    public void onGameKeyboardEvent(InputEvent.KeyInputEvent event) {
        int key = Keyboard.getEventKey();
        if (Keyboard.isKeyDown((int)key)) {
            return;
        }
        if (KeyEventHandler.onKey(minimapKeymappings, key)) {
            return;
        }
        KeyEventHandler.onKey(gameKeymappings, key);
    }

    @SubscribeEvent
    public void onGuiKeyboardEvent(GuiScreenEvent.KeyboardInputEvent.Post event) {
        int key = Keyboard.getEventKey();
        if (Keyboard.isKeyDown((int)key)) {
            return;
        }
        if (this.inOptionsManager()) {
            KeyEventHandler.onKey(minimapKeymappings, key);
            return;
        }
        if (this.inFullscreen() && !this.getFullscreen().isChatOpen()) {
            KeyEventHandler.onKey(guiKeymappings, key);
        }
    }

    public static boolean onMinimapPreviewKeyboardEvent(int key) {
        return false;
    }

    private static boolean onKey(Table<Integer, KeyBinding, Runnable> table, int key) {
        if (table.containsRow((Object)key)) {
            for (Map.Entry entry : table.row((Object)key).entrySet()) {
                if (!((KeyBinding)entry.getKey()).isActiveAndMatches(key)) continue;
                ((Runnable)entry.getValue()).run();
                return true;
            }
        }
        return false;
    }

    private boolean inGame() {
        return this.mc.field_71462_r == null;
    }

    private boolean inFullscreen() {
        return this.mc.field_71462_r instanceof Fullscreen;
    }

    private boolean inOptionsManager() {
        return this.mc.field_71462_r instanceof OptionsManager;
    }

    static {
        minimapKeymappings = KeyEventHandler.createKeyMappingTable();
        gameKeymappings = KeyEventHandler.createKeyMappingTable();
        guiKeymappings = KeyEventHandler.createKeyMappingTable();
    }
}

