/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen.layer;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.data.DataCache;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.ui.fullscreen.layer.LayerDelegate;
import journeymap.client.ui.option.LocationFormat;
import journeymap.client.world.JmBlockAccess;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.FMLClientHandler;

public class BlockInfoLayer
implements LayerDelegate.Layer {
    private final List<DrawStep> drawStepList = new ArrayList<DrawStep>(1);
    LocationFormat locationFormat = new LocationFormat();
    LocationFormat.LocationFormatKeys locationFormatKeys;
    BlockPos lastCoord = null;
    long lastClicked = 0L;
    int lastMouseX;
    int lastMouseY;
    BlockInfoStep blockInfoStep;
    FontRenderer fontRenderer;
    boolean isSinglePlayer;

    public BlockInfoLayer() {
        this.fontRenderer = FMLClientHandler.instance().getClient().field_71466_p;
        this.blockInfoStep = new BlockInfoStep();
        this.drawStepList.add(this.blockInfoStep);
        this.isSinglePlayer = FMLClientHandler.instance().getClient().func_71356_B();
    }

    @Override
    public List<DrawStep> onMouseMove(Minecraft mc, GridRenderer gridRenderer, Point2D.Double mousePosition, BlockPos blockPos, float fontScale) {
        if (!blockPos.equals((Object)this.lastCoord)) {
            FullMapProperties fullMapProperties = Journeymap.getClient().getFullMapProperties();
            this.locationFormatKeys = this.locationFormat.getFormatKeys(fullMapProperties.locationFormat.get());
            this.lastCoord = blockPos;
            ChunkMD chunkMD = DataCache.INSTANCE.getChunkMD(blockPos);
            String info = "";
            if (chunkMD != null && chunkMD.hasChunk()) {
                BlockMD blockMD = chunkMD.getBlockMD(blockPos.func_177984_a());
                if (blockMD == null || blockMD.isIgnore()) {
                    blockMD = chunkMD.getBlockMD(blockPos.func_177977_b());
                }
                Biome biome = JmBlockAccess.INSTANCE.func_180494_b(blockPos);
                info = this.locationFormatKeys.format(fullMapProperties.locationFormatVerbose.get(), blockPos.func_177958_n(), blockPos.func_177952_p(), blockPos.func_177956_o(), blockPos.func_177956_o() >> 4) + " " + biome.func_185359_l();
                if (!blockMD.isIgnore()) {
                    info = blockMD.getName() + " @ " + info;
                }
            } else {
                Biome biome;
                info = Constants.getString("jm.common.location_xz_verbose", blockPos.func_177958_n(), blockPos.func_177952_p());
                if (this.isSinglePlayer && (biome = JmBlockAccess.INSTANCE.getBiome(blockPos, null)) != null) {
                    info = info + " " + biome.func_185359_l();
                }
            }
            double infoHeight = (double)DrawUtil.getLabelHeight(this.fontRenderer, true) * this.getMapFontScale();
            this.blockInfoStep.update(info, gridRenderer.getWidth() / 2, (double)gridRenderer.getHeight() - infoHeight);
        } else {
            this.blockInfoStep.update(this.blockInfoStep.text, gridRenderer.getWidth() / 2, this.blockInfoStep.y);
        }
        return this.drawStepList;
    }

    private double getMapFontScale() {
        return Journeymap.getClient().getFullMapProperties().fontScale.get().intValue();
    }

    @Override
    public List<DrawStep> onMouseClick(Minecraft mc, GridRenderer gridRenderer, Point2D.Double mousePosition, BlockPos blockCoord, int button, boolean doubleClick, float fontScale) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean propagateClick() {
        return true;
    }

    class BlockInfoStep
    implements DrawStep {
        Integer bgColor = 0x404040;
        Integer fgColor = 0xFFFFFF;
        double fontScale = 1.0;
        boolean fontShadow = false;
        float alpha = 1.0f;
        int ticks = 100;
        private double x;
        private double y;
        private String text;

        BlockInfoStep() {
        }

        void update(String text, double x, double y) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.alpha = 1.0f;
            this.ticks = 100;
        }

        @Override
        public void draw(DrawStep.Pass pass, double xOffset, double yOffset, GridRenderer gridRenderer, double fontScale, double rotation) {
            if (pass == DrawStep.Pass.Text) {
                if (this.ticks-- < 0 && this.alpha > 0.0f) {
                    this.alpha = (float)((double)this.alpha - 0.01);
                }
                if ((double)this.alpha > 0.1 && this.text != null) {
                    DrawUtil.drawLabel(this.text, this.x, this.y, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, this.bgColor, Math.max(0.0f, this.alpha), this.fgColor, Math.max(0.0f, this.alpha), BlockInfoLayer.this.getMapFontScale(), this.fontShadow);
                }
            }
        }

        @Override
        public int getDisplayOrder() {
            return 0;
        }

        @Override
        public String getModId() {
            return "journeymap";
        }
    }
}

