/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.theme;

import com.google.common.base.Strings;
import com.google.gson.annotations.Since;
import java.awt.Color;
import journeymap.client.cartography.color.RGB;
import net.minecraftforge.fml.common.FMLLog;

public class Theme
implements Comparable<Theme> {
    public static final int VERSION = 1;
    @Since(value=1.0)
    public String author;
    @Since(value=1.0)
    public String name;
    @Since(value=1.0)
    public String directory;
    @Since(value=1.0)
    public Container container = new Container();
    @Since(value=1.0)
    public Control control = new Control();
    @Since(value=1.0)
    public Fullscreen fullscreen = new Fullscreen();
    @Since(value=1.0)
    public ImageSpec icon = new ImageSpec();
    @Since(value=1.0)
    public Minimap minimap = new Minimap();

    public static String toHexColor(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static int getColor(String hexColor) {
        if (!Strings.isNullOrEmpty((String)hexColor)) {
            try {
                int color = Integer.parseInt(hexColor.replaceFirst("#", ""), 16);
                return color;
            }
            catch (Exception e) {
                FMLLog.warning((String)("Journeymap theme has an invalid color string: " + hexColor), (Object[])new Object[0]);
            }
        }
        return 0xFFFFFF;
    }

    public static float getAlpha(int alpha) {
        return RGB.toScaledFloat(alpha);
    }

    public String toString() {
        if (Strings.isNullOrEmpty((String)this.name)) {
            return "???";
        }
        return this.name;
    }

    @Override
    public int compareTo(Theme other) {
        if (Strings.isNullOrEmpty((String)this.name)) {
            return Strings.isNullOrEmpty((String)other.name) ? 0 : 1;
        }
        return this.name.compareTo(other.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Theme theme = (Theme)o;
        if (this.directory != null ? !this.directory.equals(theme.directory) : theme.directory != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(theme.name) : theme.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.directory != null ? this.directory.hashCode() : 0);
        return result;
    }

    public static class DefaultPointer {
        @Since(value=1.0)
        public String directory;
        @Since(value=1.0)
        public String filename;
        @Since(value=1.0)
        public String name;

        protected DefaultPointer() {
        }

        public DefaultPointer(Theme theme) {
            this.name = theme.name;
            this.filename = theme.name;
            this.directory = theme.directory;
        }
    }

    public static class LabelSpec {
        @Since(value=1.0)
        public String backgroundColor = Theme.toHexColor(Color.black);
        @Since(value=1.0)
        public int backgroundAlpha = 200;
        @Since(value=1.0)
        public String foregroundColor = Theme.toHexColor(Color.white);
        @Since(value=1.0)
        public int foregroundAlpha = 255;
        @Since(value=1.0)
        public boolean shadow = false;
    }

    public static class Minimap {
        @Since(value=1.0)
        public MinimapCircle circle = new MinimapCircle();
        @Since(value=1.0)
        public MinimapSquare square = new MinimapSquare();

        public static class MinimapSquare
        extends MinimapSpec {
            @Since(value=1.0)
            public ImageSpec topLeft = new ImageSpec();
            @Since(value=1.0)
            public ImageSpec top = new ImageSpec();
            @Since(value=1.0)
            public ImageSpec topRight = new ImageSpec();
            @Since(value=1.0)
            public ImageSpec right = new ImageSpec();
            @Since(value=1.0)
            public ImageSpec bottomRight = new ImageSpec();
            @Since(value=1.0)
            public ImageSpec bottom = new ImageSpec();
            @Since(value=1.0)
            public ImageSpec bottomLeft = new ImageSpec();
            @Since(value=1.0)
            public ImageSpec left = new ImageSpec();
        }

        public static class MinimapCircle
        extends MinimapSpec {
            @Since(value=1.0)
            public ImageSpec rim256 = new ImageSpec(256, 256);
            @Since(value=1.0)
            public ImageSpec mask256 = new ImageSpec(256, 256);
            @Since(value=1.0)
            public ImageSpec rim512 = new ImageSpec(512, 512);
            @Since(value=1.0)
            public ImageSpec mask512 = new ImageSpec(512, 512);
        }

        public static abstract class MinimapSpec {
            @Since(value=1.0)
            public int margin;
            @Since(value=1.0)
            public boolean labelTopInside;
            @Since(value=1.0)
            public int labelTopMargin;
            @Since(value=1.0)
            public boolean labelBottomInside;
            @Since(value=1.0)
            public int labelBottomMargin;
            @Since(value=1.0)
            public LabelSpec fpsLabel = new LabelSpec();
            @Since(value=1.0)
            public LabelSpec locationLabel = new LabelSpec();
            @Since(value=1.0)
            public LabelSpec biomeLabel = new LabelSpec();
            @Since(value=1.0)
            public LabelSpec compassLabel = new LabelSpec();
            @Since(value=1.0)
            public ImageSpec compassPoint = new ImageSpec();
            @Since(value=1.0)
            public String compassPointColor = "#ffffff";
            @Since(value=1.0)
            public int compassPointLabelPad;
            @Since(value=1.0)
            public double compassPointOffset;
            @Since(value=1.0)
            public boolean compassShowNorth = true;
            @Since(value=1.0)
            public boolean compassShowSouth = true;
            @Since(value=1.0)
            public boolean compassShowEast = true;
            @Since(value=1.0)
            public boolean compassShowWest = true;
            @Since(value=1.0)
            public double waypointOffset;
            @Since(value=1.0)
            public String reticleColor = "";
            @Since(value=1.0)
            public int reticleAlpha = 96;
            @Since(value=1.0)
            public int reticleHeadingAlpha = 112;
            @Since(value=1.0)
            public double reticleThickness = 2.25;
            @Since(value=1.0)
            public double reticleHeadingThickness = 2.5;
            @Since(value=1.0)
            public int reticleOffset;
            @Since(value=1.0)
            public String frameColor = "";
            @Since(value=1.0)
            public String prefix = "";
        }
    }

    public static class ImageSpec {
        @Since(value=1.0)
        public int width;
        @Since(value=1.0)
        public int height;

        public ImageSpec() {
        }

        public ImageSpec(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }

    public static class Fullscreen {
        @Since(value=1.0)
        public String mapBackgroundColor = "";
        @Since(value=1.0)
        public LabelSpec statusLabel = new LabelSpec();
    }

    public static class Control {
        @Since(value=1.0)
        public ButtonSpec button = new ButtonSpec();
        @Since(value=1.0)
        public ButtonSpec toggle = new ButtonSpec();

        public static class ButtonSpec {
            @Since(value=1.0)
            public boolean useThemeImages;
            @Since(value=1.0)
            public int width;
            @Since(value=1.0)
            public int height;
            @Since(value=1.0)
            public String prefix = "";
            @Since(value=1.0)
            public String tooltipOnStyle = "";
            @Since(value=1.0)
            public String tooltipOffStyle = "";
            @Since(value=1.0)
            public String tooltipDisabledStyle = "";
            @Since(value=1.0)
            public String iconOnColor = "";
            @Since(value=1.0)
            public String iconOffColor = "";
            @Since(value=1.0)
            public String iconHoverColor = "";
            @Since(value=1.0)
            public String iconDisabledColor = "";
        }
    }

    public static class Container {
        @Since(value=1.0)
        public Toolbar toolbar = new Toolbar();

        public static class Toolbar {
            @Since(value=1.0)
            public ToolbarSpec horizontal = new ToolbarSpec();
            @Since(value=1.0)
            public ToolbarSpec vertical = new ToolbarSpec();

            public static class ToolbarSpec {
                @Since(value=1.0)
                public boolean useThemeImages;
                @Since(value=1.0)
                public String prefix = "";
                @Since(value=1.0)
                public int margin;
                @Since(value=1.0)
                public int padding;
                @Since(value=1.0)
                public ImageSpec begin;
                @Since(value=1.0)
                public ImageSpec inner;
                @Since(value=1.0)
                public ImageSpec end;
            }
        }
    }
}

