/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.movingworld.client.render;

import io.github.elytra.movingworld.MovingWorldMod;
import io.github.elytra.movingworld.common.chunk.mobilechunk.MobileChunk;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MobileChunkRenderer {
    public boolean needsUpdate;
    public boolean isRemoved;
    private MobileChunk chunk;

    public MobileChunkRenderer(MobileChunk mobilechunk) {
        this.chunk = mobilechunk;
        this.needsUpdate = true;
    }

    public void render(float partialTicks) {
        if (this.needsUpdate) {
            try {
                this.updateSimpleRender(partialTicks);
            }
            catch (Exception e) {
                MovingWorldMod.LOG.error("Exception when rendering a MobileChunk! ", (Throwable)e);
            }
        }
    }

    private void updateSimpleRender(float partialTicks) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tessellator.func_178180_c();
        RenderHelper.func_74518_a();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179147_l();
        GlStateManager.func_179089_o();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (int y = this.chunk.minY(); y < this.chunk.maxY(); ++y) {
            for (int z = this.chunk.minZ(); z < this.chunk.maxZ(); ++z) {
                for (int x = this.chunk.minX(); x < this.chunk.maxX(); ++x) {
                    BlockPos pos = new BlockPos(x, y, z);
                    IBlockState blockState = this.chunk.func_180495_p(pos);
                    Block block = blockState.func_177230_c();
                    for (BlockRenderLayer blockRenderLayer : BlockRenderLayer.values()) {
                        if (!block.canRenderInLayer(blockState, blockRenderLayer)) continue;
                        ForgeHooksClient.setRenderLayer((BlockRenderLayer)blockRenderLayer);
                        if (block.func_149645_b(blockState).equals((Object)EnumBlockRenderType.INVISIBLE)) continue;
                        this.dispatchBlockRender(blockState, pos, vertexBuffer);
                    }
                    ForgeHooksClient.setRenderLayer(null);
                }
            }
        }
        vertexBuffer.func_178969_c(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179129_p();
        RenderHelper.func_74519_b();
        GlStateManager.func_179094_E();
        World tesrDispatchWorld = TileEntityRendererDispatcher.field_147556_a.field_147550_f;
        TileEntityRendererDispatcher.field_147556_a.func_147543_a((World)this.chunk.getFakeWorld());
        for (int y = this.chunk.minY(); y < this.chunk.maxY(); ++y) {
            for (int z = this.chunk.minZ(); z < this.chunk.maxZ(); ++z) {
                for (int x = this.chunk.minX(); x < this.chunk.maxX(); ++x) {
                    BlockPos pos = new BlockPos(x, y, z);
                    TileEntity tile = this.chunk.func_175625_s(pos);
                    if (tile == null) continue;
                    tile.func_145834_a((World)this.chunk.getFakeWorld());
                    TileEntitySpecialRenderer renderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(tile);
                    if (renderer != null && tile.shouldRenderInPass(MinecraftForgeClient.getRenderPass())) {
                        TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile, (double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p(), partialTicks);
                    }
                    tile.func_145834_a(this.chunk.worldObj);
                }
            }
        }
        TileEntityRendererDispatcher.field_147556_a.func_147543_a(tesrDispatchWorld);
        GlStateManager.func_179121_F();
    }

    public void dispatchBlockRender(IBlockState blockState, BlockPos blockPos, VertexBuffer vertexBuffer) {
        vertexBuffer.func_181666_a(1.0f, 1.0f, 1.0f, 1.0f);
        BlockRendererDispatcher blockRendererDispatcher = Minecraft.func_71410_x().func_175602_ab();
        blockRendererDispatcher.func_175018_a(blockState, blockPos, (IBlockAccess)this.chunk.getFakeWorld(), vertexBuffer);
    }

    public void markDirty() {
        this.needsUpdate = true;
    }

    public void markRemoved() {
        this.isRemoved = true;
    }
}

