/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.invoke.ModifyConstantInjector;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.util.ASMHelper;

public class ModifyConstantInjectionInfo
extends InjectionInfo {
    public ModifyConstantInjectionInfo(MixinTargetContext mixin, MethodNode method, AnnotationNode annotation) {
        super(mixin, method, annotation);
    }

    @Override
    protected List<AnnotationNode> readInjectionPoints(String type) {
        AnnotationNode constantAnnotation = (AnnotationNode)ASMHelper.getAnnotationValue(this.annotation, "constant");
        ArrayList<AnnotationNode> ats = new ArrayList<AnnotationNode>();
        ats.add(constantAnnotation);
        return ats;
    }

    @Override
    protected void parseInjectionPoints(List<AnnotationNode> ats) {
        Type returnType = Type.getReturnType(this.method.desc);
        for (AnnotationNode at : ats) {
            this.injectionPoints.add(new BeforeConstant(this, at, returnType.getDescriptor()));
        }
    }

    @Override
    protected Injector parseInjector(AnnotationNode injectAnnotation) {
        return new ModifyConstantInjector(this);
    }

    @Override
    protected String getDescription() {
        return "Constant modifier method";
    }

    static class BeforeConstant
    extends InjectionPoint {
        private static final Logger logger = LogManager.getLogger((String)"mixin");
        private final int ordinal;
        private final boolean nullValue;
        private final Integer intValue;
        private final Float floatValue;
        private final Long longValue;
        private final Double doubleValue;
        private final String stringValue;
        private final Type typeValue;
        private final String matchByType;
        private final boolean log;

        public BeforeConstant(InjectionInfo info, AnnotationNode node, String returnType) {
            Boolean empty = ASMHelper.getAnnotationValue(node, "nullValue", (Boolean)null);
            this.ordinal = ASMHelper.getAnnotationValue(node, "ordinal", -1);
            this.nullValue = empty != null ? empty : false;
            this.intValue = ASMHelper.getAnnotationValue(node, "intValue", (Integer)null);
            this.floatValue = ASMHelper.getAnnotationValue(node, "floatValue", (Float)null);
            this.longValue = ASMHelper.getAnnotationValue(node, "longValue", (Long)null);
            this.doubleValue = ASMHelper.getAnnotationValue(node, "doubleValue", (Double)null);
            this.stringValue = ASMHelper.getAnnotationValue(node, "stringValue", (String)null);
            this.typeValue = ASMHelper.getAnnotationValue(node, "classValue", (Type)null);
            int c = BeforeConstant.count(empty, this.intValue, this.floatValue, this.longValue, this.doubleValue, this.stringValue, this.typeValue);
            if (c == 1) {
                returnType = null;
            } else if (c > 1) {
                throw new InvalidInjectionException(info, "Conflicting constant discriminators specified on @Constant annotation for " + info);
            }
            this.matchByType = returnType;
            this.log = ASMHelper.getAnnotationValue(node, "log", Boolean.FALSE);
        }

        @Override
        public boolean find(String desc, InsnList insns, Collection<AbstractInsnNode> nodes) {
            boolean found = false;
            if (this.log) {
                logger.info("BeforeConstant is searching for an constants in method with descriptor {}", new Object[]{desc});
            }
            ListIterator<AbstractInsnNode> iter = insns.iterator();
            int ordinal = 0;
            while (iter.hasNext()) {
                AbstractInsnNode insn = iter.next();
                boolean matchesInsn = this.matchesInsn(insn);
                if (!matchesInsn) continue;
                if (this.log) {
                    String byType = this.matchByType != null ? " TYPE" : " value";
                    logger.info("    BeforeConstant found a matching constant{} at ordinal {}", new Object[]{byType, ordinal});
                }
                if (this.ordinal == -1 || this.ordinal == ordinal) {
                    if (this.log) {
                        logger.info("      BeforeConstant found {}", new Object[]{ASMHelper.getNodeDescriptionForDebug(insn).trim()});
                    }
                    nodes.add(insn);
                    found = true;
                }
                ++ordinal;
            }
            return found;
        }

        private boolean matchesInsn(AbstractInsnNode insn) {
            if (!ASMHelper.isConstant(insn)) {
                return false;
            }
            Object value = ASMHelper.getConstant(insn);
            if (value == null) {
                if (this.log) {
                    logger.info("  BeforeConstant found NULL constant: nullValue = {}", new Object[]{this.nullValue});
                }
                return this.nullValue || "Ljava/lang/Object;".equals(this.matchByType);
            }
            if (value instanceof Integer) {
                if (this.log) {
                    logger.info("  BeforeConstant found INTEGER constant: value = {}, intValue = {}", new Object[]{value, this.intValue});
                }
                return value.equals(this.intValue) || "I".equals(this.matchByType);
            }
            if (value instanceof Float) {
                if (this.log) {
                    logger.info("  BeforeConstant found FLOAT constant: value = {}, floatValue = {}", new Object[]{value, this.floatValue});
                }
                return value.equals(this.floatValue) || "F".equals(this.matchByType);
            }
            if (value instanceof Long) {
                if (this.log) {
                    logger.info("  BeforeConstant found LONG constant: value = {}, longValue = {}", new Object[]{value, this.longValue});
                }
                return value.equals(this.longValue) || "J".equals(this.matchByType);
            }
            if (value instanceof Double) {
                if (this.log) {
                    logger.info("  BeforeConstant found DOUBLE constant: value = {}, doubleValue = {}", new Object[]{value, this.doubleValue});
                }
                return value.equals(this.doubleValue) || "D".equals(this.matchByType);
            }
            if (value instanceof String) {
                if (this.log) {
                    logger.info("  BeforeConstant found STRING constant: value = {}, stringValue = {}", new Object[]{value, this.stringValue});
                }
                return value.equals(this.stringValue) || "Ljava/lang/String;".equals(this.matchByType);
            }
            if (value instanceof Type) {
                if (this.log) {
                    logger.info("  BeforeConstant found CLASS constant: value = {}, typeValue = {}", new Object[]{value, this.typeValue});
                }
                return value.equals(this.typeValue) || "Ljava/lang/Class;".equals(this.matchByType);
            }
            return false;
        }

        private static int count(Object ... values) {
            int counter = 0;
            for (Object value : values) {
                if (value == null) continue;
                ++counter;
            }
            return counter;
        }
    }
}

