/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import me.ichun.mods.hats.api.RenderOnEntityHelper;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.core.HatHandler;
import me.ichun.mods.hats.common.core.HatInfo;
import me.ichun.mods.hats.common.core.SessionState;
import me.ichun.mods.hats.common.core.TimeActiveInfo;
import me.ichun.mods.hats.common.packet.PacketKingOfTheHatInfo;
import me.ichun.mods.hats.common.packet.PacketPing;
import me.ichun.mods.hats.common.packet.PacketSession;
import me.ichun.mods.hats.common.trade.TradeInfo;
import me.ichun.mods.hats.common.trade.TradeRequest;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class EventHandlerServer {
    public WeakHashMap<EntityLivingBase, String> mobHats = new WeakHashMap();
    public HashMap<String, TreeMap<String, Integer>> playerHats = new HashMap();
    public HashMap<String, TimeActiveInfo> playerActivity = new HashMap();
    public HashMap<String, TradeRequest> playerTradeRequests = new HashMap();
    public ArrayList<TradeInfo> activeTrades = new ArrayList();

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            void var3_7;
            this.mobHats.entrySet().removeIf(e -> ((EntityLivingBase)e.getKey()).field_70128_L);
            for (Map.Entry<String, TimeActiveInfo> entry : this.playerActivity.entrySet()) {
                TimeActiveInfo info = entry.getValue();
                info.tick();
                if (info.timeLeft != 0 || !info.active) continue;
                ++info.levels;
                info.timeLeft = Hats.config.startTime;
                TreeMap<String, Integer> playerHatsList = Hats.eventHandlerServer.getPlayerHatsList(entry.getKey());
                ArrayList<String> newHats = HatHandler.getAllHatNamesAsList();
                for (Map.Entry<String, Integer> e1 : playerHatsList.entrySet()) {
                    newHats.remove(e1.getKey());
                }
                EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(entry.getKey());
                if (player != null && !newHats.isEmpty()) {
                    HatHandler.unlockHat((EntityPlayer)player, HatHandler.getRandomHatFromList(newHats, (boolean)(Hats.config.hatRarity == 1 ? true : false)).hatName);
                }
                for (int i = 0; i < info.levels; ++i) {
                    info.timeLeft = (int)((float)info.timeLeft * (1.0f + (float)Hats.config.timeIncrement / 10000.0f));
                }
            }
            Iterator<Map.Entry<String, TradeRequest>> ite = this.playerTradeRequests.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<String, TradeRequest> entry = ite.next();
                TradeRequest tr = entry.getValue();
                ++tr.timePending;
                if (tr.timePending < 1200) continue;
                ite.remove();
            }
            int n = this.activeTrades.size() - 1;
            while (var3_7 >= 0) {
                TradeInfo ti = this.activeTrades.get((int)var3_7);
                ti.update();
                if (ti.trade1 && ti.trade2) {
                    TreeMap<String, Integer> trader1Hats = Hats.eventHandlerServer.getPlayerHatsList(ti.trader1.func_70005_c_());
                    TreeMap<String, Integer> trader2Hats = Hats.eventHandlerServer.getPlayerHatsList(ti.trader2.func_70005_c_());
                    this.transferHat(trader1Hats, trader2Hats, ti.trader1Hats);
                    this.transferHat(trader2Hats, trader1Hats, ti.trader2Hats);
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry<String, Integer> e1 : trader1Hats.entrySet()) {
                        String hatName = HatHandler.getNameForHat(e1.getKey());
                        sb.append(hatName);
                        if (e1.getValue() > 1) {
                            sb.append(">" + e1.getValue());
                        }
                        sb.append(":");
                    }
                    NBTTagCompound persistentTag = ti.trader1.getEntityData().func_74775_l("PlayerPersisted");
                    persistentTag.func_74778_a("Hats_unlocked", sb.toString().length() > 0 ? sb.toString().substring(0, sb.toString().length() - 1) : sb.toString());
                    ti.trader1.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persistentTag);
                    StringBuilder sb1 = new StringBuilder();
                    for (Map.Entry<String, Integer> e1 : trader2Hats.entrySet()) {
                        String hatName = HatHandler.getNameForHat(e1.getKey());
                        sb1.append(hatName);
                        if (e1.getValue() > 1) {
                            sb1.append(">" + e1.getValue());
                        }
                        sb1.append(":");
                    }
                    persistentTag = ti.trader2.getEntityData().func_74775_l("PlayerPersisted");
                    persistentTag.func_74778_a("Hats_unlocked", sb1.toString().length() > 0 ? sb1.toString().substring(0, sb1.toString().length() - 1) : sb1.toString());
                    ti.trader2.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persistentTag);
                    EventHandlerServer.sendPlayerSessionInfo(ti.trader1);
                    EventHandlerServer.sendPlayerSessionInfo(ti.trader2);
                    this.removeItems(ti.trader1, ti.trader1Items);
                    this.removeItems(ti.trader2, ti.trader2Items);
                    for (ItemStack is : ti.trader2Items) {
                        if (ti.trader1.field_71071_by.func_70441_a(is)) continue;
                        ti.trader1.func_71019_a(is, false);
                    }
                    for (ItemStack is : ti.trader1Items) {
                        if (ti.trader2.field_71071_by.func_70441_a(is)) continue;
                        ti.trader2.func_71019_a(is, false);
                    }
                    Hats.channel.sendTo((AbstractPacket)new PacketPing(3, false), ti.trader1);
                    Hats.channel.sendTo((AbstractPacket)new PacketPing(3, false), ti.trader2);
                    ti.terminate = true;
                    this.activeTrades.remove((int)var3_7);
                } else if (ti.terminate) {
                    this.activeTrades.remove((int)var3_7);
                }
                --var3_7;
            }
        }
    }

    public void transferHat(TreeMap<String, Integer> origin, TreeMap<String, Integer> destination, TreeMap<String, Integer> hatsList) {
        HashMap temp = new HashMap();
        Iterator<Map.Entry<String, Integer>> ite = origin.entrySet().iterator();
        block0: while (ite.hasNext()) {
            Map.Entry<String, Integer> e = ite.next();
            for (Map.Entry<String, Integer> entry : hatsList.entrySet()) {
                if (!((String)e.getKey()).equals(entry.getKey())) continue;
                if ((Integer)e.getValue() - entry.getValue() <= 0) {
                    ite.remove();
                    continue block0;
                }
                temp.put(e.getKey(), (Integer)e.getValue() - entry.getValue());
            }
        }
        for (Map.Entry entry : temp.entrySet()) {
            origin.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        temp.clear();
        Iterator<Map.Entry<String, Integer>> ite1 = hatsList.entrySet().iterator();
        block3: while (ite1.hasNext()) {
            Map.Entry<String, Integer> entry = ite1.next();
            for (Map.Entry<String, Integer> entry2 : destination.entrySet()) {
                if (!entry.getKey().equals(entry2.getKey())) continue;
                temp.put(entry2.getKey(), entry.getValue() + entry2.getValue());
                ite1.remove();
                continue block3;
            }
        }
        for (Map.Entry entry : temp.entrySet()) {
            destination.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        temp.clear();
        for (Map.Entry<String, Integer> entry : hatsList.entrySet()) {
            destination.put(entry.getKey(), entry.getValue());
        }
    }

    public void removeItems(EntityPlayer origin, ArrayList<ItemStack> itemsList) {
        ItemStack is1;
        ArrayList<ItemStack> itemsListCopy = new ArrayList<ItemStack>();
        for (ItemStack is : itemsList) {
            itemsListCopy.add(is.func_77946_l());
        }
        for (int i = origin.field_71071_by.field_70462_a.length - 1; i >= 0; --i) {
            ItemStack is;
            is = origin.field_71071_by.field_70462_a[i];
            if (is == null) continue;
            for (int j = itemsListCopy.size() - 1; j >= 0; --j) {
                is1 = (ItemStack)itemsListCopy.get(j);
                if (!is1.func_77969_a(is) || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)is1)) continue;
                while (is.field_77994_a > 0 && is1.field_77994_a > 0) {
                    --is.field_77994_a;
                    --is1.field_77994_a;
                }
                if (is1.field_77994_a > 0) continue;
                itemsListCopy.remove(j);
            }
            if (is.field_77994_a <= 0) {
                origin.field_71071_by.field_70462_a[i] = null;
            }
            origin.field_71071_by.func_70296_d();
        }
        for (ItemStack is : itemsListCopy) {
            for (int i = itemsList.size() - 1; i >= 0; --i) {
                is1 = itemsList.get(i);
                if (!is1.func_77969_a(is) || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)is1)) continue;
                while (is.field_77994_a > 0 && is1.field_77994_a > 0) {
                    --is.field_77994_a;
                    --is1.field_77994_a;
                }
                if (is1.field_77994_a > 0) continue;
                itemsList.remove(i);
            }
        }
    }

    public void playerKilledEntity(EntityLivingBase living, EntityPlayer player) {
        String hat = this.mobHats.get(living);
        RenderOnEntityHelper helper = HatHandler.getRenderHelper(living.getClass());
        if ((helper == null || helper.canUnlockHat(living)) && hat != null) {
            HatHandler.unlockHat(player, hat);
        }
        this.mobHats.remove(living);
    }

    public void playerDeath(EntityPlayer player) {
        NBTTagCompound persistentTag = player.getEntityData().func_74775_l("PlayerPersisted");
        persistentTag.func_74778_a("Hats_unlocked", "");
        player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persistentTag);
        Hats.proxy.playerWornHats.put(player.func_70005_c_(), new HatInfo());
        Hats.channel.sendTo((AbstractPacket)new PacketPing(1, false), player);
        Hats.proxy.sendPlayerListOfWornHats(player, false, false);
    }

    public void updateNewKing(String newKing, EntityPlayer player, boolean send) {
        if (!SessionState.currentKingServer.equalsIgnoreCase("") && !SessionState.currentKingServer.equalsIgnoreCase(newKing)) {
            EntityPlayerMP oldKing = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(SessionState.currentKingServer);
            if (oldKing != null) {
                this.playerDeath((EntityPlayer)oldKing);
            }
            TreeMap<String, Integer> playerHatsList = Hats.eventHandlerServer.getPlayerHatsList(SessionState.currentKingServer);
            Hats.eventHandlerServer.playerHats.put(SessionState.currentKingServer, null);
            Hats.eventHandlerServer.playerHats.put(newKing, playerHatsList);
        }
        SessionState.currentKingServer = newKing;
        if (send) {
            if (player != null) {
                if (player.func_70005_c_().equalsIgnoreCase(SessionState.currentKingServer)) {
                    StringBuilder sb = new StringBuilder();
                    TreeMap<String, Integer> hats = Hats.eventHandlerServer.playerHats.get(newKing);
                    if (hats != null) {
                        for (Map.Entry<String, Integer> e : hats.entrySet()) {
                            sb.append(e.getKey());
                            if (e.getValue() != 1) {
                                sb.append(">" + e.getValue());
                            }
                            sb.append(":");
                        }
                    }
                    Hats.channel.sendTo((AbstractPacket)new PacketKingOfTheHatInfo(SessionState.currentKingServer, sb.toString().length() > 0 ? sb.toString().substring(0, sb.toString().length() - 1) : sb.toString()), player);
                } else {
                    Hats.channel.sendTo((AbstractPacket)new PacketKingOfTheHatInfo(SessionState.currentKingServer, ""), player);
                }
            } else {
                Hats.channel.sendToAll((AbstractPacket)new PacketKingOfTheHatInfo(SessionState.currentKingServer, ""));
            }
        }
    }

    public void initializeTrade(EntityPlayerMP player, EntityPlayerMP plyr) {
        if (player == null || plyr == null) {
            return;
        }
        this.activeTrades.add(new TradeInfo((EntityPlayer)player, (EntityPlayer)plyr).initialize());
    }

    public TreeMap<String, Integer> getPlayerHatsList(String player) {
        TreeMap playerHatsList = Hats.eventHandlerServer.playerHats.computeIfAbsent(player, k -> new TreeMap());
        return playerHatsList;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        HatInfo hatInfo;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() || !(event.getEntity() instanceof EntityLivingBase) || !HatHandler.canMobHat((EntityLivingBase)event.getEntity()) || Hats.eventHandlerServer.mobHats.containsKey(event.getEntity())) {
            return;
        }
        EntityLivingBase living = (EntityLivingBase)event.getEntity();
        boolean fromSpawner = false;
        for (int k = 0; k < event.getEntity().field_70170_p.field_147482_g.size(); ++k) {
            List list;
            Entity entity;
            MobSpawnerBaseLogic logic;
            TileEntity te = (TileEntity)event.getEntity().field_70170_p.field_147482_g.get(k);
            if (!HatHandler.isMobSpawner(te.getClass(), te.getClass()) || !(logic = HatHandler.getMobSpawnerLogic(te.getClass(), te)).func_98279_f() || (entity = EntityList.func_75620_a((String)logic.func_98276_e(), (World)logic.func_98271_a())) == null || living.getClass() != entity.getClass() || !(list = logic.func_98271_a().func_72872_a(entity.getClass(), new AxisAlignedBB((double)logic.func_177221_b().func_177958_n(), (double)logic.func_177221_b().func_177956_o(), (double)logic.func_177221_b().func_177952_p(), (double)(logic.func_177221_b().func_177958_n() + 1), (double)(logic.func_177221_b().func_177956_o() + 1), (double)(logic.func_177221_b().func_177952_p() + 1)).func_72314_b(8.0, 4.0, 8.0))).contains(living)) continue;
            fromSpawner = true;
            break;
        }
        if (living.getEntityData().func_74764_b("Hats_hatInfo")) {
            hatInfo = new HatInfo(living.getEntityData().func_74779_i("Hats_hatInfo"));
        } else {
            hatInfo = living.func_70681_au().nextFloat() < (float)Hats.config.randomMobHat / 100.0f && !fromSpawner ? HatHandler.getRandomHatFromList(HatHandler.getHatsWithWeightedContributors(), Hats.config.playerHatsMode == 4 && Hats.config.hatRarity == 1) : new HatInfo();
            living.getEntityData().func_74778_a("Hats_hatInfo", hatInfo.hatName);
        }
        if (!hatInfo.hatName.isEmpty()) {
            Hats.eventHandlerServer.mobHats.put(living, hatInfo.hatName);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            if (Hats.config.playerHatsMode >= 4) {
                if (Hats.config.playerHatsMode == 4 && !(event.getEntityLiving() instanceof EntityPlayer) && event.getSource().func_76346_g() instanceof EntityPlayer && !((EntityPlayer)event.getSource().func_76346_g()).field_71075_bZ.field_75098_d) {
                    Hats.eventHandlerServer.playerKilledEntity(event.getEntityLiving(), (EntityPlayer)event.getSource().func_76346_g());
                }
                if (event.getEntityLiving() instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                    EntityPlayer executer = null;
                    if (event.getSource().func_76346_g() instanceof EntityPlayer) {
                        executer = (EntityPlayer)event.getSource().func_76346_g();
                    }
                    if (Hats.config.playerHatsMode == 5) {
                        if (SessionState.currentKingServer.equalsIgnoreCase(player.func_70005_c_())) {
                            if (executer != null) {
                                Hats.eventHandlerServer.updateNewKing(executer.func_70005_c_(), null, true);
                                Hats.eventHandlerServer.updateNewKing(executer.func_70005_c_(), executer, true);
                                FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148539_a((ITextComponent)new TextComponentTranslation("hats.kingOfTheHat.update.playerSlayed", new Object[]{player.func_70005_c_(), executer.func_70005_c_()}));
                            } else {
                                List players = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
                                ArrayList list = new ArrayList(players);
                                list.remove(player);
                                if (!list.isEmpty()) {
                                    EntityPlayer newKing = (EntityPlayer)list.get(player.field_70170_p.field_73012_v.nextInt(list.size()));
                                    Hats.eventHandlerServer.updateNewKing(newKing.func_70005_c_(), null, true);
                                    Hats.eventHandlerServer.updateNewKing(newKing.func_70005_c_(), newKing, true);
                                    FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148539_a((ITextComponent)new TextComponentTranslation("hats.kingOfTheHat.update.playerDied", new Object[]{player.func_70005_c_(), newKing.func_70005_c_()}));
                                }
                            }
                        } else if (executer != null && SessionState.currentKingServer.equalsIgnoreCase(executer.func_70005_c_())) {
                            TreeMap<String, Integer> playerHatsList = Hats.eventHandlerServer.getPlayerHatsList(executer.func_70005_c_());
                            ArrayList<String> newHats = HatHandler.getAllHatNamesAsList();
                            for (Map.Entry<String, Integer> e : playerHatsList.entrySet()) {
                                newHats.remove(e.getKey());
                            }
                            EntityPlayerMP newKingEnt = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(executer.func_70005_c_());
                            if (newKingEnt != null && !newHats.isEmpty()) {
                                HatHandler.unlockHat((EntityPlayer)newKingEnt, newHats.get(newKingEnt.field_70170_p.field_73012_v.nextInt(newHats.size())));
                            }
                        }
                    }
                    if (Hats.config.resetPlayerHatsOnDeath == 1) {
                        Hats.eventHandlerServer.playerDeath((EntityPlayer)event.getEntityLiving());
                    }
                }
            }
            Hats.eventHandlerServer.mobHats.remove(event.getEntityLiving());
        }
    }

    public static void sendPlayerSessionInfo(EntityPlayer player) {
        TreeMap<String, Integer> playerHatsList = Hats.eventHandlerServer.getPlayerHatsList(player.func_70005_c_());
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> e : playerHatsList.entrySet()) {
            sb.append(e.getKey());
            if (e.getValue() != 1) {
                sb.append(">" + e.getValue());
            }
            sb.append(":");
        }
        Hats.channel.sendTo((AbstractPacket)new PacketSession(player.getEntityData().func_74775_l("PlayerPersisted").func_74767_n("Hats_hasVisited") && player.getEntityData().func_74775_l("PlayerPersisted").func_74762_e("Hats_hatMode") == Hats.config.playerHatsMode || Hats.config.firstJoinMessage != 1, SessionState.currentKingServer, sb.toString().length() > 0 ? sb.toString().substring(0, sb.toString().length() - 1) : sb.toString()), player);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        String[] hatsWithCount;
        if (Hats.config.playerHatsMode == 5 && SessionState.currentKingServer.equalsIgnoreCase("")) {
            Hats.eventHandlerServer.updateNewKing(event.player.func_70005_c_(), null, false);
            FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148539_a((ITextComponent)new TextComponentTranslation("hats.kingOfTheHat.update.playerJoin", new Object[]{event.player.func_70005_c_()}));
        }
        String playerHats = event.player.getEntityData().func_74775_l("PlayerPersisted").func_74779_i("Hats_unlocked");
        if (Hats.config.playerHatsMode == 5 && !SessionState.currentKingServer.equalsIgnoreCase(event.player.func_70005_c_())) {
            playerHats = "";
            NBTTagCompound persistentTag = event.player.getEntityData().func_74775_l("PlayerPersisted");
            persistentTag.func_74778_a("Hats_unlocked", playerHats);
            persistentTag.func_74778_a("Hats_wornHat", "");
            event.player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persistentTag);
        }
        TreeMap<String, Integer> playerHatsList = Hats.eventHandlerServer.getPlayerHatsList(event.player.func_70005_c_());
        playerHatsList.clear();
        for (String hat : hatsWithCount = playerHats.split(":")) {
            String[] hatAndCount = hat.split(">");
            if (hatAndCount[0].trim().isEmpty()) continue;
            try {
                playerHatsList.put(hatAndCount[0], hatAndCount.length == 1 ? 1 : Integer.parseInt(hatAndCount[1]));
            }
            catch (NumberFormatException e) {
                playerHatsList.put(hatAndCount[0], 1);
            }
        }
        String hatName = event.player.getEntityData().func_74775_l("PlayerPersisted").func_74779_i("Hats_wornHat");
        int r = event.player.getEntityData().func_74775_l("PlayerPersisted").func_74762_e("Hats_colourR");
        int g = event.player.getEntityData().func_74775_l("PlayerPersisted").func_74762_e("Hats_colourG");
        int b = event.player.getEntityData().func_74775_l("PlayerPersisted").func_74762_e("Hats_colourB");
        int a = event.player.getEntityData().func_74775_l("PlayerPersisted").func_74762_e("Hats_alpha");
        if (a == 0) {
            event.player.getEntityData().func_74775_l("PlayerPersisted").func_74768_a("Hats_alpha", 255);
            a = 255;
        }
        if (!HatHandler.hasHat(hatName)) {
            HatHandler.requestHat(hatName, event.player);
        }
        Hats.proxy.playerWornHats.put(event.player.func_70005_c_(), new HatInfo(hatName, r, g, b, a));
        if (Hats.config.playerHatsMode == 6) {
            TimeActiveInfo info = Hats.eventHandlerServer.playerActivity.get(event.player.func_70005_c_());
            if (info == null) {
                info = new TimeActiveInfo();
                info.timeLeft = event.player.getEntityData().func_74775_l("PlayerPersisted").func_74762_e("Hats_activityTimeleft");
                info.levels = event.player.getEntityData().func_74775_l("PlayerPersisted").func_74762_e("Hats_activityLevels");
                if (info.levels == 0 && info.timeLeft == 0) {
                    info.levels = 0;
                    info.timeLeft = Hats.config.startTime;
                }
                Hats.eventHandlerServer.playerActivity.put(event.player.func_70005_c_(), info);
            }
            info.active = true;
        }
        EventHandlerServer.sendPlayerSessionInfo(event.player);
        NBTTagCompound persistentTag = event.player.getEntityData().func_74775_l("PlayerPersisted");
        persistentTag.func_74757_a("Hats_hasVisited", true);
        persistentTag.func_74768_a("Hats_hatMode", Hats.config.playerHatsMode);
        event.player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persistentTag);
        if (Hats.config.playerHatsMode != 2) {
            Hats.proxy.sendPlayerListOfWornHats(event.player, true);
            Hats.proxy.sendPlayerListOfWornHats(event.player, false);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        TimeActiveInfo info;
        if (Hats.config.playerHatsMode == 5 && SessionState.currentKingServer.equalsIgnoreCase(event.player.func_70005_c_())) {
            List players = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
            ArrayList list = new ArrayList(players);
            list.remove(event.player);
            if (!list.isEmpty()) {
                EntityPlayer newKing = (EntityPlayer)list.get(event.player.field_70170_p.field_73012_v.nextInt(list.size()));
                Hats.eventHandlerServer.updateNewKing(newKing.func_70005_c_(), null, true);
                Hats.eventHandlerServer.updateNewKing(newKing.func_70005_c_(), newKing, true);
                FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148539_a((ITextComponent)new TextComponentTranslation("hats.kingOfTheHat.update.playerLeft", new Object[]{event.player.func_70005_c_(), newKing.func_70005_c_()}));
            }
        }
        if ((info = Hats.eventHandlerServer.playerActivity.get(event.player.func_70005_c_())) != null) {
            NBTTagCompound persistentTag = event.player.getEntityData().func_74775_l("PlayerPersisted");
            persistentTag.func_74768_a("Hats_activityLevels", info.levels);
            persistentTag.func_74768_a("Hats_activityTimeleft", info.timeLeft);
            event.player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persistentTag);
            info.active = false;
        }
        Hats.proxy.playerWornHats.remove(event.player.func_70005_c_());
    }
}

