/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.packet;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.core.HatInfo;
import me.ichun.mods.hats.common.entity.EntityHat;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketMobHatsList
extends AbstractPacket {
    public ArrayList<Integer> mobIds = new ArrayList();
    public ArrayList<String> hatNames = new ArrayList();

    public PacketMobHatsList() {
    }

    public PacketMobHatsList(ArrayList<Integer> ids, ArrayList<String> names) {
        this.mobIds = ids;
        this.hatNames = names;
    }

    public void writeTo(ByteBuf buffer) {
        try {
            for (int i = 0; i < this.mobIds.size(); ++i) {
                buffer.writeInt(this.mobIds.get(i).intValue());
                if (this.mobIds.get(i) == -2) continue;
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.hatNames.get(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        buffer.writeInt(-2);
    }

    public void readFrom(ByteBuf buffer) {
        int id = buffer.readInt();
        while (id != -2) {
            this.mobIds.add(id);
            this.hatNames.add(ByteBufUtils.readUTF8String((ByteBuf)buffer));
            id = buffer.readInt();
        }
    }

    public AbstractPacket execute(Side side, EntityPlayer player) {
        this.handleClient(side, player);
        return null;
    }

    public Side receivingSide() {
        return Side.CLIENT;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient(Side side, EntityPlayer player) {
        for (int i = 0; i < Math.min(this.mobIds.size(), this.hatNames.size()); ++i) {
            Entity ent = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.mobIds.get(i).intValue());
            if (ent == null || !(ent instanceof EntityLivingBase)) continue;
            HatInfo hatInfo = new HatInfo(this.hatNames.get(i));
            EntityHat hat = new EntityHat(ent.field_70170_p, (EntityLivingBase)ent, hatInfo);
            Hats.eventHandlerClient.mobHats.put(ent.func_145782_y(), hat);
            ent.field_70170_p.func_72838_d((Entity)hat);
        }
    }
}

