/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.packet;

import io.netty.buffer.ByteBuf;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.core.HatHandler;
import me.ichun.mods.hats.common.core.HatInfo;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class PacketPlayerHatSelection
extends AbstractPacket {
    public String hatName;
    public int r;
    public int g;
    public int b;
    public int a;

    public PacketPlayerHatSelection() {
    }

    public PacketPlayerHatSelection(String name, int R, int G, int B, int A) {
        this.hatName = name;
        this.r = R;
        this.g = G;
        this.b = B;
        this.a = A;
    }

    public void writeTo(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.hatName);
        buffer.writeInt(this.r);
        buffer.writeInt(this.g);
        buffer.writeInt(this.b);
        buffer.writeInt(this.a);
    }

    public void readFrom(ByteBuf buffer) {
        this.hatName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.r = buffer.readInt();
        this.g = buffer.readInt();
        this.b = buffer.readInt();
        this.a = buffer.readInt();
    }

    public AbstractPacket execute(Side side, EntityPlayer player) {
        Hats.proxy.playerWornHats.put(player.func_70005_c_(), new HatInfo(this.hatName, this.r, this.g, this.b, this.a));
        if (HatHandler.hasHat(this.hatName)) {
            NBTTagCompound persistentTag = player.getEntityData().func_74775_l("PlayerPersisted");
            persistentTag.func_74778_a("Hats_wornHat", this.hatName);
            persistentTag.func_74768_a("Hats_colourR", this.r);
            persistentTag.func_74768_a("Hats_colourG", this.g);
            persistentTag.func_74768_a("Hats_colourB", this.b);
            persistentTag.func_74768_a("Hats_alpha", this.a);
            player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persistentTag);
            Hats.proxy.sendPlayerListOfWornHats(player, false);
        } else {
            HatHandler.requestHat(this.hatName, player);
        }
        return null;
    }

    public Side receivingSide() {
        return Side.SERVER;
    }
}

