/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import java.util.List;
import lumien.randomthings.block.BlockItemCollector;
import lumien.randomthings.config.Numbers;
import lumien.randomthings.item.ItemItemFilter;
import lumien.randomthings.tileentity.TileEntityBase;
import lumien.randomthings.util.InventoryUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityAdvancedItemCollector
extends TileEntityBase
implements ITickable,
IInventoryChangedListener {
    int currentTickRate = 20;
    int counter = 0;
    int rangeX = 5;
    int rangeY = 5;
    int rangeZ = 5;
    InventoryBasic filterInventory = new InventoryBasic("tile.advancedItemCollector", false, 1){

        public int func_70297_j_() {
            return 1;
        }
    };
    ItemItemFilter.ItemFilterRepresentation filterRepres;

    public TileEntityAdvancedItemCollector() {
        this.filterInventory.func_110134_a((IInventoryChangedListener)this);
    }

    public IInventory getInventory() {
        return this.filterInventory;
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        compound.func_74768_a("rangeX", this.rangeX);
        compound.func_74768_a("rangeY", this.rangeY);
        compound.func_74768_a("rangeZ", this.rangeZ);
        NBTTagCompound inventoryCompound = new NBTTagCompound();
        InventoryUtil.writeInventoryToCompound(inventoryCompound, (IInventory)this.filterInventory);
        compound.func_74782_a("inventory", (NBTBase)inventoryCompound);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        this.rangeX = compound.func_74762_e("rangeX");
        this.rangeY = compound.func_74762_e("rangeY");
        this.rangeZ = compound.func_74762_e("rangeZ");
        NBTTagCompound inventoryCompound = compound.func_74775_l("inventory");
        if (inventoryCompound != null) {
            InventoryUtil.readInventoryFromCompound(inventoryCompound, (IInventory)this.filterInventory);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.counter;
            if (this.counter >= this.currentTickRate) {
                EnumFacing facing;
                TileEntity te;
                this.counter = 0;
                List entityItemList = this.field_145850_b.func_175647_a(EntityItem.class, new AxisAlignedBB(this.field_174879_c.func_177982_a(-this.rangeX, -this.rangeY, -this.rangeZ), this.field_174879_c.func_177982_a(this.rangeX + 1, this.rangeY + 1, this.rangeZ + 1)), EntitySelectors.field_94557_a);
                boolean didSomething = false;
                if (!entityItemList.isEmpty() && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a((facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockItemCollector.FACING)).func_176734_d()))) != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
                    IItemHandler itemHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
                    for (EntityItem ei : entityItemList) {
                        if (ei.field_70128_L || this.filterRepres != null && !this.filterRepres.matchesItemStack(ei.func_92059_d())) continue;
                        ItemStack original = ei.func_92059_d().func_77946_l();
                        ItemStack left = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)original, (boolean)false);
                        if (left == null || left.field_77994_a < original.field_77994_a) {
                            didSomething = true;
                        }
                        if (left == null || left.field_77994_a == 0) {
                            ei.func_70106_y();
                            continue;
                        }
                        ei.func_92058_a(left);
                    }
                }
                if (!didSomething) {
                    if (this.currentTickRate < 20) {
                        ++this.currentTickRate;
                    }
                } else if (this.currentTickRate > 1) {
                    --this.currentTickRate;
                }
            }
        }
    }

    public int getRangeX() {
        return this.rangeX;
    }

    public void setRangeX(int rangeX) {
        this.rangeX = rangeX;
        if (this.rangeX < 0) {
            this.rangeX = 0;
        } else if (this.rangeX > Numbers.ADVANCED_ITEM_COLLECTOR_MAX_RANGE) {
            this.rangeX = Numbers.ADVANCED_ITEM_COLLECTOR_MAX_RANGE;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public int getRangeY() {
        return this.rangeY;
    }

    public void setRangeY(int rangeY) {
        this.rangeY = rangeY;
        if (this.rangeY < 0) {
            this.rangeY = 0;
        } else if (this.rangeY > Numbers.ADVANCED_ITEM_COLLECTOR_MAX_RANGE) {
            this.rangeY = Numbers.ADVANCED_ITEM_COLLECTOR_MAX_RANGE;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public int getRangeZ() {
        return this.rangeZ;
    }

    public void setRangeZ(int rangeZ) {
        this.rangeZ = rangeZ;
        if (this.rangeZ < 0) {
            this.rangeZ = 0;
        } else if (this.rangeZ > Numbers.ADVANCED_ITEM_COLLECTOR_MAX_RANGE) {
            this.rangeZ = Numbers.ADVANCED_ITEM_COLLECTOR_MAX_RANGE;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public void func_76316_a(InventoryBasic p_76316_1_) {
        ItemStack filterStack = p_76316_1_.func_70301_a(0);
        this.filterRepres = filterStack == null ? null : ItemItemFilter.ItemFilterRepresentation.readFromItemStack(filterStack);
    }
}

