/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.gui;

import com.feed_the_beast.ftbl.api.EnumTeamColor;
import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.MouseButton;
import com.feed_the_beast.ftbl.lib.client.CachedVertexData;
import com.feed_the_beast.ftbl.lib.client.FTBLibClient;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiIcons;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiChunkSelectorBase;
import com.feed_the_beast.ftbl.lib.gui.misc.ThreadReloadChunkSelector;
import com.feed_the_beast.ftbu.FTBUCommon;
import com.feed_the_beast.ftbu.api.FTBULang;
import com.feed_the_beast.ftbu.api.chunks.IChunkUpgrade;
import com.feed_the_beast.ftbu.api_impl.ChunkUpgrade;
import com.feed_the_beast.ftbu.client.FTBUClient;
import com.feed_the_beast.ftbu.gui.ClaimedChunks;
import com.feed_the_beast.ftbu.net.MessageClaimedChunksModify;
import com.feed_the_beast.ftbu.net.MessageClaimedChunksRequest;
import com.feed_the_beast.ftbu.net.MessageClaimedChunksUpdate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class GuiClaimedChunks
extends GuiChunkSelectorBase {
    public static GuiClaimedChunks instance;
    private static final Map<UUID, ClaimedChunks.Team> TEAMS;
    private static final ClaimedChunks.Data[] chunkData;
    private static int claimedChunks;
    private static int loadedChunks;
    private static int maxClaimedChunks;
    private static int maxLoadedChunks;
    private static final ClaimedChunks.Data NULL_CHUNK_DATA;
    private static final CachedVertexData AREA;
    private final String currentDimName;
    private final Button buttonRefresh;
    private final Button buttonClose;
    private final Button buttonUnclaimAll;

    private static ClaimedChunks.Data getAt(int x, int y) {
        int i = x + y * 15;
        return i < 0 || i >= chunkData.length ? NULL_CHUNK_DATA : chunkData[i];
    }

    private static boolean hasBorder(ClaimedChunks.Data data, ClaimedChunks.Data with) {
        return (data.flags != with.flags || data.team != with.team) && !with.hasUpgrade(ChunkUpgrade.LOADED);
    }

    public static void setData(MessageClaimedChunksUpdate m) {
        claimedChunks = m.claimedChunks;
        loadedChunks = m.loadedChunks;
        maxClaimedChunks = m.maxClaimedChunks;
        maxLoadedChunks = m.maxLoadedChunks;
        System.arraycopy(m.chunkData, 0, chunkData, 0, chunkData.length);
        TEAMS.putAll(m.teams);
        if (FTBUClient.JM_INTEGRATION != null) {
            for (int z = 0; z < 15; ++z) {
                for (int x = 0; x < 15; ++x) {
                    FTBUClient.JM_INTEGRATION.chunkChanged(new ChunkPos(m.startX + x, m.startZ + z), m.chunkData[x + z * 15]);
                }
            }
        }
        AREA.reset();
        EnumTeamColor prevCol = null;
        for (int i = 0; i < chunkData.length; ++i) {
            ClaimedChunks.Data data = chunkData[i];
            if (!data.hasUpgrade(ChunkUpgrade.CLAIMED)) continue;
            if (prevCol != data.team.color) {
                prevCol = data.team.color;
                GuiClaimedChunks.AREA.color.set(data.team.color.getColor(), 150);
            }
            AREA.rect(i % 15 * 16, i / 15 * 16, 16, 16);
        }
        for (int i = 0; i < chunkData.length; ++i) {
            boolean borderR;
            ClaimedChunks.Data data = chunkData[i];
            if (!data.hasUpgrade(ChunkUpgrade.CLAIMED)) continue;
            int x = i % 15;
            int dx = x * 16;
            int y = i / 15;
            int dy = y * 16;
            boolean borderU = y > 0 && GuiClaimedChunks.hasBorder(data, GuiClaimedChunks.getAt(x, y - 1));
            boolean borderD = y < 14 && GuiClaimedChunks.hasBorder(data, GuiClaimedChunks.getAt(x, y + 1));
            boolean borderL = x > 0 && GuiClaimedChunks.hasBorder(data, GuiClaimedChunks.getAt(x - 1, y));
            boolean bl = borderR = x < 14 && GuiClaimedChunks.hasBorder(data, GuiClaimedChunks.getAt(x + 1, y));
            if (data.hasUpgrade(ChunkUpgrade.LOADED)) {
                GuiClaimedChunks.AREA.color.set(255, 80, 80, 230);
            } else {
                GuiClaimedChunks.AREA.color.set(80, 80, 80, 230);
            }
            if (borderU) {
                AREA.rect(dx, dy, 16, 1);
            }
            if (borderD) {
                AREA.rect(dx, dy + 15, 16, 1);
            }
            if (borderL) {
                AREA.rect(dx, dy, 1, 16);
            }
            if (!borderR) continue;
            AREA.rect(dx + 15, dy, 1, 16);
        }
    }

    public GuiClaimedChunks() {
        this.currentDimName = this.mc.field_71441_e.field_73011_w.func_186058_p().func_186065_b();
        this.buttonClose = new Button(0, 0, 16, 16, GuiLang.BUTTON_CLOSE.translate()){

            public void onClicked(GuiBase gui, IMouseButton button) {
                GuiHelper.playClickSound();
                gui.closeGui();
            }
        };
        this.buttonClose.setIcon((IDrawableObject)GuiIcons.ACCEPT);
        this.buttonRefresh = new Button(0, 16, 16, 16, GuiLang.BUTTON_REFRESH.translate()){

            public void onClicked(GuiBase gui, IMouseButton button) {
                new MessageClaimedChunksRequest(GuiClaimedChunks.this.startX, GuiClaimedChunks.this.startZ).sendToServer();
                ThreadReloadChunkSelector.reloadArea((World)GuiClaimedChunks.this.mc.field_71441_e, (int)GuiClaimedChunks.this.startX, (int)GuiClaimedChunks.this.startZ);
            }
        };
        this.buttonRefresh.setIcon((IDrawableObject)GuiIcons.REFRESH);
        this.buttonUnclaimAll = new Button(0, 32, 16, 16){

            public void onClicked(GuiBase gui, IMouseButton button) {
                GuiHelper.playClickSound();
                String s = GuiScreen.func_146272_n() ? FTBULang.BUTTON_CLAIMS_UNCLAIM_ALL_Q.translate() : FTBULang.BUTTON_CLAIMS_UNCLAIM_ALL_DIM_Q.translate(new Object[]{GuiClaimedChunks.this.currentDimName});
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiYesNo((set, id) -> {
                    if (set) {
                        FTBLibClient.execClientCommand((String)("/ftb chunks unclaim_all " + (id == 1)));
                    }
                    gui.openGui();
                    gui.refreshWidgets();
                }, s, "", GuiScreen.func_146272_n() ? 1 : 0));
            }

            public void addMouseOverText(GuiBase gui, List<String> list) {
                list.add(GuiScreen.func_146272_n() ? FTBULang.BUTTON_CLAIMS_UNCLAIM_ALL.translate() : FTBULang.BUTTON_CLAIMS_UNCLAIM_ALL_DIM.translate(new Object[]{GuiClaimedChunks.this.currentDimName}));
            }
        };
        this.buttonUnclaimAll.setIcon((IDrawableObject)GuiIcons.REMOVE);
    }

    public void onInit() {
        this.buttonRefresh.onClicked((GuiBase)this, (IMouseButton)MouseButton.LEFT);
    }

    public int getSelectionMode(IMouseButton button) {
        boolean claim = !GuiScreen.func_146272_n();
        boolean flag = button.isLeft();
        if (flag) {
            return claim ? 0 : 2;
        }
        return claim ? 1 : 3;
    }

    public void onChunksSelected(Collection<ChunkPos> chunks) {
        new MessageClaimedChunksModify(this.startX, this.startZ, this.currentSelectionMode, chunks).sendToServer();
    }

    public void drawArea(Tessellator tessellator, VertexBuffer buffer) {
        AREA.draw(tessellator, buffer);
    }

    public void addCornerButtons(Panel panel) {
        panel.add((Widget)this.buttonClose);
        panel.add((Widget)this.buttonRefresh);
        panel.add((Widget)this.buttonUnclaimAll);
    }

    public void addCornerText(List<String> list) {
        list.add(FTBULang.LABEL_CCHUNKS_COUNT.translate(new Object[]{claimedChunks, maxClaimedChunks}));
        list.add(FTBULang.LABEL_LCHUNKS_COUNT.translate(new Object[]{loadedChunks, maxLoadedChunks}));
    }

    public void addButtonText(GuiChunkSelectorBase.MapButton button, List<String> list) {
        ClaimedChunks.Data data = chunkData[button.index];
        if (data.hasUpgrade(ChunkUpgrade.CLAIMED)) {
            list.add(data.team.formattedName);
            list.add(TextFormatting.GREEN + ChunkUpgrade.CLAIMED.getLangKey().translate());
            if (data.team.isAlly) {
                list.add(data.owner);
                for (IChunkUpgrade upgrade : FTBUCommon.CHUNK_UPGRADES) {
                    if (upgrade == null || !data.hasUpgrade(upgrade)) continue;
                    list.add(TextFormatting.RED + upgrade.getLangKey().translate());
                }
            }
        } else {
            list.add(TextFormatting.DARK_GREEN + ChunkUpgrade.WILDERNESS.getLangKey().translate());
        }
        if (GuiScreen.func_146271_m()) {
            list.add(button.chunkPos.toString());
        }
    }

    static {
        TEAMS = new HashMap<UUID, ClaimedChunks.Team>();
        chunkData = new ClaimedChunks.Data[225];
        NULL_CHUNK_DATA = new ClaimedChunks.Data();
        AREA = new CachedVertexData(7, DefaultVertexFormats.field_181706_f);
        GuiClaimedChunks.NULL_CHUNK_DATA.owner = "";
        for (int i = 0; i < chunkData.length; ++i) {
            GuiClaimedChunks.chunkData[i] = new ClaimedChunks.Data();
        }
    }
}

