/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.world;

import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.api.events.player.ForgePlayerSettingsEvent;
import com.feed_the_beast.ftbl.lib.config.PropertyBool;
import com.feed_the_beast.ftbl.lib.math.BlockDimPos;
import com.feed_the_beast.ftbl.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbu.FTBLibIntegration;
import com.feed_the_beast.ftbu.FTBUCommon;
import com.feed_the_beast.ftbu.api.chunks.IChunkUpgrade;
import com.feed_the_beast.ftbu.api.chunks.IClaimedChunk;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunk;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunkStorage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;

public class FTBUPlayerData
implements INBTSerializable<NBTBase> {
    public final PropertyBool renderBadge = new PropertyBool(true);
    public final PropertyBool chatLinks = new PropertyBool(true);
    public final PropertyBool disableGlobalBadge = new PropertyBool(false);
    public final IForgePlayer player;
    public BlockDimPos lastDeath;
    public BlockDimPos lastSafePos;
    public IForgePlayer lastChunkOwner;
    private Map<String, BlockDimPos> homes;

    public FTBUPlayerData(IForgePlayer p) {
        this.player = p;
    }

    @Nullable
    public static FTBUPlayerData get(IForgePlayer p) {
        return (FTBUPlayerData)p.getData(FTBLibIntegration.FTBU_DATA);
    }

    public NBTBase serializeNBT() {
        Collection<IClaimedChunk> claimedChunks;
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("RenderBadge", this.renderBadge.getBoolean());
        nbt.func_74757_a("ChatLinks", this.chatLinks.getBoolean());
        nbt.func_74757_a("DisableGlobalBadges", this.disableGlobalBadge.getBoolean());
        if (this.homes != null && !this.homes.isEmpty()) {
            NBTTagCompound tag1 = new NBTTagCompound();
            for (Map.Entry<String, BlockDimPos> e : this.homes.entrySet()) {
                tag1.func_74783_a(e.getKey(), e.getValue().toIntArray());
            }
            nbt.func_74782_a("Homes", (NBTBase)tag1);
        }
        if (this.lastDeath != null) {
            nbt.func_74783_a("LastDeath", this.lastDeath.toIntArray());
        }
        if (!(claimedChunks = ClaimedChunkStorage.INSTANCE.getChunks(this.player)).isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (IClaimedChunk chunk : claimedChunks) {
                ChunkDimPos pos = chunk.getPos();
                int flags = 0;
                for (IChunkUpgrade upgrade : FTBUCommon.CHUNK_UPGRADES) {
                    if (upgrade == null || !chunk.hasUpgrade(upgrade)) continue;
                    flags |= 1 << upgrade.getId();
                }
                int[] ai = flags != 0 ? new int[4] : new int[3];
                ai[0] = pos.dim;
                ai[1] = pos.posX;
                ai[2] = pos.posZ;
                if (flags != 0) {
                    ai[3] = flags;
                }
                list.func_74742_a((NBTBase)new NBTTagIntArray(ai));
            }
            nbt.func_74782_a("ClaimedChunks", (NBTBase)list);
        }
        return nbt;
    }

    public void deserializeNBT(NBTBase nbt0) {
        NBTTagCompound nbt = (NBTTagCompound)nbt0;
        if (nbt.func_74764_b("Homes")) {
            this.homes = new HashMap<String, BlockDimPos>();
            NBTTagCompound tag1 = (NBTTagCompound)nbt.func_74781_a("Homes");
            if (tag1 != null && !tag1.func_82582_d()) {
                for (String s1 : tag1.func_150296_c()) {
                    this.setHome(s1.toLowerCase(), new BlockDimPos(tag1.func_74759_k(s1)));
                }
            }
        } else {
            this.homes = null;
        }
        this.lastDeath = null;
        if (nbt.func_74764_b("LastDeath")) {
            int[] ai = nbt.func_74759_k("LastDeath");
            BlockDimPos blockDimPos = this.lastDeath = ai.length == 4 ? new BlockDimPos(ai) : null;
        }
        if (nbt.func_74764_b("ClaimedChunks")) {
            NBTTagList list = (NBTTagList)nbt.func_74781_a("ClaimedChunks");
            for (int i = 0; i < list.func_74745_c(); ++i) {
                int[] ai = list.func_150306_c(i);
                if (ai.length < 3) continue;
                ClaimedChunk chunk = new ClaimedChunk(new ChunkDimPos(ai[1], ai[2], ai[0]), this.player, ai.length >= 4 ? ai[3] : 0);
                ClaimedChunkStorage.INSTANCE.setChunk(chunk.getPos(), chunk);
            }
        }
    }

    public Collection<String> listHomes() {
        if (this.homes == null || this.homes.isEmpty()) {
            return Collections.emptySet();
        }
        return this.homes.keySet();
    }

    @Nullable
    public BlockDimPos getHome(String s) {
        return this.homes == null ? null : this.homes.get(s.toLowerCase());
    }

    public boolean setHome(String s, @Nullable BlockDimPos pos) {
        if (pos == null) {
            return this.homes != null && this.homes.remove(s) != null;
        }
        if (this.homes == null) {
            this.homes = new HashMap<String, BlockDimPos>();
        }
        return this.homes.put(s, pos.copy()) == null;
    }

    public int homesSize() {
        return this.homes == null ? 0 : this.homes.size();
    }

    public void addConfig(ForgePlayerSettingsEvent event) {
        String group = "ftbu";
        event.add(group, "render_badge", (IConfigValue)this.renderBadge);
        event.add(group, "chat_links", (IConfigValue)this.chatLinks);
        event.add(group, "disable_global_badge", (IConfigValue)this.disableGlobalBadge);
    }
}

