/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.client;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import sonar.core.helpers.RenderHelper;

public enum BlockModelsCache implements IResourceManagerReloadListener
{
    INSTANCE;

    public static final IModelState DEFAULTMODELSTATE;
    public static final VertexFormat DEFAULTVERTEXFORMAT;
    public static final Function<ResourceLocation, TextureAtlasSprite> DEFAULTTEXTUREGETTER;
    private final Map<ResourceLocation, IModel> cache = new HashMap<ResourceLocation, IModel>();
    private final Map<ResourceLocation, IBakedModel> bakedCache = new HashMap<ResourceLocation, IBakedModel>();

    public IModel getOrLoadModel(ResourceLocation location) {
        IModel model = this.cache.get(location);
        if (model == null) {
            try {
                model = ModelLoaderRegistry.getModel((ResourceLocation)location);
            }
            catch (Exception e) {
                e.printStackTrace();
                model = ModelLoaderRegistry.getMissingModel();
            }
            this.cache.put(location, model);
        }
        return model;
    }

    public IBakedModel getModel(ResourceLocation key) {
        return this.bakedCache.get(key);
    }

    public IBakedModel getOrLoadModel(ResourceLocation key, ResourceLocation location, IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        IBakedModel model = this.getModel(key);
        if (model == null) {
            model = this.getOrLoadModel(location).bake(state, format, textureGetter);
            this.bakedCache.put(key, model);
        }
        return model;
    }

    public IBakedModel getOrLoadModel(ItemStack stack) {
        ResourceLocation location = stack.func_77973_b().getRegistryName();
        String hashCode = stack.func_77942_o() ? "" + stack.func_77978_p().hashCode() : "";
        ResourceLocation key = new ResourceLocation(location.toString() + stack.func_77960_j() + hashCode);
        IBakedModel model = this.getModel(key);
        if (model == null) {
            model = RenderHelper.itemRender.func_184393_a(stack, null, null);
            this.bakedCache.put(key, model);
        }
        return model;
    }

    public IBakedModel getOrLoadModel(ResourceLocation key, ResourceLocation location, IModelState state, VertexFormat format) {
        return this.getOrLoadModel(key, location, state, format, DEFAULTTEXTUREGETTER);
    }

    public IBakedModel getOrLoadModel(ResourceLocation key, ResourceLocation location, IModelState state, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        return this.getOrLoadModel(key, location, state, DEFAULTVERTEXFORMAT, textureGetter);
    }

    public IBakedModel getOrLoadModel(ResourceLocation key, ResourceLocation location, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        return this.getOrLoadModel(key, location, DEFAULTMODELSTATE, format, textureGetter);
    }

    public IBakedModel getOrLoadModel(ResourceLocation key, ResourceLocation location, IModelState state) {
        return this.getOrLoadModel(key, location, state, DEFAULTVERTEXFORMAT, DEFAULTTEXTUREGETTER);
    }

    public IBakedModel getOrLoadModel(ResourceLocation key, ResourceLocation location, VertexFormat format) {
        return this.getOrLoadModel(key, location, DEFAULTMODELSTATE, format, DEFAULTTEXTUREGETTER);
    }

    public IBakedModel getOrLoadModel(ResourceLocation key, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        return this.getOrLoadModel(key, location, DEFAULTMODELSTATE, DEFAULTVERTEXFORMAT, textureGetter);
    }

    public IBakedModel getOrLoadModel(ResourceLocation key, ResourceLocation location) {
        return this.getOrLoadModel(key, location, DEFAULTMODELSTATE, DEFAULTVERTEXFORMAT, DEFAULTTEXTUREGETTER);
    }

    public IBakedModel getOrLoadBakedModel(ResourceLocation location) {
        return this.getOrLoadModel(location, location, DEFAULTMODELSTATE, DEFAULTVERTEXFORMAT, DEFAULTTEXTUREGETTER);
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.cache.clear();
        this.bakedCache.clear();
    }

    static {
        DEFAULTMODELSTATE = opt -> Optional.absent();
        DEFAULTVERTEXFORMAT = DefaultVertexFormats.field_176600_a;
        DEFAULTTEXTUREGETTER = texture -> Minecraft.func_71410_x().func_147117_R().func_110572_b(texture.toString());
    }
}

