/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.item;

import cofh.api.energy.IEnergyContainerItem;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.api.energy.ISonarEnergyItem;
import sonar.core.api.utils.ActionType;
import sonar.core.common.item.SonarItem;
import sonar.core.helpers.FontHelper;
import sonar.core.network.sync.SyncItemEnergyStorage;

public class SonarEnergyItem
extends SonarItem
implements ISonarEnergyItem,
IEnergyContainerItem {
    public SyncItemEnergyStorage storage;
    public int capacity;
    public int maxReceive;
    public int maxExtract;

    public SonarEnergyItem(int capacity, int maxReceive, int maxExtract) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.storage = new SyncItemEnergyStorage(null, capacity, maxReceive, maxExtract);
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        if (stack != null) {
            list.add(FontHelper.translate("energy.stored") + ": " + this.getEnergyLevel(stack) + " RF");
        }
    }

    @Override
    public long addEnergy(ItemStack stack, long maxReceive, ActionType action) {
        this.storage.setItemStack(stack);
        return this.storage.addEnergy(maxReceive, action);
    }

    @Override
    public long removeEnergy(ItemStack stack, long maxExtract, ActionType action) {
        this.storage.setItemStack(stack);
        return this.storage.removeEnergy(maxExtract, action);
    }

    @Override
    public long getEnergyLevel(ItemStack stack) {
        this.storage.setItemStack(stack);
        return this.storage.getEnergyLevel();
    }

    @Override
    public long getFullCapacity(ItemStack stack) {
        this.storage.setItemStack(stack);
        return this.storage.getFullCapacity();
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        this.storage.setItemStack(container);
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        this.storage.setItemStack(container);
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        this.storage.setItemStack(container);
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        this.storage.setItemStack(container);
        return this.storage.getMaxEnergyStored();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        this.storage = new SyncItemEnergyStorage(null, this.capacity, this.maxReceive, this.maxExtract);
        return this.storage;
    }
}

