/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.energy;

import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.tile.IEnergyStorage;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import sonar.core.api.asm.EnergyHandler;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.energy.ISonarEnergyHandler;
import sonar.core.api.energy.StoredEnergyStack;
import sonar.core.api.utils.ActionType;
import sonar.core.integration.EUHelper;

@EnergyHandler(modid="IC2", priority=4)
public class EUHandler
implements ISonarEnergyHandler {
    @Override
    public boolean canProvideEnergy(TileEntity tile, EnumFacing dir) {
        return tile instanceof IEnergySink || tile instanceof IEnergySource || tile instanceof IEnergyStorage;
    }

    @Override
    public StoredEnergyStack getEnergy(StoredEnergyStack energyStack, TileEntity tile, EnumFacing dir) {
        if (tile instanceof IEnergyStorage) {
            IEnergyStorage storage = (IEnergyStorage)tile;
            energyStack.setStorageValues(storage.getStored() * 4, storage.getCapacity() * 4);
            energyStack.setMaxOutput((long)(storage.getOutputEnergyUnitsPerTick() * 4.0));
        }
        if (tile instanceof IEnergySink) {
            IEnergySink sink = (IEnergySink)tile;
            energyStack.setMaxInput((long)(sink.getDemandedEnergy() * 4.0));
        }
        if (tile instanceof IEnergySource) {
            IEnergySource source = (IEnergySource)tile;
            energyStack.setMaxOutput((long)(source.getOfferedEnergy() * 4.0));
        }
        return energyStack;
    }

    @Override
    public StoredEnergyStack addEnergy(StoredEnergyStack transfer, TileEntity tile, EnumFacing dir, ActionType action) {
        if (tile instanceof IEnergyStorage) {
            IEnergyStorage sink = (IEnergyStorage)tile;
            int before = sink.getStored();
            transfer.stored = !action.shouldSimulate() ? (transfer.stored -= (long)sink.addEnergy((int)Math.min((long)(sink.getCapacity() - before), transfer.stored))) : (transfer.stored -= Math.min((long)(sink.getCapacity() - before), transfer.stored));
        } else if (tile instanceof IEnergySink) {
            IEnergySink sink = (IEnergySink)tile;
            if (!action.shouldSimulate()) {
                int maxAdd = (int)transfer.stored;
                transfer.stored = (long)((double)transfer.stored - ((double)maxAdd - sink.injectEnergy(dir, maxAdd, EUHelper.getVoltage(sink.getSinkTier()))));
            } else {
                transfer.stored = (long)((double)transfer.stored - Math.min(sink.getDemandedEnergy(), EUHelper.getVoltage(sink.getSinkTier())));
            }
        }
        if (transfer.stored == 0L) {
            transfer = null;
        }
        return transfer;
    }

    @Override
    public StoredEnergyStack removeEnergy(StoredEnergyStack transfer, TileEntity tile, EnumFacing dir, ActionType action) {
        if (tile instanceof IEnergyStorage) {
            IEnergyStorage sink = (IEnergyStorage)tile;
            int before = sink.getStored();
            transfer.stored = !action.shouldSimulate() ? (transfer.stored -= (long)sink.addEnergy(-((int)Math.min((long)before, transfer.stored)))) : (transfer.stored -= Math.min((long)before, transfer.stored));
        } else if (tile instanceof IEnergySource) {
            IEnergySource source = (IEnergySource)tile;
            double amount = Math.min(EUHelper.getVoltage(source.getSourceTier()), Math.min((double)transfer.stored, source.getOfferedEnergy()));
            if (!action.shouldSimulate()) {
                source.drawEnergy(amount);
                transfer.stored = (long)((double)transfer.stored - amount);
            } else {
                transfer.stored = (long)((double)transfer.stored - amount);
            }
        }
        if (transfer.stored == 0L) {
            transfer = null;
        }
        return transfer;
    }

    @Override
    public EnergyType getProvidedType() {
        return EnergyType.EU;
    }
}

