/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import sonar.core.SonarCore;
import sonar.core.api.nbt.IBufObject;
import sonar.core.api.nbt.INBTObject;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTRegistryHelper;
import sonar.core.helpers.RegistryHelper;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.SyncableList;

public class NBTHelper {
    public static void readSyncParts(NBTTagCompound nbt, SyncType type, List<ISyncPart> syncableList) {
        for (ISyncPart part : syncableList) {
            if (part == null || !part.canSync(type)) continue;
            part.readData(nbt, type);
        }
    }

    public static void readSyncParts(NBTTagCompound nbt, SyncType type, SyncableList syncableList) {
        for (ISyncPart part : syncableList.getStandardSyncParts()) {
            if (part == null || !part.canSync(type)) continue;
            part.readData(nbt, type);
        }
    }

    public static NBTTagCompound writeSyncParts(NBTTagCompound nbt, SyncType type, List<ISyncPart> syncableList, boolean forceSync) {
        for (ISyncPart part : syncableList) {
            if (part == null || !forceSync && !type.mustSync() && !part.canSync(type)) continue;
            part.writeData(nbt, type);
        }
        return nbt;
    }

    public static NBTTagCompound writeSyncParts(NBTTagCompound nbt, SyncType type, SyncableList syncableList, boolean forceSync) {
        for (ISyncPart part : (ArrayList)syncableList.getSyncList(type).clone()) {
            if (part == null || !forceSync && !type.mustSync() && !part.canSync(type)) continue;
            part.writeData(nbt, type);
            syncableList.onPartSynced(part);
        }
        syncableList.onPartsSynced();
        return nbt;
    }

    public static ISyncPart getSyncPartByID(ArrayList<ISyncPart> parts, int id) {
        String tag = "" + id;
        for (ISyncPart part : parts) {
            if (part == null || !part.getTagName().equals(tag)) continue;
            return part;
        }
        return null;
    }

    @Nullable
    public static <T extends INBTSyncable> T instanceNBTSyncable(Class<T> classType, NBTTagCompound tag) {
        try {
            INBTSyncable obj = (INBTSyncable)classType.newInstance();
            obj.readData(tag, SyncType.SAVE);
            return (T)obj;
        }
        catch (IllegalAccessException | InstantiationException e) {
            SonarCore.logger.error("FAILED TO CREATE NEW INSTANCE OF " + classType.getSimpleName());
            return null;
        }
    }

    public static void readSyncedNBTObjectList(String tagName, NBTTagCompound tag, NBTRegistryHelper<? extends INBTObject> helper, List objectList) {
        if (tag.func_74764_b(tagName + "null")) {
            objectList = Collections.EMPTY_LIST;
            return;
        }
        if (tag.func_74764_b(tagName)) {
            NBTTagList list = tag.func_150295_c(tagName, 10);
            if (objectList == null) {
                objectList = Lists.newArrayList();
            }
            block5: for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                int slot = compound.func_74762_e("Slot");
                boolean set = slot < objectList.size();
                switch (compound.func_74771_c("f")) {
                    case 0: {
                        if (set) {
                            objectList.set(slot, helper.readFromNBT(compound));
                            continue block5;
                        }
                        objectList.add(slot, helper.readFromNBT(compound));
                        continue block5;
                    }
                    case 1: {
                        long stored = compound.func_74763_f("Stored");
                        if (stored != 0L) {
                            objectList.set(slot, helper.readFromNBT(compound));
                            continue block5;
                        }
                        objectList.set(slot, null);
                        continue block5;
                    }
                    case 2: {
                        objectList.set(slot, null);
                    }
                }
            }
        }
    }

    public static NBTTagCompound writeSyncedNBTObjectList(String tagName, NBTTagCompound tag, NBTRegistryHelper helper, List objectList, List lastList) {
        if (objectList == null) {
            objectList = Lists.newArrayList();
        }
        if (lastList == null) {
            lastList = Lists.newArrayList();
        }
        NBTTagList list = new NBTTagList();
        int size = Math.max(objectList.size(), lastList.size());
        for (int i = 0; i < size; ++i) {
            INBTObject current = null;
            INBTObject last = null;
            if (i < objectList.size()) {
                current = (INBTObject)objectList.get(i);
            }
            if (i < lastList.size()) {
                last = (INBTObject)lastList.get(i);
            }
            NBTTagCompound compound = new NBTTagCompound();
            if (current != null) {
                if (last != null) {
                    if (!helper.areTypesEqual(current, last)) {
                        compound.func_74774_a("f", (byte)0);
                        lastList.set(i, current);
                        helper.writeToNBT(compound, (INBTObject)objectList.get(i));
                    }
                } else {
                    compound.func_74774_a("f", (byte)0);
                    lastList.add(i, current);
                    helper.writeToNBT(compound, (INBTObject)objectList.get(i));
                }
            } else if (last != null) {
                lastList.set(i, null);
                compound.func_74774_a("f", (byte)2);
            }
            if (compound.func_82582_d()) continue;
            compound.func_74768_a("Slot", i);
            list.func_74742_a((NBTBase)compound);
        }
        if (list.func_74745_c() != 0) {
            tag.func_74782_a(tagName, (NBTBase)list);
        }
        return tag;
    }

    public static List<? extends INBTObject> readNBTObjectList(String tagName, NBTTagCompound tag, RegistryHelper<? extends INBTObject> helper) {
        ArrayList objects = Lists.newArrayList();
        if (tag.func_74764_b(tagName)) {
            NBTTagList list = tag.func_150295_c(tagName, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                objects.add(NBTHelper.readNBTObject(compound, helper));
            }
        }
        return objects;
    }

    public static NBTTagCompound writeNBTObjectList(String tagName, NBTTagCompound tag, List<? extends INBTObject> objects) {
        if (objects == null || objects.isEmpty() || objects.size() == 0) {
            return tag;
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < objects.size(); ++i) {
            if (objects.get(i) == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            NBTHelper.writeNBTObject(objects.get(i), compound);
            list.func_74742_a((NBTBase)compound);
        }
        tag.func_74782_a(tagName, (NBTBase)list);
        return tag;
    }

    public static INBTObject readNBTObject(NBTTagCompound tag, RegistryHelper<? extends INBTObject> helper) {
        if (tag.func_74764_b("type")) {
            String type = tag.func_74779_i("type");
            if (type.equals("NULLED")) {
                return null;
            }
            if (helper.getRegisteredObject(type) == null) {
                SonarCore.logger.warn("NBT ERROR: Unregistered " + helper.registeryType() + ": " + type + " in " + helper.toString());
                return null;
            }
            INBTObject filter = (INBTObject)helper.getRegisteredObject(type).instance();
            filter.readFromNBT(tag);
            return filter;
        }
        return null;
    }

    public static NBTTagCompound writeNBTObject(INBTObject object, NBTTagCompound tag) {
        if (object != null) {
            tag.func_74778_a("type", object.getName());
            object.writeToNBT(tag);
        } else {
            tag.func_74778_a("type", "NULLED");
        }
        return tag;
    }

    public static IBufObject readBufObject(ByteBuf buf, RegistryHelper<? extends IBufObject> helper) {
        if (buf.readBoolean()) {
            String type = ByteBufUtils.readUTF8String((ByteBuf)buf);
            if (helper.getRegisteredObject(type) == null) {
                SonarCore.logger.warn("BYTE BUF: Unregistered " + helper.registeryType() + ": " + type);
                return null;
            }
            IBufObject info = (IBufObject)helper.getRegisteredObject(type).instance();
            info.readFromBuf(buf);
            return info;
        }
        return null;
    }

    public static void writeBufObject(IBufObject object, ByteBuf buf) {
        if (object != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)object.getName());
            object.writeToBuf(buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    public static void writeFluidToBuf(FluidStack stack, ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)FluidRegistry.getFluidName((Fluid)stack.getFluid()));
        buf.writeInt(stack.amount);
        if (stack.tag != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)stack.tag);
        } else {
            buf.writeBoolean(false);
        }
    }

    public static FluidStack readFluidFromBuf(ByteBuf buf) {
        String fluidName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        if (fluidName == null || FluidRegistry.getFluid((String)fluidName) == null) {
            return null;
        }
        FluidStack stack = new FluidStack(FluidRegistry.getFluid((String)fluidName), buf.readInt());
        if (buf.readBoolean()) {
            stack.tag = ByteBufUtils.readTag((ByteBuf)buf);
        }
        return stack;
    }

    public static void writeTankInfo(FluidTankInfo tank, NBTTagCompound nbt) {
        tank.fluid.writeToNBT(nbt);
        nbt.func_74768_a("capacity", tank.capacity);
    }

    public static FluidTankInfo readTankInfo(NBTTagCompound nbt) {
        return new FluidTankInfo(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt), nbt.func_74762_e("capacity"));
    }

    public void getAndCheck(Object obj, NBTTagCompound tag, String key, boolean shouldCheck) {
        if (!shouldCheck || tag.func_74764_b(key)) {
            obj = NBTHelper.readNBTBase(tag, tag.func_74781_a(key).func_74732_a(), key);
        }
    }

    public static NBTTagCompound writeNBTBase(NBTTagCompound nbt, int type, Object object, String tagName) {
        if (object == null) {
            SonarCore.logger.error("NBT ERROR: Can't write NULL");
            return nbt;
        }
        if (tagName == null) {
            SonarCore.logger.error("NBT ERROR: Can't write with no TAG NAME");
            return nbt;
        }
        switch (type) {
            case 0: {
                nbt.func_74757_a(tagName, ((Boolean)object).booleanValue());
                break;
            }
            case 1: {
                nbt.func_74774_a(tagName, ((Byte)object).byteValue());
                break;
            }
            case 2: {
                nbt.func_74777_a(tagName, ((Short)object).shortValue());
                break;
            }
            case 3: {
                nbt.func_74768_a(tagName, ((Integer)object).intValue());
                break;
            }
            case 4: {
                nbt.func_74772_a(tagName, ((Long)object).longValue());
                break;
            }
            case 5: {
                nbt.func_74776_a(tagName, ((Float)object).floatValue());
                break;
            }
            case 6: {
                nbt.func_74780_a(tagName, ((Double)object).doubleValue());
                break;
            }
            case 7: {
                nbt.func_74773_a(tagName, (byte[])object);
                break;
            }
            case 8: {
                nbt.func_74778_a(tagName, (String)object);
                break;
            }
            case 9: {
                nbt.func_74782_a(tagName, (NBTBase)object);
                break;
            }
            case 10: {
                nbt.func_74782_a(tagName, (NBTBase)((NBTTagCompound)object));
                break;
            }
            case 11: {
                nbt.func_74783_a(tagName, (int[])object);
            }
        }
        return nbt;
    }

    public static Object readNBTBase(NBTTagCompound nbt, int type, String tagName) {
        switch (type) {
            case 0: {
                return nbt.func_74767_n(tagName);
            }
            case 1: {
                return nbt.func_74771_c(tagName);
            }
            case 2: {
                return nbt.func_74765_d(tagName);
            }
            case 3: {
                return nbt.func_74762_e(tagName);
            }
            case 4: {
                return nbt.func_74763_f(tagName);
            }
            case 5: {
                return Float.valueOf(nbt.func_74760_g(tagName));
            }
            case 6: {
                return nbt.func_74769_h(tagName);
            }
            case 7: {
                return nbt.func_74770_j(tagName);
            }
            case 8: {
                return nbt.func_74779_i(tagName);
            }
            case 10: {
                return nbt.func_74781_a(tagName);
            }
            case 11: {
                return nbt.func_74759_k(tagName);
            }
        }
        return null;
    }

    public static void writeBufBase(ByteBuf buf, int type, Object object, String tagName) {
        switch (type) {
            case 0: {
                buf.writeBoolean(((Boolean)object).booleanValue());
                return;
            }
            case 1: {
                buf.writeByte((int)((Byte)object).byteValue());
                return;
            }
            case 2: {
                buf.writeShort((int)((Short)object).shortValue());
                return;
            }
            case 3: {
                buf.writeInt(((Integer)object).intValue());
                return;
            }
            case 4: {
                buf.writeLong(((Long)object).longValue());
                return;
            }
            case 5: {
                buf.writeFloat(((Float)object).floatValue());
                return;
            }
            case 6: {
                buf.writeDouble(((Double)object).doubleValue());
                return;
            }
            case 7: {
                Byte[] byteArray = (Byte[])object;
                buf.writeInt(byteArray.length);
                for (int i = 0; i < byteArray.length; ++i) {
                    buf.writeByte((int)byteArray[i].byteValue());
                }
                return;
            }
            case 8: {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)object));
                return;
            }
            case 9: {
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)((NBTTagCompound)object));
                return;
            }
            case 10: {
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)((NBTTagCompound)object));
                return;
            }
            case 11: {
                Integer[] intArray = (Integer[])object;
                buf.writeInt(intArray.length);
                for (int i = 0; i < intArray.length; ++i) {
                    buf.writeInt(intArray[i].intValue());
                }
                return;
            }
        }
    }

    public static Object readBufBase(ByteBuf buf, int type, String tagName) {
        switch (type) {
            case 0: {
                return buf.readBoolean();
            }
            case 1: {
                return buf.readByte();
            }
            case 2: {
                return buf.readShort();
            }
            case 3: {
                return buf.readInt();
            }
            case 4: {
                return buf.readLong();
            }
            case 5: {
                return Float.valueOf(buf.readFloat());
            }
            case 6: {
                return buf.readDouble();
            }
            case 7: {
                int byteArraySize = buf.readInt();
                byte[] byteArray = new byte[byteArraySize];
                for (int i = 0; i < byteArray.length; ++i) {
                    byteArray[i] = buf.readByte();
                }
                return byteArray;
            }
            case 8: {
                return ByteBufUtils.readUTF8String((ByteBuf)buf);
            }
            case 9: 
            case 10: {
                return ByteBufUtils.readTag((ByteBuf)buf);
            }
            case 11: {
                int intArraySize = buf.readInt();
                int[] intArray = new int[intArraySize];
                for (int i = 0; i < intArray.length; ++i) {
                    intArray[i] = buf.readInt();
                }
                return intArray;
            }
        }
        return null;
    }

    public static enum SyncType {
        SAVE(0),
        DROP(2),
        SPECIAL(3),
        PACKET(4),
        DEFAULT_SYNC(1),
        SYNC_OVERRIDE(1);

        private int type;

        private SyncType(int type) {
            this.type = type;
        }

        public boolean mustSync() {
            return this == SYNC_OVERRIDE || this == SAVE;
        }

        public boolean isType(SyncType ... types) {
            for (SyncType type : types) {
                if (type.type != this.type) continue;
                return true;
            }
            return false;
        }

        public static boolean isGivenType(SyncType current, SyncType ... types) {
            if (current == null) {
                return false;
            }
            for (SyncType type : types) {
                if (type.type != current.type) continue;
                return true;
            }
            return false;
        }
    }
}

