/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import org.lwjgl.opengl.GL11;
import sonar.core.SonarCore;
import sonar.core.client.BlockModelsCache;
import sonar.core.client.gui.GuiSonar;
import sonar.core.client.renderers.TransformationMatrix;
import sonar.core.client.renderers.Vector;
import sonar.core.helpers.FontHelper;

public class RenderHelper {
    public static final RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
    public static final FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
    public static final TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
    public static int src = -1;
    public static int dst = -1;
    protected RenderManager renderManager;
    public static double[][] offsetMatrix = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {1.0, 0.0, -1.0}, {1.0, 0.0, 0.0}, {0.0, 0.0, -1.0}};

    public static void saveBlendState() {
        src = GL11.glGetInteger((int)3041);
        dst = GL11.glGetInteger((int)3040);
    }

    public static void restoreBlendState() {
        if (src != -1 && dst != -1) {
            GL11.glBlendFunc((int)src, (int)dst);
        }
    }

    public static int setMetaData(TileEntity tileentity) {
        int i;
        if (tileentity.func_145831_w() == null) {
            i = 0;
        } else {
            Block block = tileentity.func_145838_q();
            i = tileentity.func_145832_p();
            if (block != null && i == 0) {
                i = tileentity.func_145832_p();
            }
        }
        return i;
    }

    public static void beginRender(double x, double y, double z, int meta, String texture) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation(texture));
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)180.0f, (float)0.0f, (float)1.0f);
        int j = 0;
        switch (meta) {
            case 2: {
                j = 180;
                break;
            }
            case 3: {
                j = 0;
                break;
            }
            case 4: {
                j = 90;
                break;
            }
            case 5: {
                j = 270;
            }
        }
        GL11.glRotatef((float)j, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotated((double)-0.625, (double)0.0, (double)1.0, (double)0.0);
    }

    public static void finishRender() {
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public static void drawRect(float left, float top, float right, float bottom, int color) {
        if (left < right) {
            float i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            float j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void addVertexWithUV(VertexBuffer vertexbuffer, double x, double y, double z, double u, double v) {
        vertexbuffer.func_181662_b(x, y, z).func_187315_a(u, v).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
    }

    public static void renderItem(GuiSonar screen, int x, int y, ItemStack stack) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        screen.setZLevel(200.0f);
        RenderHelper.itemRender.field_77023_b = 200.0f;
        itemRender.func_180450_b(stack, x, y);
        screen.setZLevel(0.0f);
        RenderHelper.itemRender.field_77023_b = 0.0f;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-32.0f);
    }

    public static void renderStoredItemStackOverlay(ItemStack stack, long stored, int x, int y, String string, boolean depth) {
        if (stack != null) {
            FontRenderer font = RenderHelper.getFontFromStack(stack);
            stack.field_77994_a = 1;
            if (stored > 0L || string != null) {
                String s1 = string == null ? FontHelper.formatStackSize(stored) : string;
                float scaleFactor = 0.5f;
                float inverseScaleFactor = 2.0f;
                GL11.glPushMatrix();
                GlStateManager.func_179140_f();
                if (depth) {
                    GlStateManager.func_179097_i();
                }
                GlStateManager.func_179084_k();
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                int X = (int)(((float)x + 15.0f - (float)font.func_78256_a(s1) * 0.5f) * 2.0f);
                int Y = (int)(((float)y + 15.0f - 3.5f) * 2.0f);
                font.func_175063_a(s1, (float)X, (float)Y, 0xFFFFFF);
                GlStateManager.func_179145_e();
                if (depth) {
                    GlStateManager.func_179126_j();
                }
                GlStateManager.func_179147_l();
                GL11.glPopMatrix();
            }
        }
    }

    public static FontRenderer getFontFromStack(ItemStack stack) {
        FontRenderer rend;
        return stack != null ? ((rend = stack.func_77973_b().getFontRenderer(stack)) == null ? fontRenderer : rend) : fontRenderer;
    }

    public static void drawTexturedModalRect(float minX, float minY, float maxY, float width, float height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float x = minX;
        float y = minY;
        float textureX = 0.0f;
        float textureY = 0.0f;
        double widthnew = 0.0f + width * 2.0f;
        double heightnew = 0.0f + height * 2.0f;
        vertexbuffer.func_181662_b((double)(x + 0.0f), (double)(y + height), 0.0).func_187315_a((double)((textureX + 0.0f) * f), (double)((textureY + height) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((textureX + width) * f), (double)((textureY + height) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + 0.0f), 0.0).func_187315_a((double)((textureX + width) * f), (double)((textureY + 0.0f) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), 0.0).func_187315_a((double)((textureX + 0.0f) * f), (double)((textureY + 0.0f) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawScaledCustomSizeModalRect(int x, int y, float u, float v, int uWidth, int vHeight, int width, int height, float tileWidth, float tileHeight) {
        float f = 1.0f / tileWidth;
        float f1 = 1.0f / tileHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)(u * f), (double)((v + (float)vHeight) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((u + (float)uWidth) * f), (double)((v + (float)vHeight) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((u + (float)uWidth) * f), (double)(v * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + 0), 0.0).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawSizedIconWithoutColor(int x, int y, int width, int height, float zLevel) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.func_179109_b((float)x, (float)y, (float)zLevel);
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179126_j();
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        tessellator.func_178180_c().func_181662_b((double)x, (double)(y + height), (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(x + width), (double)y, (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)x, (double)y, (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    public static void renderItem(ItemStack stack, World world) {
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
        GlStateManager.func_179109_b((float)-6.4f, (float)-6.5f, (float)-0.245f);
        GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.01);
        RenderHelper.renderItem(stack, ItemCameraTransforms.TransformType.NONE);
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }

    public static IBakedModel getBakedModel(IBlockState state) {
        BlockRendererDispatcher renderer = Minecraft.func_71410_x().func_175602_ab();
        BlockModelShapes models = renderer.func_175023_a();
        return models.func_178125_b(state);
    }

    public static void renderItem(ItemStack itemStack, ItemCameraTransforms.TransformType transformType) {
        GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)-1.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        IBakedModel ibakedmodel = itemRender.func_175037_a().func_178089_a(itemStack);
        if (ibakedmodel.func_177556_c()) {
            GlStateManager.func_179152_a((float)0.625f, (float)0.625f, (float)0.625f);
            GlStateManager.func_179114_b((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179140_f();
        }
        itemRender.func_181564_a(itemStack, transformType);
    }

    public static void renderItemIntoGUI(ItemStack stack, int x, int y) {
        IBakedModel model = BlockModelsCache.INSTANCE.getOrLoadModel(stack);
        if (model != null) {
            RenderHelper.renderItemModelIntoGUI(stack, x, y, model);
        }
    }

    public static void renderItemModelIntoGUI(ItemStack stack, int x, int y, IBakedModel bakedmodel) {
        GlStateManager.func_179094_E();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.setupGuiTransform(x, y, bakedmodel.func_177556_c());
        GL11.glScaled((double)1.0, (double)1.0, (double)0.04);
        bakedmodel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        itemRender.func_180454_a(stack, bakedmodel);
        GlStateManager.func_179118_c();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    public static void setupGuiTransform(int xPosition, int yPosition, boolean isGui3d) {
        GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)16.0f, (float)16.0f, (float)16.0f);
        if (!isGui3d) {
            GlStateManager.func_179140_f();
        }
    }

    public static List<BakedQuad> transformQuads(List<BakedQuad> quads, TransformationMatrix matrix) {
        ArrayList<BakedQuad> newQuads = new ArrayList<BakedQuad>();
        for (BakedQuad quad : quads) {
            VertexFormat format = quad.getFormat();
            float[][][] vertexData = new float[4][format.func_177345_h()][];
            for (int v = 0; v < 4; ++v) {
                for (int e = 0; e < format.func_177345_h(); ++e) {
                    float[] data = new float[4];
                    LightUtil.unpack((int[])quad.func_178209_a(), (float[])data, (VertexFormat)format, (int)v, (int)e);
                    vertexData[v][e] = RenderHelper.transformUnpackedVertexDataElement(matrix, format.func_177348_c(e).func_177375_c(), data);
                }
            }
            newQuads.add((BakedQuad)new UnpackedBakedQuad(vertexData, quad.func_178211_c(), EnumFacing.UP, quad.func_187508_a(), true, format));
        }
        return newQuads;
    }

    public static float[] transformUnpackedVertexDataElement(TransformationMatrix matrix, VertexFormatElement.EnumUsage type, float[] data) {
        switch (type) {
            case POSITION: 
            case NORMAL: {
                double[] pos = matrix.transform(data[0], data[1], data[2]);
                data[0] = (float)pos[0];
                data[1] = (float)pos[1];
                data[2] = (float)pos[2];
                break;
            }
            case COLOR: {
                break;
            }
        }
        return data;
    }

    public static Vector getOffsetForFace(EnumFacing face) {
        switch (face) {
            case DOWN: {
                return new Vector(0.0, 0.0, 0.0);
            }
            case EAST: {
                return new Vector(0.0, 0.0, 1.0);
            }
            case NORTH: {
                return new Vector(1.0, 0.0, 1.0);
            }
            case SOUTH: {
                return new Vector(0.0, 0.0, 0.0);
            }
            case UP: {
                return new Vector(0.0, 0.0, 1.0);
            }
            case WEST: {
                return new Vector(1.0, 0.0, 0.0);
            }
        }
        return new Vector(0.0, 0.0, 0.0);
    }

    public static void offsetRendering(BlockPos pos, double partialTicks) {
        Entity view = Minecraft.func_71410_x().func_175606_aa();
        double vX = view.field_70142_S + (view.field_70165_t - view.field_70142_S) * partialTicks;
        double vY = view.field_70137_T + (view.field_70163_u - view.field_70137_T) * partialTicks;
        double vZ = view.field_70136_U + (view.field_70161_v - view.field_70136_U) * partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)pos.func_177958_n() - vX), (double)((double)pos.func_177956_o() - vY), (double)((double)pos.func_177952_p() - vZ));
    }

    public static void drawBoundingBox(AxisAlignedBB box, BlockPos pos, float partialTicks, float r, float g, float b, float alpha) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)5.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        if (Minecraft.func_71410_x().field_71441_e.func_175723_af().func_177746_a(pos)) {
            double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
            double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
            double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
            GlStateManager.func_179137_b((double)(-d0 + (double)pos.func_177958_n()), (double)(-d1 + (double)pos.func_177956_o()), (double)(-d2 + (double)pos.func_177952_p()));
            RenderHelper.drawBoundingBox(box.func_186662_g((double)0.002f), r, g, b, alpha);
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawBoundingBox(AxisAlignedBB box, float r, float g, float b, float alpha) {
        RenderHelper.drawBoundingBox(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f, r, g, b, alpha);
    }

    public static void drawBoundingBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float r, float g, float b, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        RenderHelper.drawBoundingBox(vertexbuffer, minX, minY, minZ, maxX, maxY, maxZ, r, g, b, alpha);
        tessellator.func_78381_a();
    }

    public static void drawBoundingBox(VertexBuffer buffer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float r, float g, float b, float alpha) {
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, 0.0f).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(r, g, b, 0.0f).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(r, g, b, 0.0f).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(r, g, b, 0.0f).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, 0.0f).func_181675_d();
    }

    public static void resetLanguageRegistry() {
        SonarCore.logger.info("Resetting Language");
        Minecraft.func_71410_x().func_135016_M().func_110549_a(Minecraft.func_71410_x().func_110442_L());
        SonarCore.logger.info("Reset Language");
    }
}

