/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.integration.minetweaker;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import sonar.core.helpers.RecipeHelper;

@Deprecated
public class SonarRemoveRecipe
implements IUndoableAction {
    public ArrayList inputs;
    public ItemStack[] outputs;
    public boolean liquidStack;
    public boolean wasNull;
    public boolean wrongSize;
    public RecipeHelper helper;

    public SonarRemoveRecipe(RecipeHelper helper, ArrayList inputs, boolean crafter) {
        this.helper = helper;
        if (inputs.size() != helper.inputSize) {
            MineTweakerAPI.logError((String)("A " + helper.getRecipeID() + " recipe was the wrong size"));
            this.wrongSize = true;
            return;
        }
        ArrayList adaptedInputs = Lists.newArrayList();
        for (Object input : inputs) {
            if (input == null) {
                MineTweakerAPI.logError((String)String.format("An ingredient of a %s was null", helper.getRecipeID()));
                this.wasNull = true;
                return;
            }
            if (input instanceof IItemStack) {
                adaptedInputs.add(MineTweakerMC.getItemStack((IItemStack)((IItemStack)input)));
                continue;
            }
            if (input instanceof IOreDictEntry) {
                adaptedInputs.add(new RecipeHelper.OreStack(((IOreDictEntry)input).getName(), 1));
                continue;
            }
            if (input instanceof ILiquidStack) {
                MineTweakerAPI.logError((String)String.format("A liquid was passed into a %s, aborting!", helper.getRecipeID()));
                this.liquidStack = true;
                return;
            }
            if (!(input instanceof ItemStack)) {
                MineTweakerAPI.logError((String)String.format("%s: Invalid ingredient: %s", helper.getRecipeID(), input));
                continue;
            }
            adaptedInputs.add(input);
        }
        this.inputs = adaptedInputs;
        ItemStack[] dummyInputs = new ItemStack[helper.inputSize];
        for (int i = 0; i < adaptedInputs.size(); ++i) {
            Object input = adaptedInputs.get(i);
            if (input instanceof ItemStack) {
                dummyInputs[i] = (ItemStack)input;
            }
            if (!(input instanceof RecipeHelper.OreStack)) continue;
            dummyInputs[i] = (ItemStack)OreDictionary.getOres((String)((RecipeHelper.OreStack)input).oreString).get(0);
        }
        this.outputs = crafter ? new ItemStack[]{helper.getCraftingResult(dummyInputs)} : helper.getOutput(dummyInputs);
    }

    public void apply() {
        boolean removed;
        if (!(this.wasNull || this.liquidStack || this.wrongSize || this.outputs.length == 0 || (removed = this.helper.removeRecipe(this.inputs.toArray())))) {
            MineTweakerAPI.logError((String)String.format("%s: Failed to remove recipe %s", this.helper.getRecipeID(), this.inputs));
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        if (!(this.wasNull || this.liquidStack || this.wrongSize || this.outputs.length == 0)) {
            ArrayList toApply = (ArrayList)this.inputs.clone();
            for (int i = 0; i < this.outputs.length; ++i) {
                toApply.add(this.outputs[i]);
            }
            this.helper.addRecipe(toApply.toArray());
        }
    }

    public String describe() {
        return String.format("Removing %s recipe (%s = %s)", this.helper.getRecipeID(), this.inputs, this.outputs);
    }

    public String describeUndo() {
        return String.format("Reverting /%s/", this.describe());
    }

    public Object getOverrideKey() {
        return null;
    }
}

