/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.integration.minetweaker;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.BiFunction;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import sonar.core.recipes.DefinedRecipeHelper;
import sonar.core.recipes.ISonarRecipe;
import sonar.core.recipes.RecipeHelperV2;
import sonar.core.recipes.RecipeObjectType;
import sonar.core.recipes.RecipeOreStack;

public class SonarRemoveRecipeV2<T extends RecipeHelperV2>
implements IUndoableAction {
    public ArrayList ingredients;
    public RecipeObjectType type;
    public ISonarRecipe recipe;
    public boolean liquidStack;
    public boolean wasNull;
    public boolean wrongSize;
    public T helper;
    public BiFunction<ISonarRecipe, T, Object> createRecipe;

    public SonarRemoveRecipeV2(T helper, RecipeObjectType type, ArrayList ingredients, BiFunction<ISonarRecipe, T, Object> createRecipe) {
        this.helper = helper;
        this.createRecipe = createRecipe;
        this.type = type;
        if (helper instanceof DefinedRecipeHelper && (type == RecipeObjectType.OUTPUT ? ingredients.size() != ((DefinedRecipeHelper)helper).getOutputSize() : ingredients.size() != ((DefinedRecipeHelper)helper).getInputSize())) {
            MineTweakerAPI.logError((String)("A " + ((RecipeHelperV2)helper).getRecipeID() + " recipe was the wrong size"));
            this.wrongSize = true;
            return;
        }
        ArrayList adaptedIngredients = Lists.newArrayList();
        for (Object output : ingredients) {
            if (output == null) {
                MineTweakerAPI.logError((String)String.format("An ingredient of a %s was null", ((RecipeHelperV2)helper).getRecipeID()));
                this.wasNull = true;
                return;
            }
            if (output instanceof IItemStack) {
                adaptedIngredients.add(MineTweakerMC.getItemStack((IItemStack)((IItemStack)output)));
                continue;
            }
            if (output instanceof IOreDictEntry) {
                adaptedIngredients.add(new RecipeOreStack(((IOreDictEntry)output).getName(), 1));
                continue;
            }
            if (output instanceof ILiquidStack) {
                MineTweakerAPI.logError((String)String.format("A liquid was passed into a %s, aborting!", ((RecipeHelperV2)helper).getRecipeID()));
                this.liquidStack = true;
                return;
            }
            if (!(output instanceof ItemStack)) {
                MineTweakerAPI.logError((String)String.format("%s: Invalid ingredient: %s", ((RecipeHelperV2)helper).getRecipeID(), output));
                continue;
            }
            adaptedIngredients.add(output);
        }
        this.ingredients = adaptedIngredients;
        this.recipe = type == RecipeObjectType.OUTPUT ? ((RecipeHelperV2)helper).getRecipeFromOutputs(null, adaptedIngredients.toArray()) : ((RecipeHelperV2)helper).getRecipeFromInputs(null, adaptedIngredients.toArray());
    }

    public void apply() {
        if (this.recipe == null) {
            MineTweakerAPI.logError((String)String.format("%s: Removing Recipe - Couldn't find matching recipe %s", ((RecipeHelperV2)this.helper).getRecipeID(), this.ingredients));
            return;
        }
        if (!(this.wasNull || this.liquidStack || this.wrongSize)) {
            boolean removed = ((RecipeHelperV2)((Object)this.helper)).removeRecipe((ISonarRecipe)this.recipe);
            if (!removed) {
                MineTweakerAPI.logError((String)String.format("%s: Removing Recipe - Failed to remove recipe %s", ((RecipeHelperV2)this.helper).getRecipeID(), this.ingredients));
            } else {
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe(this.createRecipe.apply(this.recipe, (ISonarRecipe)this.helper));
            }
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        if (!(this.recipe == null || this.wasNull || this.liquidStack || this.wrongSize)) {
            ((RecipeHelperV2)((Object)this.helper)).addRecipe((ISonarRecipe)this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().addRecipe(this.createRecipe.apply(this.recipe, (ISonarRecipe)this.helper));
        }
    }

    public String describe() {
        if (this.recipe == null) {
            return "ERROR: RECIPE IS NULL";
        }
        return String.format("Removing %s recipe (%s = %s)", ((RecipeHelperV2)this.helper).getRecipeID(), this.recipe.inputs(), this.recipe.outputs());
    }

    public String describeUndo() {
        return String.format("Reverting /%s/", this.describe());
    }

    public Object getOverrideKey() {
        return null;
    }
}

