/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.network.PacketCoords;
import sonar.core.network.PacketTileEntityHandler;
import sonar.core.utils.IMachineSides;
import sonar.core.utils.MachineSideConfig;

public class PacketSonarSides
extends PacketCoords<PacketSonarSides> {
    public EnumFacing side;
    public MachineSideConfig config;

    public PacketSonarSides() {
    }

    public PacketSonarSides(BlockPos pos, EnumFacing side, MachineSideConfig config) {
        super(pos);
        this.side = side;
        this.config = config;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.side = EnumFacing.field_82609_l[buf.readInt()];
        PacketSonarSides packetSonarSides = this;
        this.config = packetSonarSides.config.values()[buf.readInt()];
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.side.func_176745_a());
        buf.writeInt(this.config.ordinal());
    }

    public static class Handler
    extends PacketTileEntityHandler<PacketSonarSides> {
        @Override
        public IMessage processMessage(EntityPlayer player, MessageContext ctx, PacketSonarSides message, TileEntity tile) {
            if (tile.func_145831_w().field_72995_K && tile instanceof IMachineSides) {
                IMachineSides sides = (IMachineSides)tile;
                sides.getSideConfigs().setSide(message.side, message.config);
                if (tile instanceof TileEntitySonar) {
                    ((TileEntitySonar)tile).markBlockForUpdate();
                }
            }
            return null;
        }
    }
}

