/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.utils;

import com.google.common.collect.Maps;
import java.util.HashMap;

public class SimpleProfiler {
    public static HashMap<String, Long> profiles = Maps.newHashMap();

    public static void start(String key) {
        profiles.put(key, System.nanoTime());
    }

    public static long finish(String key) {
        long before = profiles.get(key);
        profiles.remove(key);
        return System.nanoTime() - before;
    }

    public static void finishMilli(String key) {
        double milli = (double)SimpleProfiler.finish(key) / 1000000.0;
        System.out.println(key + " took " + milli + " milliseconds");
    }

    public static void finishMicro(String key) {
        double micro = (double)SimpleProfiler.finish(key) / 1000.0;
        System.out.println(key + " took " + micro + " microseconds");
    }
}

