/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidLib {
    public static void drainContainerIntoTank(IFluidHandler container, IFluidHandler tank) {
        FluidStack fluidStack = container.drain(Integer.MAX_VALUE, false);
        int filled = tank.fill(fluidStack, true);
        container.drain(filled, true);
    }

    public static boolean areFluidStacksEqual(@Nullable FluidStack stackA, @Nullable FluidStack stackB) {
        return stackA == null && stackB == null || stackA != null && stackB != null && stackA.isFluidEqual(stackB);
    }

    public static boolean areFluidStacksIdentical(@Nullable FluidStack stackA, @Nullable FluidStack stackB) {
        return stackA == null && stackB == null || stackA != null && stackB != null && stackA.isFluidStackIdentical(stackB);
    }

    public static boolean hasFluidItemCap(@Nullable ItemStack stack) {
        return stack != null && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
    }

    public static IFluidHandler getFluidItemCap(@Nonnull ItemStack stack) {
        return (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
    }
}

