/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemStackUtil {
    @Nullable
    public static ItemStack grow(@Nonnull ItemStack stack, int amount) {
        stack.field_77994_a += amount;
        if (stack.field_77994_a <= 0) {
            return null;
        }
        return stack;
    }

    @Nullable
    public static ItemStack decr(@Nonnull ItemStack stack) {
        return ItemStackUtil.grow(stack, -1);
    }

    public static int getCount(@Nullable ItemStack stack) {
        return stack == null ? 0 : stack.field_77994_a;
    }

    @Nullable
    public static ItemStack setCount(@Nonnull ItemStack stack, int count) {
        stack.field_77994_a = count;
        return stack.field_77994_a > 0 ? stack : null;
    }

    public static boolean isEmpty(@Nullable ItemStack stack) {
        return stack == null || stack.field_77994_a <= 0;
    }

    @Nullable
    public static ItemStack makeEmpty(@Nullable ItemStack stack) {
        if (stack != null) {
            stack.field_77994_a = 0;
        }
        return null;
    }

    @Nullable
    public static ItemStack getEmptyStack() {
        return null;
    }

    @Nullable
    public static ItemStack loadFromNBT(@Nonnull NBTTagCompound nbt) {
        return ItemStack.func_77949_a((NBTTagCompound)nbt);
    }

    @Nullable
    public static ItemStack decrIInventoryStackSize(IInventory inv, int slot, int amt) {
        ItemStack stack = inv.func_70301_a(slot);
        if (!ItemStackUtil.isEmpty(stack)) {
            if (ItemStackUtil.getCount(stack) <= amt) {
                inv.func_70299_a(slot, ItemStackUtil.getEmptyStack());
            } else if (ItemStackUtil.isEmpty(stack = stack.func_77979_a(amt))) {
                inv.func_70299_a(slot, ItemStackUtil.getEmptyStack());
            }
            return stack;
        }
        return ItemStackUtil.getEmptyStack();
    }

    public static boolean isValid(ItemStack stack) {
        return true;
    }

    public static boolean doesStackContain(@Nullable ItemStack stackA, @Nullable ItemStack stackB) {
        return stackB == null || stackA != null && ItemStackUtil.areStacksEqualIgnoreAmount(stackA, stackB) && stackA.field_77994_a >= stackB.field_77994_a;
    }

    public static boolean areStacksEqualIgnoreAmount(@Nullable ItemStack stackA, @Nullable ItemStack stackB) {
        if (stackA == null && stackB == null) {
            return true;
        }
        if (stackA == null || stackB == null) {
            return false;
        }
        if (stackA.func_77973_b() != stackB.func_77973_b()) {
            return false;
        }
        if (stackA.func_77952_i() != stackB.func_77952_i()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
    }
}

