/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism;

import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.lib.network.AbstractPacketDispatcher;
import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.lib.lib.util.Logger;
import de.teamlapen.lib.lib.util.ModCompatLoader;
import de.teamlapen.lib.lib.util.VersionChecker;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IVampirismEntityRegistry;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.api.entity.hunter.IHunterMob;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.api.world.IVampirismVillageProvider;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.core.Achievements;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEventHandler;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.TestCommand;
import de.teamlapen.vampirism.core.VampirismCommand;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.ModEntityEventHandler;
import de.teamlapen.vampirism.entity.SundamageRegistry;
import de.teamlapen.vampirism.entity.converted.DefaultConvertingHandler;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.factions.FactionRegistry;
import de.teamlapen.vampirism.inventory.AlchemicalCauldronCraftingManager;
import de.teamlapen.vampirism.inventory.HunterWeaponCraftingManager;
import de.teamlapen.vampirism.modcompat.GrimoireOfGaiaModCompat;
import de.teamlapen.vampirism.modcompat.SophisticatedWolvesModCompat;
import de.teamlapen.vampirism.modcompat.SpongeModCompat;
import de.teamlapen.vampirism.modcompat.abyssalcraft.AbyssalCraftModCompat;
import de.teamlapen.vampirism.modcompat.bop.BoPModCompat;
import de.teamlapen.vampirism.modcompat.guide.GuideAPICompat;
import de.teamlapen.vampirism.modcompat.jei.JEIModCompat;
import de.teamlapen.vampirism.modcompat.waila.WailaModCompat;
import de.teamlapen.vampirism.network.ModGuiHandler;
import de.teamlapen.vampirism.network.ModPacketDispatcher;
import de.teamlapen.vampirism.player.ModPlayerEventHandler;
import de.teamlapen.vampirism.player.actions.ActionRegistry;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.hunter.actions.HunterActions;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.player.skills.SkillRegistry;
import de.teamlapen.vampirism.player.vampire.BloodVision;
import de.teamlapen.vampirism.player.vampire.NightVision;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.player.vampire.skills.VampireSkills;
import de.teamlapen.vampirism.potion.blood.BloodPotionRegistry;
import de.teamlapen.vampirism.potion.blood.BloodPotions;
import de.teamlapen.vampirism.proxy.IProxy;
import de.teamlapen.vampirism.util.GeneralRegistryImpl;
import de.teamlapen.vampirism.util.REFERENCE;
import de.teamlapen.vampirism.util.SupporterManager;
import de.teamlapen.vampirism.util.VampireBookManager;
import de.teamlapen.vampirism.world.GarlicChunkHandler;
import de.teamlapen.vampirism.world.gen.VampirismWorldGen;
import de.teamlapen.vampirism.world.loot.LootHandler;
import de.teamlapen.vampirism.world.villages.VampirismVillageCollection;
import java.awt.Color;
import java.io.File;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod(modid="vampirism", name="Vampirism", version="1.2.3", acceptedMinecraftVersions="[1.9.4,1.10)", dependencies="required-after:Forge@[12.18.3.2185,);after:guideapi", guiFactory="de.teamlapen.vampirism.client.core.ModGuiFactory", updateJSON="http://maxanier.de/projects/vampirism/versions.json")
public class VampirismMod {
    public static final Logger log = new Logger("vampirism", "de.teamlapen.vampirism");
    private static final EnumCreatureType HUNTER_CREATURE_TYPE = EnumHelper.addCreatureType((String)"VAMPIRISM_HUNTER", IHunterMob.class, (int)25, (Material)Material.field_151579_a, (boolean)false, (boolean)false);
    private static final EnumCreatureType VAMPIRE_CREATURE_TYPE = EnumHelper.addCreatureType((String)"VAMPIRISM_VAMPIRE", IVampireMob.class, (int)30, (Material)Material.field_151579_a, (boolean)false, (boolean)false);
    private static final EnumCreatureAttribute VAMPIRE_CREATURE_ATTRIBUTE = EnumHelper.addCreatureAttribute((String)"VAMPIRISM_VAMPIRE");
    @Mod.Instance(value="vampirism")
    public static VampirismMod instance;
    @SidedProxy(clientSide="de.teamlapen.vampirism.proxy.ClientProxy", serverSide="de.teamlapen.vampirism.proxy.ServerProxy")
    public static IProxy proxy;
    public static boolean inDev;
    public static AbstractPacketDispatcher dispatcher;
    public static CreativeTabs creativeTab;
    private VersionChecker.VersionInfo versionInfo;
    private ModCompatLoader modCompatLoader = new ModCompatLoader("vampirism/vampirism_mod_compat.cfg");

    public static boolean isRealism() {
        return Configs.realism_mode;
    }

    public VampirismMod() {
        this.addModCompats();
    }

    public VersionChecker.VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        String currentVersion = "@VERSION@".equals("1.2.3") ? "0.0.0-test" : "1.2.3";
        this.versionInfo = Configs.disable_versionCheck ? new VersionChecker.VersionInfo(currentVersion) : VersionChecker.executeVersionCheck("http://maxanier.de/projects/vampirism/versions.json", currentVersion);
        ModEventHandler eventHandler = new ModEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)eventHandler);
        MinecraftForge.EVENT_BUS.register((Object)new ModPlayerEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ModEntityEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)LootHandler.getInstance());
        GameRegistry.registerWorldGenerator((IWorldGenerator)new VampirismWorldGen(), (int)1000);
        HelperRegistry.registerPlayerEventReceivingCapability(VampirePlayer.CAP, VampirePlayer.class);
        HelperRegistry.registerPlayerEventReceivingCapability(HunterPlayer.CAP, HunterPlayer.class);
        HelperRegistry.registerSyncableEntityCapability(ExtendedCreature.CAP, REFERENCE.EXTENDED_CREATURE_KEY, ExtendedCreature.class);
        HelperRegistry.registerSyncablePlayerCapability(VampirePlayer.CAP, REFERENCE.VAMPIRE_PLAYER_KEY, VampirePlayer.class);
        HelperRegistry.registerSyncablePlayerCapability(HunterPlayer.CAP, REFERENCE.HUNTER_PLAYER_KEY, HunterPlayer.class);
        HelperRegistry.registerSyncablePlayerCapability(FactionPlayerHandler.CAP, REFERENCE.FACTION_PLAYER_HANDLER_KEY, FactionPlayerHandler.class);
        Achievements.registerAchievement();
        SupporterManager.getInstance().initAsync();
        VampireBookManager.getInstance().init();
        BloodPotions.register();
        proxy.onInitStep(IInitListener.Step.INIT, (FMLStateEvent)event);
        this.modCompatLoader.onInitStep(IInitListener.Step.INIT, (FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void onMissingMapping(FMLMissingMappingsEvent event) {
        log.d("Main", "Fixing missing mappings", new Object[0]);
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            if (mapping.type == GameRegistry.Type.BLOCK) {
                ModBlocks.fixMapping(mapping);
                continue;
            }
            if (mapping.type != GameRegistry.Type.ITEM || ModItems.fixMapping(mapping)) continue;
            ModBlocks.fixMappingItemBlock(mapping);
        }
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new VampirismCommand());
        event.registerServerCommand((ICommand)new TestCommand());
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
        if (!LootHandler.getInstance().checkAndResetInsertedAll()) {
            log.w("LootTables", "-------------------------------", new Object[0]);
            log.w("LootTables", "Failed to inject all loottables", new Object[0]);
            log.w("LootTables", "-------------------------------", new Object[0]);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.finishAPI();
        proxy.onInitStep(IInitListener.Step.POST_INIT, (FMLStateEvent)event);
        this.modCompatLoader.onInitStep(IInitListener.Step.POST_INIT, (FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.checkDevEnv();
        HunterPlayer.registerCapability();
        VampirePlayer.registerCapability();
        FactionPlayerHandler.registerCapability();
        ExtendedCreature.registerCapability();
        this.setupAPI1();
        Configs.init(new File(event.getModConfigurationDirectory(), "vampirism"), inDev);
        Balance.init(new File(event.getModConfigurationDirectory(), "vampirism"), inDev);
        this.modCompatLoader.onInitStep(IInitListener.Step.PRE_INIT, (FMLStateEvent)event);
        this.setupAPI2();
        dispatcher.registerPackets();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new ModGuiHandler());
        proxy.onInitStep(IInitListener.Step.PRE_INIT, (FMLStateEvent)event);
        VampireActions.registerDefaultActions();
        HunterActions.registerDefaultActions();
        VampireSkills.registerVampireSkills();
        HunterSkills.registerHunterSkills();
    }

    private void addModCompats() {
        this.modCompatLoader.addModCompat(new WailaModCompat());
        this.modCompatLoader.addModCompat(new JEIModCompat());
        this.modCompatLoader.addModCompat(new SpongeModCompat());
        this.modCompatLoader.addModCompat(new GuideAPICompat());
        this.modCompatLoader.addModCompat(new GrimoireOfGaiaModCompat());
        this.modCompatLoader.addModCompat(new SophisticatedWolvesModCompat());
        this.modCompatLoader.addModCompat(new AbyssalCraftModCompat());
        this.modCompatLoader.addModCompat(new BoPModCompat());
    }

    private void checkDevEnv() {
        if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            inDev = true;
            log.setDebug(true);
            if (FMLCommonHandler.instance().getSide().isClient()) {
                log.displayModID();
            }
        }
    }

    private void finishAPI() {
        ((FactionRegistry)VampirismAPI.factionRegistry()).finish();
        ((VampirismEntityRegistry)VampirismAPI.biteableRegistry()).finishRegistration(Balance.mobProps.CONVERTED_MOB_DEFAULT_DMG);
        ((ActionRegistry)VampirismAPI.actionRegistry()).finish();
        ((SkillRegistry)VampirismAPI.skillRegistry()).finish();
    }

    private void setupAPI1() {
        FactionRegistry factionRegistry = new FactionRegistry();
        SundamageRegistry sundamageRegistry = new SundamageRegistry();
        VampirismEntityRegistry biteableRegistry = new VampirismEntityRegistry();
        ActionRegistry actionRegistry = new ActionRegistry();
        SkillRegistry skillRegistry = new SkillRegistry();
        GeneralRegistryImpl generalRegistry = new GeneralRegistryImpl();
        IVampirismVillageProvider.IProviderProvider villageProviderProvider = new IVampirismVillageProvider.IProviderProvider(){

            @Override
            @Nonnull
            public IVampirismVillageProvider getProviderForWorld(World world) {
                return VampirismVillageCollection.get(world);
            }
        };
        BloodPotionRegistry bloodPotionRegistry = new BloodPotionRegistry();
        VampirismAPI.setUpRegistries(factionRegistry, sundamageRegistry, biteableRegistry, actionRegistry, skillRegistry, generalRegistry, bloodPotionRegistry);
        VampirismAPI.setUpAccessors(villageProviderProvider, HunterWeaponCraftingManager.getInstance(), new GarlicChunkHandler.Provider(), AlchemicalCauldronCraftingManager.getInstance());
        VReference.VAMPIRE_FACTION = factionRegistry.registerPlayableFaction("Vampire", IVampirePlayer.class, -8909405, REFERENCE.VAMPIRE_PLAYER_KEY, VampirePlayer.CAP, 14);
        VReference.VAMPIRE_FACTION.setChatColor(TextFormatting.DARK_PURPLE).setUnlocalizedName("text.vampirism.vampire", "text.vampirism.vampires");
        VReference.HUNTER_FACTION = factionRegistry.registerPlayableFaction("Hunter", IHunterPlayer.class, Color.BLUE.getRGB(), REFERENCE.HUNTER_PLAYER_KEY, HunterPlayer.CAP, 14);
        VReference.HUNTER_FACTION.setChatColor(TextFormatting.DARK_BLUE).setUnlocalizedName("text.vampirism.hunter", "text.vampirism.hunters");
        biteableRegistry.setDefaultConvertingHandlerCreator(new IVampirismEntityRegistry.ICreateDefaultConvertingHandler(){

            @Override
            public IConvertingHandler create(IConvertingHandler.IDefaultHelper helper) {
                return new DefaultConvertingHandler(helper);
            }
        });
        VReference.HUNTER_CREATURE_TYPE = HUNTER_CREATURE_TYPE;
        VReference.VAMPIRE_CREATURE_TYPE = VAMPIRE_CREATURE_TYPE;
        VReference.VAMPIRE_CREATURE_ATTRIBUTE = VAMPIRE_CREATURE_ATTRIBUTE;
    }

    private void setupAPI2() {
        VReference.vision_nightVision = VampirismAPI.vampireVisionRegistry().registerVision("nightVision", new NightVision());
        VReference.vision_bloodVision = VampirismAPI.vampireVisionRegistry().registerVision("bloodVision", new BloodVision());
    }

    static {
        inDev = false;
        dispatcher = new ModPacketDispatcher();
        creativeTab = new CreativeTabs("vampirism"){

            public Item func_78016_d() {
                return ModItems.vampireFang;
            }
        };
    }
}

