/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.actions;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import net.minecraft.util.ResourceLocation;

public abstract class DefaultAction<T extends IFactionPlayer>
implements IAction<T> {
    private final ResourceLocation icons;

    public DefaultAction(ResourceLocation icons) {
        this.icons = icons;
    }

    public boolean canBeUsedBy(T player) {
        return true;
    }

    @Override
    public IAction.PERM canUse(T player) {
        if (!this.isEnabled()) {
            return IAction.PERM.DISABLED;
        }
        return this.canBeUsedBy(player) ? IAction.PERM.ALLOWED : IAction.PERM.DISALLOWED;
    }

    @Override
    public ResourceLocation getIconLoc() {
        return this.icons;
    }

    public abstract boolean isEnabled();

    public String toString() {
        return VampirismAPI.actionRegistry().getKeyFromAction(this) + " (" + this.getClass().getSimpleName() + ")";
    }
}

