/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.ItemStackUtil;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.tileentity.TileGarlicBeacon;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGarlicBeacon
extends VampirismBlockContainer {
    public static final String regName = "garlic_beacon";
    public static final PropertyEnum<Type> TYPE = PropertyEnum.func_177709_a((String)"type", Type.class);
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.07, 0.0, 0.07, 0.93, 0.75, 0.93);
    private static final AxisAlignedBB COLLISION_BOX_1 = new AxisAlignedBB(0.19, 0.0, 0.19, 0.81, 0.75, 0.81);
    private static final AxisAlignedBB COLLISION_BOX_2 = new AxisAlignedBB(0.07, 0.0, 0.07, 0.93, 0.19, 0.93);

    public BlockGarlicBeacon() {
        super(regName, Material.field_151576_e);
        this.setHasFacing();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(TYPE, (Comparable)((Object)Type.NORMAL)));
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
        BlockGarlicBeacon.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_BOX_1);
        BlockGarlicBeacon.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_BOX_2);
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (stack.func_77960_j() > 0) {
            tooltip.add(TextFormatting.AQUA + UtilLib.translate(this.func_149739_a() + "." + Type.fromId(stack.func_77960_j()).func_176610_l()));
        }
        tooltip.add(UtilLib.translateFormatted(this.func_149739_a() + ".tooltip1", new Object[0]));
        int c = 1 + 2 * (stack.func_77960_j() == Type.IMPROVED.getId() ? Balance.hps.GARLIC_DIFFUSOR_ENHANCED_DISTANCE : (stack.func_77960_j() == Type.WEAK.getId() ? Balance.hps.GARLIC_DIFFUSOR_WEAK_DISTANCE : Balance.hps.GARLIC_DIFFUSOR_NORMAL_DISTANCE));
        tooltip.add(UtilLib.translateFormatted(this.func_149739_a() + ".tooltip2", c, c));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        TileGarlicBeacon tile = new TileGarlicBeacon();
        tile.setType(Type.fromId(meta >> 2));
        return tile;
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(TYPE))).id;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() | ((Type)((Object)state.func_177229_b(TYPE))).id << 2;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)ModBlocks.garlicBeacon, 1, ((Type)((Object)state.func_177229_b(TYPE))).getId());
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, ItemStack heldStack) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a(TYPE, (Comparable)((Object)Type.fromId(heldStack.func_77960_j())));
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing face = EnumFacing.func_176731_b((int)meta);
        Type t = Type.fromId(meta >> 2);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)face).func_177226_a(TYPE, (Comparable)((Object)t));
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (Type t : Type.values()) {
            list.add(new ItemStack(itemIn, 1, t.id));
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        if (te != null && te instanceof TileGarlicBeacon) {
            ((TileGarlicBeacon)te).onTouched(player);
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing faing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (!ItemStackUtil.isEmpty(heldItem) && ((Object)((Object)ModItems.purifiedGarlic)).equals(heldItem.func_77973_b())) {
            TileGarlicBeacon t;
            if (!worldIn.field_72995_K && (t = this.getTile((IBlockAccess)worldIn, pos)) != null) {
                if (t.getFuelTime() > 0) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("tile.vampirism.garlic_beacon.already_fueled", new Object[0]));
                } else {
                    t.onFueled();
                    if (!playerIn.field_71075_bZ.field_75098_d) {
                        ItemStackUtil.decr(heldItem);
                    }
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("tile.vampirism.garlic_beacon.successfully_fueled", new Object[0]));
                }
            }
            return true;
        }
        return false;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        TileGarlicBeacon tile = this.getTile((IBlockAccess)worldIn, pos);
        if (tile != null) {
            tile.onTouched(playerIn);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE});
    }

    @Nullable
    private TileGarlicBeacon getTile(IBlockAccess world, BlockPos pos) {
        TileEntity t = world.func_175625_s(pos);
        if (t instanceof TileGarlicBeacon) {
            return (TileGarlicBeacon)t;
        }
        return null;
    }

    public static enum Type implements IStringSerializable
    {
        NORMAL("standard", 0),
        IMPROVED("improved", 1),
        WEAK("weak", 2);

        private final String name;
        private final int id;

        private static Type fromId(int id) {
            for (Type t : Type.values()) {
                if (t.id != id) continue;
                return t;
            }
            return NORMAL;
        }

        private Type(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

