/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.core;

import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.lib.lib.util.InventoryRenderHelper;
import de.teamlapen.vampirism.blocks.BlockAltarPillar;
import de.teamlapen.vampirism.blocks.BlockCastleBlock;
import de.teamlapen.vampirism.blocks.BlockGarlicBeacon;
import de.teamlapen.vampirism.blocks.VampirismFlower;
import de.teamlapen.vampirism.client.render.tiles.AltarInfusionTESR;
import de.teamlapen.vampirism.client.render.tiles.CoffinTESR;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.tileentity.TileAlchemicalCauldron;
import de.teamlapen.vampirism.tileentity.TileAltarInfusion;
import de.teamlapen.vampirism.tileentity.TileCoffin;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModBlocksRender {
    public static void onInitStep(IInitListener.Step step, FMLStateEvent event) {
        switch (step) {
            case PRE_INIT: {
                ModBlocksRender.registerRenderer();
                ModBlocksRender.registerTileRenderer();
                break;
            }
            case POST_INIT: {
                ModBlocksRender.registerColors();
            }
        }
    }

    private static void registerColors() {
        Minecraft.func_71410_x().func_184125_al().func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
                if (tintIndex == 1) {
                    return 0x9966FF;
                }
                return 0x8855FF;
            }
        }, new Block[]{ModBlocks.alchemicalFire});
        Minecraft.func_71410_x().func_184125_al().func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
                if (tintIndex == 255) {
                    TileEntity tile;
                    TileEntity tileEntity = tile = worldIn == null || pos == null ? null : worldIn.func_175625_s(pos);
                    if (tile != null && tile instanceof TileAlchemicalCauldron) {
                        return ((TileAlchemicalCauldron)tile).getLiquidColorClient();
                    }
                }
                return 0xFFFFFF;
            }
        }, new Block[]{ModBlocks.alchemicalCauldron});
    }

    private static void registerRenderer() {
        InventoryRenderHelper renderHelper = new InventoryRenderHelper("vampirism");
        renderHelper.registerRenderAllMeta(Item.func_150898_a((Block)ModBlocks.castleBlock), BlockCastleBlock.EnumType.values());
        renderHelper.registerRenderAllMeta(Item.func_150898_a((Block)ModBlocks.altarPillar), BlockAltarPillar.EnumPillarType.values());
        renderHelper.registerRender(ModBlocks.altarTip);
        renderHelper.registerRender((Block)ModBlocks.altarInfusion);
        renderHelper.registerRender(ModBlocks.cursedEarth);
        renderHelper.registerRender((Block)ModBlocks.bloodContainer);
        renderHelper.registerRender((Block)ModBlocks.altarInspiration);
        renderHelper.registerRender(ModBlocks.firePlace);
        renderHelper.registerRender(ModBlocks.bloodPotionTable);
        renderHelper.registerRender((Block)ModBlocks.sunscreenBeacon);
        renderHelper.registerRenderAllMeta(Item.func_150898_a((Block)ModBlocks.hunterTable), (IStringSerializable[])EnumFacing.field_176754_o);
        renderHelper.registerRenderAllMeta(Item.func_150898_a((Block)ModBlocks.vampirismFlower), VampirismFlower.EnumFlowerType.values());
        renderHelper.registerRenderAllMeta(Item.func_150898_a((Block)ModBlocks.churchAltar), (IStringSerializable[])EnumFacing.field_176754_o);
        renderHelper.registerRender(Item.func_150898_a((Block)ModBlocks.weaponTable), "inventory");
        renderHelper.registerRender((Block)ModBlocks.alchemicalCauldron);
        for (EnumFacing f : EnumFacing.field_176754_o) {
            for (BlockGarlicBeacon.Type t : BlockGarlicBeacon.Type.values()) {
                ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.garlicBeacon), (int)(f.func_176736_b() | t.getId() << 2), (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("vampirism", "garlic_beacon"), "facing=" + f.func_176610_l() + ",type=" + t.func_176610_l()));
            }
        }
        ModelLoader.setCustomStateMapper((Block)ModBlocks.weaponTable, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(new ResourceLocation("vampirism", "weapon_table"), "normal");
            }
        });
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)ModBlocks.fluidBlood), (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)ModBlocks.fluidBlood), (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return new ModelResourceLocation(new ResourceLocation("vampirism", "fluids"), "blood");
            }
        });
        ModelLoader.setCustomStateMapper((Block)ModBlocks.fluidBlood, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(new ResourceLocation("vampirism", "fluids"), "blood");
            }
        });
        ModelLoader.setCustomStateMapper((Block)ModBlocks.coffin, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(new ResourceLocation("vampirism", "block_coffin"), "normal");
            }
        });
        ModelLoader.setCustomStateMapper((Block)ModBlocks.tentMain, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)ModBlocks.tent), this.func_178131_a((Map)state.func_177228_b()));
            }
        });
        ModelLoader.setCustomStateMapper((Block)ModBlocks.alchemicalFire, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(new ResourceLocation("vampirism", "alchemical_fire"), "normal");
            }
        });
    }

    private static void registerTileRenderer() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileCoffin.class, (TileEntitySpecialRenderer)new CoffinTESR());
        ClientRegistry.bindTileEntitySpecialRenderer(TileAltarInfusion.class, (TileEntitySpecialRenderer)new AltarInfusionTESR());
    }
}

