/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.tiles;

import de.teamlapen.vampirism.client.render.tiles.VampirismTESR;
import de.teamlapen.vampirism.tileentity.TileAltarInfusion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class AltarInfusionTESR
extends VampirismTESR<TileAltarInfusion> {
    private final ResourceLocation enderDragonCrystalBeamTextures = new ResourceLocation("textures/entity/endercrystal/endercrystal_beam.png");
    private final ResourceLocation beaconBeamTexture = new ResourceLocation("textures/entity/beacon_beam.png");

    public void renderTileEntityAt(TileAltarInfusion te, double x, double y, double z, float partialTicks, int destroyStage) {
        TileAltarInfusion.PHASE phase = te.getCurrentPhase();
        if (phase == TileAltarInfusion.PHASE.BEAM1 || phase == TileAltarInfusion.PHASE.BEAM2) {
            x += 0.5;
            y += 3.0;
            z += 0.5;
            double cX = (double)te.func_174877_v().func_177958_n() + 0.5;
            double cY = te.func_174877_v().func_177956_o() + 3;
            double cZ = (double)te.func_174877_v().func_177952_p() + 0.5;
            try {
                EntityPlayer p;
                BlockPos[] tips = te.getTips();
                for (int i = 0; i < tips.length; ++i) {
                    this.renderBeam(x, y, z, cX, cY, cZ, (double)tips[i].func_177958_n() + 0.5, (double)tips[i].func_177956_o() + 0.5, (double)tips[i].func_177952_p() + 0.5, (float)te.getRunningTick() + partialTicks, false);
                }
                if (phase == TileAltarInfusion.PHASE.BEAM2 && (p = te.getPlayer()) != null) {
                    double rX = 0.0;
                    double rZ = 0.0;
                    double rY = -0.3;
                    double playerY = p.field_70163_u;
                    if (!p.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
                        EntityPlayerSP e = Minecraft.func_71410_x().field_71439_g;
                        rX += p.field_70165_t - e.field_70165_t;
                        rY += p.field_70163_u - e.field_70163_u + 1.5;
                        rZ += p.field_70161_v - e.field_70161_v;
                        playerY += 1.5;
                    }
                    this.renderBeam(rX, rY, rZ, p.field_70165_t, playerY, p.field_70161_v, cX, cY + 0.2, cZ, -((float)te.getRunningTick() + partialTicks), true);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private void renderBeam(double relX, double relY, double relZ, double centerX, double centerY, double centerZ, double targetX, double targetY, double targetZ, float tickStuff, boolean beacon) {
        float f2 = 50000.0f;
        float f3 = MathHelper.func_76126_a((float)(f2 * 0.2f)) / 2.0f + 0.5f;
        f3 = (f3 * f3 + f3) * 0.2f;
        float wayX = (float)(targetX - centerX);
        float wayY = (float)(targetY - centerY);
        float wayZ = (float)(targetZ - centerZ);
        float distFlat = MathHelper.func_76129_c((float)(wayX * wayX + wayZ * wayZ));
        float dist = MathHelper.func_76129_c((float)(wayX * wayX + wayY * wayY + wayZ * wayZ));
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)relX, (double)relY, (double)relZ);
        GlStateManager.func_179114_b((float)((float)(-Math.atan2(wayZ, wayX)) * 180.0f / (float)Math.PI - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(-Math.atan2(distFlat, wayY)) * 180.0f / (float)Math.PI - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        RenderHelper.func_74518_a();
        GlStateManager.func_179129_p();
        if (beacon) {
            this.func_147499_a(this.beaconBeamTexture);
        } else {
            this.func_147499_a(this.enderDragonCrystalBeamTextures);
        }
        GlStateManager.func_179103_j((int)7425);
        float f9 = -(tickStuff * 0.005f);
        float f10 = MathHelper.func_76129_c((float)(wayX * wayX + wayY * wayY + wayZ * wayZ)) / 32.0f + f9;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(5, DefaultVertexFormats.field_181709_i);
        int b0 = 8;
        for (int i = 0; i <= b0; ++i) {
            float f11 = 0.2f * (MathHelper.func_76126_a((float)((float)(i % b0) * (float)Math.PI * 2.0f / (float)b0)) * 0.75f);
            float f12 = 0.2f * (MathHelper.func_76134_b((float)((float)(i % b0) * (float)Math.PI * 2.0f / (float)b0)) * 0.75f);
            float f13 = (float)(i % b0) * 1.0f / (float)b0;
            worldRenderer.func_181662_b((double)f11, (double)f12, 0.0).func_187315_a((double)f13, (double)f10).func_181669_b(255, 0, 0, 255).func_181675_d();
            if (beacon) {
                worldRenderer.func_181662_b((double)f11, (double)f12, (double)dist).func_187315_a((double)f13, (double)f9).func_181669_b(255, 0, 0, 255).func_181675_d();
                continue;
            }
            worldRenderer.func_181662_b((double)f11, (double)f12, (double)dist).func_187315_a((double)f13, (double)f9).func_181669_b(255, 255, 255, 255).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179089_o();
        RenderHelper.func_74519_b();
        GL11.glPopMatrix();
    }
}

