/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.google.common.collect.Sets;
import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.IVampirismEntityRegistry;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.entity.EntityAreaParticleCloud;
import de.teamlapen.vampirism.entity.EntityBlindingBat;
import de.teamlapen.vampirism.entity.EntityCrossbowArrow;
import de.teamlapen.vampirism.entity.EntityGhost;
import de.teamlapen.vampirism.entity.EntityThrowableItem;
import de.teamlapen.vampirism.entity.ExtendedHorse;
import de.teamlapen.vampirism.entity.converted.EntityConvertedCreature;
import de.teamlapen.vampirism.entity.converted.EntityConvertedSheep;
import de.teamlapen.vampirism.entity.converted.EntityConvertedVillager;
import de.teamlapen.vampirism.entity.hunter.EntityAdvancedHunter;
import de.teamlapen.vampirism.entity.hunter.EntityBasicHunter;
import de.teamlapen.vampirism.entity.hunter.EntityHunterTrainer;
import de.teamlapen.vampirism.entity.hunter.EntityHunterVillager;
import de.teamlapen.vampirism.entity.minions.vampire.EntityVampireMinionSaveable;
import de.teamlapen.vampirism.entity.vampire.EntityAdvancedVampire;
import de.teamlapen.vampirism.entity.vampire.EntityBasicVampire;
import de.teamlapen.vampirism.entity.vampire.EntityDummyBittenAnimal;
import de.teamlapen.vampirism.entity.vampire.EntityVampireBaron;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class ModEntities {
    public static final String BASIC_HUNTER_NAME = "vampirism.vampireHunter";
    public static final String BASIC_VAMPIRE_NAME = "vampirism.vampire";
    public static final String DRACULA_NAME = "vampirism.dracula";
    public static final String GHOST_NAME = "vampirism.ghost";
    public static final String VAMPIRE_BARON = "vampirism.vampireBaron";
    public static final String VAMPIRE_MINION_REMOTE_NAME = "vampirism.vampireMinionR";
    public static final String VAMPIRE_MINION_SAVEABLE_NAME = "vampirism.vampireMinionS";
    public static final String DEAD_MOB_NAME = "vampirism.dead_mob";
    public static final String BLINDING_BAT_NAME = "vampirism.blinding_bat";
    public static final String DUMMY_CREATURE = "vampirism.dummy_creature";
    public static final String PORTAL_GUARD = "vampirism.portal_guard";
    public static final String CONVERTED_CREATURE = "vampirism.converted.creature";
    public static final String CONVERTED_VILLAGER = "vampirism.converted.villager";
    public static final String CONVERTED_SHEEP = "vampirism.converted.sheep";
    public static final String HUNTER_TRAINER = "vampirism.hunter_trainer";
    public static final String ADVANCED_HUNTER = "vampirism.advanced_hunter";
    public static final String ADVANCED_VAMPIRE = "vampirism.advanced_vampire";
    public static final String HUNTER_VILLAGER = "vampirism.hunter_villager";
    public static final String CROSSBOW_ARROW = "vampirism.crossbow_arrow";
    public static final String PARTICLE_CLOUD = "vampirism.particle_cloud";
    public static final String THROWABLE_ITEM = "vampirism.throwable_item";
    public static final List<String> spawnableEntityNames = new ArrayList<String>();
    private static int modEntityId = 0;

    public static void onInitStep(IInitListener.Step step, FMLStateEvent event) {
        switch (step) {
            case PRE_INIT: {
                ModEntities.preInit((FMLPreInitializationEvent)event);
                break;
            }
            case INIT: {
                break;
            }
        }
    }

    private static void registerCustomExtendedCreatures() {
        IVampirismEntityRegistry registry = VampirismAPI.biteableRegistry();
        registry.addCustomExtendedCreature(EntityHorse.class, new IVampirismEntityRegistry.IExtendedCreatureConstructor<EntityHorse>(){

            @Override
            public IExtendedCreatureVampirism create(EntityHorse creature) {
                return new ExtendedHorse(creature);
            }
        });
    }

    private static void registerConvertibles() {
        String base = "vampirism:textures/entity/vanilla/%s_overlay.png";
        IVampirismEntityRegistry registry = VampirismAPI.biteableRegistry();
        registry.addConvertible(EntityCow.class, String.format(base, "cow"));
        registry.addConvertible(EntityPig.class, String.format(base, "pig"));
        registry.addConvertible(EntityOcelot.class, String.format(base, "cat"));
        registry.addConvertible(EntityHorse.class, String.format(base, "horse"));
        registry.addConvertible(EntityPolarBear.class, String.format(base, "polarbear"));
        registry.addConvertible(EntityRabbit.class, String.format(base, "rabbit"));
        registry.addConvertible(EntitySheep.class, String.format(base, "sheep"), new EntityConvertedSheep.ConvertingHandler());
        registry.addConvertible(EntityVillager.class, null, new EntityConvertedVillager.ConvertingHandler());
    }

    private static void preInit(FMLPreInitializationEvent event) {
        Set allBiomes = Biome.field_150597_n;
        HashSet zombieBiomes = Sets.newHashSet();
        zombieBiomes.addAll(allBiomes);
        zombieBiomes.remove(Biomes.field_76789_p);
        zombieBiomes.remove(Biomes.field_76788_q);
        zombieBiomes.remove(Biomes.field_76778_j);
        zombieBiomes.remove(Biomes.field_76779_k);
        Iterator iterator = zombieBiomes.iterator();
        while (iterator.hasNext()) {
            Biome b = (Biome)iterator.next();
            if (b == null || b.func_150562_l().getName().startsWith("net.minecraft.") || b.func_150562_l().getName().startsWith("de.teamlapen.")) continue;
            Iterator iterator2 = b.func_76747_a(EnumCreatureType.MONSTER).iterator();
            boolean zombie = false;
            while (iterator2.hasNext()) {
                if (!((Biome.SpawnListEntry)iterator2.next()).field_76300_b.equals(EntityZombie.class)) continue;
                zombie = true;
                break;
            }
            if (zombie) continue;
            VampirismMod.log.d("ModEntities", "In biome %s no vampire will spawn", b);
            iterator.remove();
        }
        ModEntities.registerEntity(EntityBlindingBat.class, BLINDING_BAT_NAME, EntityLiving.SpawnPlacementType.IN_AIR, false);
        ModEntities.registerEntity(EntityGhost.class, GHOST_NAME, EntityLiving.SpawnPlacementType.ON_GROUND, true);
        ModEntities.registerEntity(EntityConvertedCreature.class, CONVERTED_CREATURE, EntityLiving.SpawnPlacementType.ON_GROUND, false);
        ModEntities.registerEntity(EntityConvertedSheep.class, CONVERTED_SHEEP, EntityLiving.SpawnPlacementType.ON_GROUND, false);
        ModEntities.registerEntity(EntityBasicHunter.class, BASIC_HUNTER_NAME, EntityLiving.SpawnPlacementType.ON_GROUND, true);
        ModEntities.registerEntity(EntityBasicVampire.class, BASIC_VAMPIRE_NAME, EntityLiving.SpawnPlacementType.ON_GROUND, Balance.mobProps.VAMPIRE_SPAWN_CHANCE, 1, 2, EnumCreatureType.MONSTER, zombieBiomes.toArray(new Biome[zombieBiomes.size()]));
        ModEntities.registerEntity(EntityHunterTrainer.class, HUNTER_TRAINER, EntityLiving.SpawnPlacementType.ON_GROUND, true);
        ModEntities.registerEntity(EntityAdvancedHunter.class, ADVANCED_HUNTER, EntityLiving.SpawnPlacementType.ON_GROUND, true);
        ModEntities.registerEntity(EntityVampireBaron.class, VAMPIRE_BARON, EntityLiving.SpawnPlacementType.ON_GROUND, true);
        ModEntities.registerEntity(EntityVampireMinionSaveable.class, VAMPIRE_MINION_SAVEABLE_NAME, EntityLiving.SpawnPlacementType.ON_GROUND, false);
        ModEntities.registerEntity(EntityDummyBittenAnimal.class, DUMMY_CREATURE, EntityLiving.SpawnPlacementType.ON_GROUND, false);
        ModEntities.registerEntity(EntityAdvancedVampire.class, ADVANCED_VAMPIRE, EntityLiving.SpawnPlacementType.ON_GROUND, Balance.mobProps.ADVANCED_VAMPIRE_SPAWN_PROBE, 1, 1, EnumCreatureType.MONSTER, zombieBiomes.toArray(new Biome[zombieBiomes.size()]));
        ModEntities.registerEntity(EntityConvertedVillager.class, CONVERTED_VILLAGER, EntityLiving.SpawnPlacementType.ON_GROUND, false);
        ModEntities.registerEntity(EntityHunterVillager.class, HUNTER_VILLAGER, EntityLiving.SpawnPlacementType.ON_GROUND, false);
        ModEntities.registerEntity(EntityCrossbowArrow.class, CROSSBOW_ARROW, EntityLiving.SpawnPlacementType.IN_AIR, false);
        ModEntities.registerEntity(EntityAreaParticleCloud.class, PARTICLE_CLOUD, EntityLiving.SpawnPlacementType.IN_AIR, false);
        ModEntities.registerEntity(EntityThrowableItem.class, THROWABLE_ITEM, EntityLiving.SpawnPlacementType.IN_AIR, false);
        ModEntities.registerConvertibles();
        ModEntities.registerCustomExtendedCreatures();
    }

    private static void registerEntity(Class<? extends Entity> clazz, String name, EntityLiving.SpawnPlacementType placementType, boolean egg) {
        EntityRegistry.registerModEntity(clazz, (String)name.replace("vampirism.", ""), (int)modEntityId++, (Object)VampirismMod.instance, (int)80, (int)1, (boolean)true);
        if (egg) {
            EntityRegistry.registerEgg(clazz, (int)9115043, (int)name.hashCode());
            spawnableEntityNames.add(name);
        }
    }

    private static void registerEntity(Class<? extends EntityLiving> clazz, String name, EntityLiving.SpawnPlacementType placementType, int probe, int min, int max, EnumCreatureType type, Biome ... biomes) {
        ModEntities.registerEntity(clazz, name, placementType, true);
        EntityRegistry.addSpawn(clazz, (int)probe, (int)min, (int)max, (EnumCreatureType)type, (Biome[])biomes);
    }
}

