/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;

public class DamageHandler {
    public static void affectVampireGarlicSplash(IVampire vampire, EnumStrength strength, double distSq, boolean directHit) {
        if (vampire.doesResistGarlic(strength)) {
            return;
        }
        if (distSq < 16.0) {
            double affect = 1.0 - Math.sqrt(distSq) / 4.0;
            if (directHit) {
                affect = 1.0;
            }
            DamageHandler.affectVampireGarlic(vampire, strength, (float)(10.0 * affect), false);
        }
    }

    public static void affectVampireGarlicDirect(IVampire vampire, EnumStrength strength) {
        DamageHandler.affectVampireGarlic(vampire, strength, 20.0f, false);
    }

    private static void affectVampireGarlic(IVampire vampire, EnumStrength strength, float multiplier, boolean ambient) {
        IActionHandler<IVampirePlayer> actionHandler;
        if (strength == EnumStrength.NONE) {
            return;
        }
        EntityLivingBase entity = vampire.getRepresentingEntity();
        entity.func_70690_d(new PotionEffect(ModPotions.garlic, (int)(multiplier * 20.0f), strength.getStrength() - 1, ambient, true));
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            return;
        }
        entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, (int)(multiplier * 20.0f), 1, ambient, false));
        if (strength == EnumStrength.MEDIUM || strength == EnumStrength.STRONG) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(multiplier * 20.0f), 1, ambient, false));
            if (strength == EnumStrength.STRONG) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76440_q, (int)(multiplier / 2.0f * 20.0f), 0, ambient, false));
            }
        }
        if (vampire instanceof IVampirePlayer && (actionHandler = ((IVampirePlayer)vampire).getActionHandler()).isActionActive(VampireActions.disguiseAction)) {
            actionHandler.toggleAction(VampireActions.disguiseAction);
        }
    }

    public static void affectVampireGarlicAmbient(IVampire vampire, EnumStrength strength, int ticks) {
        if (ticks % 37 == 7) {
            DamageHandler.affectVampireGarlic(vampire, strength, 5.0f, true);
        }
    }

    public static void affectEntityHolyWaterSplash(EntityLivingBase entity, EnumStrength strength, double distSq, boolean directHit) {
        boolean vampire = Helper.isVampire((Entity)entity);
        if (entity.func_184603_cC() && (vampire || EnumCreatureAttribute.UNDEAD.equals((Object)entity.func_70668_bt())) && distSq < 16.0) {
            double affect = 1.0 - Math.sqrt(distSq) / 4.0;
            if (directHit) {
                affect = 1.0;
            }
            if (!vampire) {
                affect *= 0.5;
            }
            double amount = affect * ((double)Balance.general.HOLY_WATER_SPLASH_DAMAGE * (strength == EnumStrength.WEAK ? 1.0 : (strength == EnumStrength.MEDIUM ? Balance.general.HOLY_WATER_TIER_DAMAGE_INC : Balance.general.HOLY_WATER_TIER_DAMAGE_INC * Balance.general.HOLY_WATER_TIER_DAMAGE_INC))) + 0.5;
            if (entity instanceof EntityPlayer) {
                int l = VampirePlayer.get((EntityPlayer)entity).getLevel();
                amount = DamageHandler.scaleDamageWithLevel(l, amount * 0.8, amount * 1.1);
            }
            entity.func_70097_a(VReference.HOLY_WATER, (float)amount);
        }
        if (vampire && entity instanceof EntityPlayer) {
            IActionHandler<IVampirePlayer> actionHandler = VampirePlayer.get((EntityPlayer)entity).getActionHandler();
            if (actionHandler.isActionActive(VampireActions.disguiseAction)) {
                actionHandler.toggleAction(VampireActions.disguiseAction);
            }
            if (actionHandler.isActionActive(VampireActions.invisibilityAction)) {
                actionHandler.toggleAction(VampireActions.invisibilityAction);
            }
        }
    }

    private static double scaleDamageWithLevel(int level, double minDamage, double maxDamage) {
        return minDamage + (double)level / 14.0 * (maxDamage - minDamage);
    }
}

