/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import com.google.common.base.Predicate;
import de.teamlapen.lib.lib.util.ItemStackUtil;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.minions.IMinionLordWithSaveable;
import de.teamlapen.vampirism.api.items.IFactionSlayerItem;
import de.teamlapen.vampirism.blocks.BlockCastleBlock;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.inventory.BloodPotionTableContainer;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.potion.FakeNightVisionPotion;
import de.teamlapen.vampirism.util.DifficultyCalculator;
import de.teamlapen.vampirism.util.REFERENCE;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModEntityEventHandler {
    private boolean skipAttackDamageOnce = false;

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent.Entity event) {
        if (event.getEntity() instanceof EntityCreature) {
            event.addCapability(REFERENCE.EXTENDED_CREATURE_KEY, ExtendedCreature.createNewCapability((EntityCreature)event.getEntity()));
        }
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        ItemStack stack;
        if (!this.skipAttackDamageOnce && "player".equals(event.getSource().func_76355_l()) && event.getSource().func_76346_g() instanceof EntityPlayer && !ItemStackUtil.isEmpty(stack = ((EntityPlayer)event.getSource().func_76346_g()).func_184614_ca()) && stack.func_77973_b() instanceof IFactionSlayerItem) {
            IFactionSlayerItem item = (IFactionSlayerItem)stack.func_77973_b();
            IFaction faction = VampirismAPI.factionRegistry().getFaction(event.getEntity());
            if (faction != null && faction.equals(item.getSlayedFaction())) {
                float amt = event.getAmount() * item.getDamageMultiplierForFaction(stack);
                this.skipAttackDamageOnce = true;
                boolean result = ForgeHooks.onLivingAttack((EntityLivingBase)event.getEntityLiving(), (DamageSource)event.getSource(), (float)amt);
                this.skipAttackDamageOnce = false;
                event.setCanceled(!result);
            }
        }
    }

    @SubscribeEvent
    public void onEntityCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        IBlockState blockState = event.getWorld().func_180495_p(new BlockPos((double)(event.getX() - 0.4f), (double)event.getY(), (double)(event.getZ() - 0.4f)).func_177977_b());
        if (blockState.func_177230_c().equals((Object)ModBlocks.castleBlock) && (BlockCastleBlock.EnumType.DARK_STONE.equals(blockState.func_177229_b(BlockCastleBlock.VARIANT)) || !event.getEntity().isCreatureType(VReference.VAMPIRE_CREATURE_TYPE, false))) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        IAdjustableLevel entity;
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof IAdjustableLevel && (entity = (IAdjustableLevel)event.getEntity()).getLevel() == -1) {
            Difficulty d = DifficultyCalculator.findDifficultyForPos(event.getWorld(), event.getEntity().func_180425_c(), 30);
            int l = entity.suggestLevel(d);
            if (l > entity.getMaxLevel()) {
                l = entity.getMaxLevel();
            } else if (l < 0) {
                event.setCanceled(true);
            }
            entity.setLevel(l);
            if (entity instanceof EntityCreature) {
                ((EntityCreature)entity).func_70606_j(((EntityCreature)entity).func_110138_aP());
            }
        }
        if (!event.getWorld().field_72995_K && !Balance.vps.DISABLE_AVOIDED_BY_CREEPERS && event.getEntity() instanceof EntityCreeper) {
            ((EntityCreeper)event.getEntity()).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)((EntityCreeper)event.getEntity()), EntityPlayer.class, (Predicate)new Predicate<EntityPlayer>(){

                public boolean apply(@Nullable EntityPlayer input) {
                    return input != null && VampirePlayer.get((EntityPlayer)input).getSpecialAttributes().avoided_by_creepers;
                }
            }, 20.0f, 1.1, 1.3));
            EntityAIBase target = null;
            for (EntityAITasks.EntityAITaskEntry t : ((EntityCreeper)event.getEntity()).field_70715_bh.field_75782_a) {
                if (!(t.field_75733_a instanceof EntityAINearestAttackableTarget) || t.field_75731_b != 1) continue;
                target = t.field_75733_a;
            }
            if (target != null) {
                ((EntityCreeper)event.getEntity()).field_70715_bh.func_85156_a(target);
                ((EntityCreeper)event.getEntity()).field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)((EntityCreeper)event.getEntity()), EntityPlayer.class, 10, true, false, (Predicate)new Predicate<EntityPlayer>(){

                    public boolean apply(@Nullable EntityPlayer input) {
                        return input != null && !VampirePlayer.get((EntityPlayer)input).getSpecialAttributes().avoided_by_creepers;
                    }
                }));
            } else {
                VampirismMod.log.w("EntityEventHandler", "Could not replace creeper target task", new Object[0]);
            }
        }
        if (event.getEntity() instanceof IMinionLordWithSaveable) {
            ((IMinionLordWithSaveable)event.getEntity()).getSaveableMinionHandler().addLoadedMinions();
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityCreature) {
            event.getEntity().func_130014_f_().field_72984_F.func_76320_a("vampirism_extended_creature");
            ExtendedCreature.get((EntityCreature)event.getEntity()).onUpdate();
            event.getEntity().func_130014_f_().field_72984_F.func_76319_b();
        } else if (!event.getEntity().func_130014_f_().field_72995_K && event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (player.field_71070_bA instanceof BloodPotionTableContainer) {
                ((BloodPotionTableContainer)player.field_71070_bA).tick();
            }
        }
        PotionEffect vanillaNightVision = null;
        if (FakeNightVisionPotion.vanillaInstance != null && (vanillaNightVision = event.getEntityLiving().func_70660_b(FakeNightVisionPotion.vanillaInstance)) != null) {
            event.getEntityLiving().func_184589_d(FakeNightVisionPotion.vanillaInstance);
            event.getEntityLiving().func_70690_d(new PotionEffect((Potion)ModPotions.fakeNightVisionPotion, vanillaNightVision.func_76459_b(), vanillaNightVision.func_76458_c(), vanillaNightVision.func_82720_e(), vanillaNightVision.func_188418_e()));
            VampirismMod.log.d("EntityEventHandler", "Replacing vanilla night vision potion effect by modified potion effect", new Object[0]);
        }
    }
}

