/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import com.google.common.base.Predicate;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class VampirismEntitySelectors {
    private static void addFactionSelector(List<Predicate<Entity>> list, Map<String, String> arguments, ICommandSender sender) {
        String faction = arguments.get("vampirism:faction");
        if (faction != null) {
            IFaction[] factions;
            final boolean invert = faction.startsWith("!");
            if (invert) {
                faction = faction.substring(1);
            }
            for (final IFaction f : factions = VampirismAPI.factionRegistry().getFactions()) {
                if (!f.name().equalsIgnoreCase(faction)) continue;
                list.add(new Predicate<Entity>(){

                    public boolean apply(@Nullable Entity input) {
                        if (input instanceof IFactionEntity) {
                            boolean flag1 = f.equals(((IFactionEntity)input).getFaction());
                            return invert != flag1;
                        }
                        if (f instanceof IPlayableFaction && input instanceof EntityPlayer) {
                            boolean flag1 = FactionPlayerHandler.get((EntityPlayer)input).isInFaction((IPlayableFaction)f);
                            return invert != flag1;
                        }
                        return invert;
                    }
                });
                return;
            }
            list.add(new Predicate<Entity>(){

                public boolean apply(@Nullable Entity input) {
                    return false;
                }
            });
            sender.func_145747_a((ITextComponent)new TextComponentString("Unknown faction: " + faction));
        }
    }

    private static void addLevelSelector(List<Predicate<Entity>> list, Map<String, String> arguments) {
        String maxLevel;
        String minLevel;
        String level = arguments.get("vampirism:level");
        if (level != null) {
            try {
                final int l = Integer.parseInt(level);
                list.add(new Predicate<Entity>(){

                    public boolean apply(@Nullable Entity input) {
                        if (input instanceof EntityPlayer) {
                            return FactionPlayerHandler.get((EntityPlayer)input).getCurrentLevel() == l;
                        }
                        return false;
                    }
                });
            }
            catch (NumberFormatException e) {
                VampirismMod.log.w("EntitySelectors", "Failed to parse level (%s)", level);
            }
        }
        if ((minLevel = arguments.get("vampirism:minLevel")) != null) {
            try {
                final int l = Integer.parseInt(minLevel);
                list.add(new Predicate<Entity>(){

                    public boolean apply(@Nullable Entity input) {
                        if (input instanceof EntityPlayer) {
                            return FactionPlayerHandler.get((EntityPlayer)input).getCurrentLevel() >= l;
                        }
                        return false;
                    }
                });
            }
            catch (NumberFormatException e) {
                VampirismMod.log.w("EntitySelectors", "Failed to parse level (%s)", level);
            }
        }
        if ((maxLevel = arguments.get("vampirism:maxLevel")) != null) {
            try {
                final int l = Integer.parseInt(maxLevel);
                list.add(new Predicate<Entity>(){

                    public boolean apply(@Nullable Entity input) {
                        if (input instanceof EntityPlayer) {
                            return FactionPlayerHandler.get((EntityPlayer)input).getCurrentLevel() <= l;
                        }
                        return false;
                    }
                });
            }
            catch (NumberFormatException e) {
                VampirismMod.log.w("EntitySelectors", "Failed to parse level (%s)", level);
            }
        }
    }

    public static void gatherEntitySelectors(List<Predicate<Entity>> list, Map<String, String> map, String mainSelector, ICommandSender sender, Vec3d position) {
        VampirismEntitySelectors.addFactionSelector(list, map, sender);
        VampirismEntitySelectors.addLevelSelector(list, map);
    }
}

