/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.entity.converted.EntityConvertedCreature;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;

public class DefaultConvertingHandler<T extends EntityCreature>
implements IConvertingHandler<T> {
    private static final IConvertingHandler.IDefaultHelper defaultHelper = new IConvertingHandler.IDefaultHelper(){

        public void dropConvertedItems(EntityCreature entity, boolean recentlyHit, int looting) {
            int j;
            if (entity instanceof EntityCow) {
                int k;
                int j2 = entity.func_70681_au().nextInt(3) + entity.func_70681_au().nextInt(1 + looting);
                for (k = 0; k < j2; ++k) {
                    entity.func_145779_a(Items.field_151116_aA, 1);
                }
                j2 = entity.func_70681_au().nextInt(3) + entity.func_70681_au().nextInt(1 + looting);
                for (k = 0; k < j2; ++k) {
                    entity.func_145779_a(Items.field_151078_bh, 1);
                }
            } else if (entity instanceof EntityPig) {
                int j3 = entity.func_70681_au().nextInt(3) + entity.func_70681_au().nextInt(1 + looting);
                for (int k = 0; k < j3; ++k) {
                    entity.func_145779_a(Items.field_151078_bh, 1);
                }
            } else if (entity instanceof EntityPolarBear) {
                int k;
                int j4 = entity.func_70681_au().nextInt(3);
                if (j4 > 0) {
                    entity.func_145779_a(Items.field_151115_aP, j4);
                }
                if ((k = entity.func_70681_au().nextInt(2)) > 0) {
                    entity.func_145779_a(Items.field_151078_bh, k);
                }
            } else if (entity instanceof EntityRabbit && (j = entity.func_70681_au().nextInt(2)) > 0) {
                entity.func_145779_a(Items.field_179555_bs, j);
            }
        }

        public double getConvertedDMG(EntityCreature entity) {
            IAttributeInstance dmg = entity.func_110148_a(SharedMonsterAttributes.field_111264_e);
            if (dmg != null) {
                return dmg.func_111125_b() * 1.3;
            }
            return Balance.mobProps.CONVERTED_MOB_DEFAULT_DMG;
        }

        public double getConvertedKnockbackResistance(EntityCreature entity) {
            return entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111125_b();
        }

        public double getConvertedMaxHealth(EntityCreature entity) {
            return entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() * 1.5;
        }

        public double getConvertedSpeed(EntityCreature entity) {
            return Math.min(entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() * 1.2, 2.9);
        }
    };
    protected final IConvertingHandler.IDefaultHelper helper;

    public DefaultConvertingHandler(@Nullable IConvertingHandler.IDefaultHelper helper) {
        this.helper = helper == null ? defaultHelper : helper;
    }

    @Override
    public IConvertedCreature<T> createFrom(T entity) {
        EntityConvertedCreature convertedCreature = new EntityConvertedCreature(entity.func_130014_f_());
        this.copyImportantStuff(convertedCreature, entity);
        convertedCreature.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200, 2));
        return convertedCreature;
    }

    public IConvertingHandler.IDefaultHelper<T> getHelper() {
        return this.helper;
    }

    protected void copyImportantStuff(EntityConvertedCreature converted, T entity) {
        converted.func_82149_j((Entity)entity);
        converted.setEntityCreature(entity);
        converted.updateEntityAttributes();
        converted.func_70606_j(converted.func_110138_aP() / 3.0f * 2.0f);
    }
}

