/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.BiteableEntry;
import de.teamlapen.vampirism.api.entity.IVampirismEntityRegistry;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VampirismEntityRegistry
implements IVampirismEntityRegistry {
    private final Map<String, Integer> bloodValues = new HashMap<String, Integer>();
    private final Map<String, Integer> overridingValues = new HashMap<String, Integer>();
    private final Map<Class<? extends EntityCreature>, IConvertingHandler> convertibles = new HashMap<Class<? extends EntityCreature>, IConvertingHandler>();
    private final Map<Class<? extends EntityCreature>, String> convertibleOverlay = new HashMap<Class<? extends EntityCreature>, String>();
    private final Map<Class<? extends EntityCreature>, IVampirismEntityRegistry.IExtendedCreatureConstructor> extendedCreatureConstructors = new HashMap<Class<? extends EntityCreature>, IVampirismEntityRegistry.IExtendedCreatureConstructor>();
    private final String TAG = "VampirismEntityRegistry";
    private final Map<String, BiteableEntry> biteables = new HashMap<String, BiteableEntry>();
    private boolean finished = false;
    private IVampirismEntityRegistry.ICreateDefaultConvertingHandler defaultConvertingHandlerCreator;

    @Override
    public void addBloodValue(String entityId, int value) {
        this.bloodValues.put(entityId, value);
    }

    @Override
    public void addBloodValues(Map<String, Integer> values) {
        this.bloodValues.putAll(values);
    }

    @Override
    public void addConvertible(Class<? extends EntityCreature> clazz, String overlay_loc) {
        this.addConvertible(clazz, overlay_loc, (IConvertingHandler)null);
    }

    @Override
    public void addConvertible(Class<? extends EntityCreature> clazz, String overlay_loc, IConvertingHandler.IDefaultHelper helper) {
        this.addConvertible(clazz, overlay_loc, this.defaultConvertingHandlerCreator.create(helper));
    }

    @Override
    public void addConvertible(Class<? extends EntityCreature> clazz, String overlay_loc, IConvertingHandler handler) {
        this.convertibles.put(clazz, handler);
        if (FMLCommonHandler.instance().getSide().isClient() && overlay_loc != null) {
            this.convertibleOverlay.put(clazz, overlay_loc);
        }
    }

    @Override
    public <T extends EntityCreature> void addCustomExtendedCreature(Class<? extends T> clazz, IVampirismEntityRegistry.IExtendedCreatureConstructor<T> constructor) {
        this.extendedCreatureConstructors.put(clazz, constructor);
    }

    @Override
    @Nullable
    public IConvertedCreature convert(EntityCreature entity) {
        String s = EntityList.func_75621_b((Entity)entity);
        BiteableEntry b = this.biteables.get(s);
        if (b != null && b.convertingHandler != null) {
            return b.convertingHandler.createFrom(entity);
        }
        VampirismMod.log.w("VampirismEntityRegistry", "Failed to find convertible entry for %s", entity);
        return null;
    }

    public void finishRegistration(int defaultDamage) {
        if (this.finished) {
            return;
        }
        this.bloodValues.putAll(this.overridingValues);
        float bloodValueMultiplier = 1.0f;
        Integer i = this.bloodValues.get("multiplier");
        if (i != null) {
            bloodValueMultiplier = (float)i.intValue() / 10.0f;
        }
        IConvertingHandler defaultHandler = this.defaultConvertingHandlerCreator.create(null);
        for (Map.Entry<Class<? extends EntityCreature>, IConvertingHandler> entry : this.convertibles.entrySet()) {
            String entity_name = (String)EntityList.field_75626_c.get(entry.getKey());
            if (entity_name == null) {
                VampirismMod.log.w("VampirismEntityRegistry", "Cannot register convertible %s since there is no EntityString for it", entry.getKey());
                continue;
            }
            Integer blood = this.bloodValues.remove(entity_name);
            if (blood == null) {
                VampirismMod.log.w("VampirismEntityRegistry", "Missing blood value for convertible creature %s (%s)", entry.getKey().getName(), entity_name);
                continue;
            }
            blood = Math.round((float)blood.intValue() * bloodValueMultiplier);
            VampirismMod.log.i("VampirismEntityRegistry", " Registering convertible %s with blood %d and handler %s", entry.getKey().getName(), blood, entry.getValue());
            BiteableEntry biteEntry = new BiteableEntry(blood, entry.getValue() == null ? defaultHandler : entry.getValue());
            this.biteables.put(entity_name, biteEntry);
        }
        for (Map.Entry<Object, Object> entry : this.bloodValues.entrySet()) {
            this.biteables.put((String)entry.getKey(), new BiteableEntry(Math.abs(Math.round((float)((Integer)entry.getValue()).intValue() * bloodValueMultiplier))));
        }
        this.bloodValues.clear();
        this.convertibles.clear();
        this.finished = true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Map<Class<? extends EntityCreature>, String> getConvertibleOverlay() {
        return this.convertibleOverlay;
    }

    @Override
    @Nullable
    public <T extends EntityCreature> IVampirismEntityRegistry.IExtendedCreatureConstructor<T> getCustomExtendedCreatureConstructor(T entity) {
        return this.extendedCreatureConstructors.get(entity.getClass());
    }

    @Override
    public BiteableEntry getEntry(EntityCreature creature) {
        return this.getEntry(EntityList.func_75621_b((Entity)creature));
    }

    @Override
    public BiteableEntry getEntry(String entity_name) {
        return this.biteables.get(entity_name);
    }

    @Override
    public void overrideBloodValues(Map<String, Integer> values) {
        this.overridingValues.putAll(values);
    }

    public void setDefaultConvertingHandlerCreator(IVampirismEntityRegistry.ICreateDefaultConvertingHandler creator) {
        this.defaultConvertingHandlerCreator = creator;
    }
}

