/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.util.text.TextFormatting;

public class Faction<T extends IFactionEntity>
implements IFaction<T> {
    private static int nextId = 0;
    protected final String name;
    protected final Class<T> entityInterface;
    private final int color;
    protected String unlocalizedName;
    protected String unlocalizedNamePlural;
    private int id;
    private TextFormatting chatColor;

    Faction(String name, Class<T> entityInterface, int color) {
        this.name = name;
        this.entityInterface = entityInterface;
        this.color = color;
        this.id = nextId++;
    }

    public boolean equals(Object obj) {
        return obj instanceof Faction && this.id == ((Faction)obj).id;
    }

    @Override
    public TextFormatting getChatColor() {
        return this.chatColor == null ? TextFormatting.WHITE : this.chatColor;
    }

    @Override
    public Faction<T> setChatColor(TextFormatting chatColor) {
        this.chatColor = chatColor;
        return this;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public Class<T> getEntityInterface() {
        return this.entityInterface;
    }

    @Override
    public String getUnlocalizedName() {
        return this.unlocalizedName == null ? this.name : this.unlocalizedName;
    }

    @Override
    public String getUnlocalizedNamePlural() {
        return this.unlocalizedNamePlural == null ? this.name : this.unlocalizedNamePlural;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public boolean isEntityOfFaction(EntityCreature creature) {
        return this.entityInterface.isInstance(creature);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Faction<T> setUnlocalizedName(String unlocalizedName, String unlocalizedNamePlural) {
        this.unlocalizedName = unlocalizedName;
        this.unlocalizedNamePlural = unlocalizedNamePlural;
        return this;
    }

    public String toString() {
        return "Faction{name='" + this.name + '\'' + ", id=" + this.id + '}';
    }

    protected int getId() {
        return this.id;
    }
}

