/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.hunter;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.hunter.IAdvancedHunter;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.hunter.EntityHunterBase;
import de.teamlapen.vampirism.entity.vampire.EntityVampireBase;
import de.teamlapen.vampirism.util.IPlayerFace;
import de.teamlapen.vampirism.util.SupporterManager;
import de.teamlapen.vampirism.util.VampireBookManager;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityAdvancedHunter
extends EntityHunterBase
implements IAdvancedHunter,
IPlayerFace {
    private static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(EntityAdvancedHunter.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityAdvancedHunter.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> NAME = EntityDataManager.func_187226_a(EntityAdvancedHunter.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> TEXTURE = EntityDataManager.func_187226_a(EntityAdvancedHunter.class, (DataSerializer)DataSerializers.field_187194_d);
    private final int MAX_LEVEL = 1;
    private final int MOVE_TO_RESTRICT_PRIO = 3;

    public EntityAdvancedHunter(World world) {
        super(world, true);
        this.saveHome = true;
        ((PathNavigateGround)this.func_70661_as()).func_179691_c(true);
        this.func_70105_a(0.6f, 1.8f);
        this.setDontDropEquipment();
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean flag = super.func_70652_k(entity);
        if (flag && this.func_184614_ca() == null) {
            this.func_184609_a(EnumHand.MAIN_HAND);
        }
        return flag;
    }

    public boolean func_94059_bO() {
        return true;
    }

    @Override
    public int getHunterType() {
        return (Integer)this.func_184212_Q().func_187225_a(TYPE);
    }

    @Override
    public int getLevel() {
        return (Integer)this.func_184212_Q().func_187225_a(LEVEL);
    }

    @Override
    public void setLevel(int level) {
        if (level >= 0) {
            this.func_184212_Q().func_187227_b(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 1) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 1000000, 1));
            }
        }
    }

    @Override
    public int getMaxLevel() {
        return 1;
    }

    public String func_70005_c_() {
        String senderName = (String)this.func_184212_Q().func_187225_a(NAME);
        return "none".equals(senderName) ? super.func_70005_c_() : senderName;
    }

    @Override
    @Nullable
    public String getPlayerFaceName() {
        return this.getTextureName();
    }

    @Override
    @Nullable
    public String getTextureName() {
        String texture = (String)this.func_184212_Q().func_187225_a(TEXTURE);
        return "none".equals(texture) ? null : texture;
    }

    @Override
    public boolean isLookingForHome() {
        return !this.func_110175_bO();
    }

    public void func_70020_e(NBTTagCompound tagCompund) {
        super.func_70020_e(tagCompund);
        if (tagCompund.func_74764_b("level")) {
            this.setLevel(tagCompund.func_74762_e("level"));
        }
        if (tagCompund.func_74764_b("type")) {
            this.func_184212_Q().func_187227_b(TYPE, (Object)tagCompund.func_74762_e("type"));
            this.func_184212_Q().func_187227_b(NAME, (Object)tagCompund.func_74779_i("name"));
            this.func_184212_Q().func_187227_b(TEXTURE, (Object)tagCompund.func_74779_i("texture"));
        }
    }

    @Override
    public void setCampArea(AxisAlignedBB box) {
        super.setHome(box);
        this.setMoveTowardsRestriction(3, true);
    }

    @Override
    public int suggestLevel(Difficulty d) {
        if (this.field_70146_Z.nextBoolean()) {
            return (int)((float)(d.avgPercLevel * 1) / 100.0f);
        }
        return this.field_70146_Z.nextInt(2);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("level", this.getLevel());
        nbt.func_74768_a("type", this.getHunterType());
        nbt.func_74778_a("texture", (String)this.func_184212_Q().func_187225_a(TEXTURE));
        nbt.func_74778_a("name", (String)this.func_184212_Q().func_187225_a(NAME));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.updateEntityAttributes();
    }

    protected boolean func_70692_ba() {
        return this.isLookingForHome() && super.func_70692_ba();
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        switch (this.func_70681_au().nextInt(4)) {
            case 0: {
                this.func_145779_a(ModItems.vampireBlood, 1);
                break;
            }
            case 1: {
                this.func_145779_a(ModItems.itemGarlic, 1 + this.func_70681_au().nextInt(lootingModifier + 1));
                break;
            }
            case 2: {
                ItemStack stack = ModItems.holyWaterBottle.setTier(new ItemStack((Item)ModItems.holyWaterBottle), this.func_70681_au().nextInt(4) == 0 ? IItemWithTier.TIER.ULTIMATE : IItemWithTier.TIER.ENHANCED);
                stack = ModItems.holyWaterBottle.setSplash(stack, this.func_70681_au().nextBoolean());
                this.func_70099_a(stack, 0.0f);
                break;
            }
            case 3: {
                this.func_145779_a(ModItems.holySalt, this.func_70681_au().nextInt(4) + 1);
                break;
            }
        }
        if (this.func_70681_au().nextInt(20) == 0) {
            this.func_70099_a(VampireBookManager.getInstance().getRandomBook(this.func_70681_au()), 0.0f);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        SupporterManager.Supporter supporter = SupporterManager.getInstance().getRandomHunter(this.field_70146_Z);
        this.func_184212_Q().func_187214_a(LEVEL, (Object)-1);
        this.func_184212_Q().func_187214_a(TYPE, (Object)supporter.typeId);
        this.func_184212_Q().func_187214_a(NAME, (Object)(supporter.senderName == null ? "none" : supporter.senderName));
        this.func_184212_Q().func_187214_a(TEXTURE, (Object)(supporter.textureName == null ? "none" : supporter.textureName));
    }

    protected int func_70693_a(EntityPlayer player) {
        return 10 * (1 + this.getLevel());
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.7, 50));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 13.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityVampireBase.class, 17.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, false, false, null)));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCreature.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getLevel(), 0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Balance.mobProps.ADVANCED_HUNTER_MAX_HEALTH + Balance.mobProps.ADVANCED_HUNTER_MAX_HEALTH_PL * (double)l);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Balance.mobProps.ADVANCED_HUNTER_ATTACK_DAMAGE + Balance.mobProps.ADVANCED_HUNTER_ATTACK_DAMAGE_PL * (double)l);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(Balance.mobProps.ADVANCED_HUNTER_SPEED);
    }
}

